/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import com.google.common.base.Strings;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInformation;
import java.time.LocalDate;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignDetail
extends EnrolmentModelBase<ForeignDetail> {
    private static final Logger log = LoggerFactory.getLogger(ForeignDetail.class);
    private String proofError;
    private String docNo = "";
    private ProofDocument poiDocument;
    private LocalDate issueDate;
    private LocalDate expiryDate;
    private String issueDateError;
    private String expiryDateError;
    private String docNoError;
    private String foreignType = "";
    private ProofDocument pofDocument;
    private String visaNo = "";
    private LocalDate visaIssueDate;
    private LocalDate visaExpiryDate;
    private String visaNoError;
    private String visaProofError;
    private String visaIssueDateError;
    private String visaExpiryDateError;
    private boolean validPoiIssue;
    private boolean validPofIssue;
    private boolean isPoiMandatory;
    private boolean isPofMandatory;
    private final boolean isUpdate;

    public ForeignDetail(EnrollmentService enrollmentService) {
        super(enrollmentService);
        super.setMandatory(enrollmentService.isForeignResident());
        this.validPoiIssue = false;
        this.validPofIssue = false;
        this.isPoiMandatory = this.isMandatory() && (enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isFieldEnabled(FieldInformation.POI));
        this.isPofMandatory = this.isMandatory() && (enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isFieldEnabled(FieldInformation.POF));
        this.isUpdate = enrollmentService.isUpdateUC();
        this.validate();
    }

    @Override
    public void setUpdated(boolean updated) {
        super.setUpdated(updated);
        this.isPoiMandatory = this.isMandatory() && (this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isFieldEnabled(FieldInformation.POI));
        this.isPofMandatory = this.isMandatory() && (this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isFieldEnabled(FieldInformation.POF));
        this.validate();
        super.fireChangeEvent(this);
        super.fireUpdateChangeEvent(this);
    }

    public void setValidPoiIssue(boolean valid) {
        this.validPoiIssue = !this.allowPoiLessThan182Day() || LocalDate.now().isBefore(this.issueDate) ? false : valid;
        this.validate();
    }

    public void setValidPofIssue(boolean valid) {
        this.validPofIssue = !this.allowPofLessThan182Day() || LocalDate.now().isBefore(this.visaIssueDate) ? false : valid;
        this.validate();
    }

    public boolean isValidPOF() {
        return this.validPofIssue;
    }

    public boolean isValidPOI() {
        return this.validPoiIssue;
    }

    public boolean allowPoiLessThan182Day() {
        return !this.isInvalidDocument(this.poiDocument) && (this.isUpdate || this.poiDocument.getDocName().contains("Visa") || this.poiDocument.getDocName().contains("Passport") || this.poiDocument.getDocName().contains("OCI") || this.poiDocument.getDocName().contains("VISA"));
    }

    public boolean allowPofLessThan182Day() {
        return !this.isInvalidDocument(this.pofDocument) && (this.isUpdate || this.pofDocument.getDocName().contains("Visa") || this.pofDocument.getDocName().contains("Passport") || this.pofDocument.getDocName().contains("OCI") || this.pofDocument.getDocName().contains("VISA"));
    }

    public boolean poiDocRequiredExpiryDate() {
        return this.poiDocument != null && !this.poiDocument.getDocName().contains("Voter") && !this.poiDocument.getDocName().contains("Citizenship") && !this.poiDocument.getDocName().contains("OCI");
    }

    public boolean poiDocNoExpiryCheck() {
        return this.poiDocument != null && this.poiDocument.getDocName().contains("expired");
    }

    public boolean pofDocRequiredExpiryDate() {
        return this.pofDocument != null && !this.pofDocument.getDocName().contains("Voter") && !this.pofDocument.getDocName().contains("Citizenship") && !this.pofDocument.getDocName().contains("OCI");
    }

    public void setPoiDocument(ProofDocument poiDocument) {
        this.poiDocument = poiDocument;
        this.validate();
    }

    public void setPofDocument(ProofDocument proofDocument) {
        this.pofDocument = proofDocument;
        this.validate();
    }

    public void setForeignType(String foreignType) {
        this.foreignType = foreignType;
    }

    public String getForeignType() {
        return this.foreignType;
    }

    public String getProofError() {
        return this.proofError;
    }

    public String getDocNo() {
        return this.docNo;
    }

    public void setDocNo(String docNo) {
        this.docNo = docNo;
        this.validate();
    }

    public String getVisaNo() {
        return this.visaNo;
    }

    public void setVisaNo(String visaNo) {
        this.visaNo = visaNo;
        this.validate();
    }

    public LocalDate getIssueDate() {
        return this.issueDate;
    }

    public String getVisaIssueDate() {
        return this.toDDMMYYYY(this.visaIssueDate.toString());
    }

    public void setVisaIssueDate(String visaIssueDate) {
        if (!visaIssueDate.isEmpty()) {
            this.visaIssueDate = LocalDate.of(Integer.parseInt(visaIssueDate.substring(6, 10)), Integer.parseInt(visaIssueDate.substring(3, 5)), Integer.parseInt(visaIssueDate.substring(0, 2)));
            this.validate();
        }
    }

    public String getVisaExpiryDate() {
        if (this.visaExpiryDate == null && !this.pofDocRequiredExpiryDate()) {
            return "00-00-0000";
        }
        return this.toDDMMYYYY(this.visaExpiryDate.toString());
    }

    public void setVisaExpiryDate(String visaExpiryDate) {
        if (!visaExpiryDate.isEmpty()) {
            this.visaExpiryDate = LocalDate.of(Integer.parseInt(visaExpiryDate.substring(6, 10)), Integer.parseInt(visaExpiryDate.substring(3, 5)), Integer.parseInt(visaExpiryDate.substring(0, 2)));
            this.validate();
        }
    }

    public String getIssueDateString() {
        return this.toDDMMYYYY(this.issueDate.toString());
    }

    public String getExpiryDateString() {
        if (this.expiryDate == null && this.foreignType.equalsIgnoreCase("NLBN") && (this.poiDocument.getDocName().contains("Voter") || this.poiDocument.getDocName().contains("Citizenship"))) {
            return "00-00-0000";
        }
        return this.toDDMMYYYY(this.expiryDate.toString());
    }

    private String toDDMMYYYY(String dateString) {
        if (Strings.isNullOrEmpty((String)dateString)) {
            return "";
        }
        return dateString.substring(8, 10) + "-" + dateString.substring(5, 7) + "-" + dateString.substring(0, 4);
    }

    public String getDocNoError() {
        return this.docNoError;
    }

    public void setIssueDate(String issueDate) {
        if (!issueDate.isEmpty()) {
            this.issueDate = LocalDate.of(Integer.parseInt(issueDate.substring(6, 10)), Integer.parseInt(issueDate.substring(3, 5)), Integer.parseInt(issueDate.substring(0, 2)));
            this.validate();
        }
    }

    public LocalDate getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        if (!expiryDate.isEmpty()) {
            this.expiryDate = LocalDate.of(Integer.parseInt(expiryDate.substring(6, 10)), Integer.parseInt(expiryDate.substring(3, 5)), Integer.parseInt(expiryDate.substring(0, 2)));
            this.validate();
        }
    }

    public String getIssueDateError() {
        return this.issueDateError;
    }

    public String getExpiryDateError() {
        return this.expiryDateError;
    }

    public String getVisaNoError() {
        return this.visaNoError;
    }

    public String getVisaProofError() {
        return this.visaProofError;
    }

    public String getVisaIssueDateError() {
        return this.visaIssueDateError;
    }

    public String getVisaExpiryDateError() {
        return this.visaExpiryDateError;
    }

    private void checkMandatoryAllFields() {
        if (this.isPoiMandatory && this.isInvalidDocument(this.poiDocument)) {
            this.docNoError = this.proofError = this.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]);
            this.expiryDateError = this.proofError;
            this.issueDateError = this.proofError;
        } else {
            this.proofError = null;
            this.docNoError = null;
            this.expiryDateError = null;
            this.issueDateError = null;
        }
        this.issueDateError = this.isPoiMandatory && this.issueDate == null ? this.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]) : null;
        this.expiryDateError = this.isPoiMandatory && this.expiryDate == null ? this.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]) : null;
        this.docNoError = this.isPoiMandatory && Strings.isNullOrEmpty((String)this.docNo) ? this.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]) : null;
        if (this.isPofMandatory && this.isInvalidDocument(this.pofDocument)) {
            this.visaNoError = this.visaProofError = this.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]);
            this.visaExpiryDateError = this.visaProofError;
            this.visaIssueDateError = this.visaProofError;
        } else {
            this.visaProofError = null;
            this.visaNoError = null;
            this.visaExpiryDateError = null;
            this.visaIssueDateError = null;
        }
        this.visaIssueDateError = this.isPofMandatory && this.visaIssueDate == null ? this.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]) : null;
        this.visaExpiryDateError = this.isPofMandatory && this.visaExpiryDate == null ? this.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]) : null;
        this.visaNoError = this.isPofMandatory && Strings.isNullOrEmpty((String)this.visaNo) ? this.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]) : null;
    }

    private String validateIssueDate(LocalDate issueDate, boolean isIssueDateRequired, boolean validIssue) {
        MsgKeysILV errorMsg = null;
        if (issueDate != null && isIssueDateRequired) {
            LocalDate today = LocalDate.now();
            if (this.isUpdate && issueDate.isAfter(today)) {
                errorMsg = MsgKeysILV.FUTURE_DATE;
            } else if (!this.isUpdate) {
                boolean isIssueDateLessThanEqualToDOB;
                LocalDate sixMonthsBefore = today.minusMonths(6L);
                boolean isAfter = issueDate.isAfter(sixMonthsBefore);
                boolean bl = isIssueDateLessThanEqualToDOB = issueDate.toString().compareTo(this.enrollmentService.getDemoPersonalDetails().getAgeDob().getAgeDobFormattedUCReverse()) <= 0;
                if (isAfter && !validIssue) {
                    errorMsg = MsgKeysILV.AFTER_DATE;
                } else if (isIssueDateLessThanEqualToDOB) {
                    errorMsg = MsgKeysILV.ISSUE_GREATER_DOB;
                }
            }
        } else if (isIssueDateRequired) {
            errorMsg = MsgKeysILV.MANDATORY;
        }
        return this.getMessage((Object)errorMsg, new Object[0]);
    }

    private String validateExpiryDate(LocalDate expiryDate, boolean isExpiryRequired, boolean isPOF) {
        MsgKeysILV errorMsg = null;
        if (expiryDate != null && isExpiryRequired) {
            LocalDate today = LocalDate.now();
            int compare = expiryDate.compareTo(today);
            if (compare == 0) {
                errorMsg = MsgKeysILV.TODAY_DATE;
            } else if (compare < 0) {
                errorMsg = MsgKeysILV.BEFORE_DATE;
            }
        } else if (isExpiryRequired) {
            errorMsg = MsgKeysILV.MANDATORY;
        }
        if (expiryDate != null && !isPOF && this.poiDocNoExpiryCheck()) {
            errorMsg = null;
        }
        return this.getMessage((Object)errorMsg, new Object[0]);
    }

    private void validatePoiFields() {
        this.issueDateError = this.validateIssueDate(this.issueDate, true, this.validPoiIssue);
        this.expiryDateError = this.validateExpiryDate(this.expiryDate, this.poiDocRequiredExpiryDate(), false);
        this.docNoError = this.validateDocNumber(this.docNo);
        this.proofError = this.validatePoiDoc();
        if (!Strings.isNullOrEmpty((String)this.issueDateError) && !this.issueDateError.contains("mandatory field")) {
            log.error("POI issue date error :: {}", (Object)this.issueDateError);
        }
        if (!Strings.isNullOrEmpty((String)this.expiryDateError) && !this.expiryDateError.contains("mandatory field")) {
            log.error("POI expiry date error :: {}", (Object)this.expiryDateError);
        }
        if (!Strings.isNullOrEmpty((String)this.docNoError) && !this.docNoError.contains("mandatory field")) {
            log.error("POI document number error :: {}", (Object)this.docNoError);
        }
    }

    private void validatePofFields() {
        this.visaIssueDateError = this.validateIssueDate(this.visaIssueDate, !this.isNlbnPassportSelected(), this.validPofIssue);
        this.visaExpiryDateError = this.validateExpiryDate(this.visaExpiryDate, this.pofDocRequiredExpiryDate(), true);
        this.visaNoError = this.validateDocNumber(this.visaNo);
        this.visaProofError = this.validatePofDoc();
        if (!Strings.isNullOrEmpty((String)this.visaIssueDateError) && !this.visaIssueDateError.contains("mandatory field")) {
            log.error("POF issue date error :: {}", (Object)this.visaIssueDateError);
        }
        if (!Strings.isNullOrEmpty((String)this.visaExpiryDateError) && !this.visaExpiryDateError.contains("mandatory field")) {
            log.error("POF expiry date error :: {}", (Object)this.visaExpiryDateError);
        }
        if (!Strings.isNullOrEmpty((String)this.visaNoError) && !this.visaNoError.contains("mandatory field")) {
            log.error("POF document number error :: {}", (Object)this.visaNoError);
        }
    }

    private void validate() {
        this.checkMandatoryAllFields();
        if (this.isPoiMandatory) {
            this.validatePoiFields();
        }
        if (this.isPofMandatory && !this.isNlbnPassportSelected()) {
            this.validatePofFields();
        } else {
            this.visaProofError = null;
            this.visaNoError = null;
            this.visaExpiryDateError = null;
            this.visaIssueDateError = null;
        }
        super.setValid(this.issueDateError == null && this.expiryDateError == null && this.docNoError == null && this.proofError == null && this.visaIssueDateError == null && this.visaExpiryDateError == null && this.visaNoError == null && this.visaProofError == null);
    }

    private String validateDocNumber(String docNo) {
        MsgKeysILV errorMsg = null;
        if (StringUtils.isBlank((String)docNo)) {
            errorMsg = MsgKeysILV.MANDATORY;
        }
        return this.getMessage((Object)errorMsg, new Object[0]);
    }

    private String validatePoiDoc() {
        MsgKeysILV errorMsg = null;
        if (this.invalidPoiDocument()) {
            errorMsg = MsgKeysILV.MANDATORY;
        } else if (this.poiDocument.getDocName().equals(this.pofDocument.getDocName())) {
            errorMsg = MsgKeysILV.DOC_SAME;
        }
        return this.getMessage((Object)errorMsg, new Object[0]);
    }

    private String validatePofDoc() {
        MsgKeysILV errorMsg = null;
        if (this.invalidPofDocument()) {
            errorMsg = MsgKeysILV.MANDATORY;
        } else if (this.poiDocument.getDocName().equals(this.pofDocument.getDocName())) {
            errorMsg = MsgKeysILV.DOC_SAME;
        }
        return this.getMessage((Object)errorMsg, new Object[0]);
    }

    public boolean invalidPoiDocument() {
        return this.poiDocument == null || this.poiDocument.getDocName().isEmpty() || this.poiDocument.getDocName().equalsIgnoreCase("Select");
    }

    public boolean invalidPofDocument() {
        return this.pofDocument == null || this.pofDocument.getDocName().isEmpty() || this.pofDocument.getDocName().equalsIgnoreCase("Select");
    }

    public boolean isInvalidDocument(ProofDocument document) {
        return Optional.ofNullable(document).map(doc -> doc.getDocName().isEmpty() || doc.getDocName().equalsIgnoreCase("Select")).orElse(true);
    }

    public boolean isNlbnPassportSelected() {
        return this.foreignType.equalsIgnoreCase("NLBN") && !this.isInvalidDocument(this.poiDocument) && this.poiDocument.getDocName().contains("Passport");
    }

    public void reset() {
        this.docNo = "";
        this.issueDate = null;
        this.expiryDate = null;
        this.visaNo = "";
        this.visaIssueDate = null;
        this.visaExpiryDate = null;
        this.validate();
    }

    public void resetPOI() {
        this.docNo = "";
        this.issueDate = null;
        this.expiryDate = null;
        this.validate();
    }

    public void resetPOF() {
        this.visaNo = "";
        this.visaIssueDate = null;
        this.visaExpiryDate = null;
        this.validate();
    }
}

