/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Country;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.findaadhaar.model.BitIdentifierSelection;
import org.apache.commons.lang.StringUtils;

public class ForeignNRI
extends EnrolmentModelBase<ForeignNRI> {
    private String addressOne = "";
    private String addressTwo = "";
    private String addressThree = "";
    private String zipcode = "";
    private Country country = new Country("Select", "");
    private String existingAddressOne = "";
    private String existingAddressTwo = "";
    private String existingAddressThree = "";
    private String existingZipcode = "";
    private Country existingCountry;
    private String existingLocalAddressOne = "";
    private String existingLocalAddressTwo = "";
    private String existingLocalAddressThree = "";
    private String addressOneError = "";
    private String addressTwoError = "";
    private String addressThreeError = "";
    private String zipcodeError = "";
    private String countryError;
    private String localAddressOne = "";
    private String localAddressTwo = "";
    private String localAddressThree = "";
    private String localZipcode = "";
    private String localCountry = "";

    ForeignNRI(EnrollmentService enrollmentService) {
        super(enrollmentService);
        boolean isMandatoryForEnrol = enrollmentService.isNewEnrollmentUC() && enrollmentService.doesNriHaveForeignAddress();
        boolean isMandatoryForUpdate = enrollmentService.isUpdateUC() && enrollmentService.doesNriHaveForeignAddress() && enrollmentService.getFieldsUpdateCount().getAddress().hasToBeUpdated();
        this.setMandatory(isMandatoryForEnrol || isMandatoryForUpdate);
        this.validate();
    }

    public String getDisplayAddressOne() {
        return StringUtils.isNotBlank((String)this.addressOne) ? this.addressOne : this.existingAddressOne;
    }

    public String getDisplayAddressTwo() {
        return StringUtils.isNotBlank((String)this.addressTwo) ? this.addressTwo : this.existingAddressTwo;
    }

    public String getDisplayAddressThree() {
        return StringUtils.isNotBlank((String)this.addressThree) ? this.addressThree : this.existingAddressThree;
    }

    public String getDisplayLocalAddressOne() {
        return StringUtils.isNotBlank((String)this.localAddressOne) ? this.localAddressOne : this.existingLocalAddressOne;
    }

    public String getDisplayLocalAddressTwo() {
        return StringUtils.isNotBlank((String)this.localAddressTwo) ? this.localAddressTwo : this.existingLocalAddressTwo;
    }

    public String getDisplayLocalAddressThree() {
        return StringUtils.isNotBlank((String)this.localAddressThree) ? this.localAddressThree : this.existingLocalAddressThree;
    }

    public String getDisplayZipCode() {
        return StringUtils.isNotBlank((String)this.zipcode) ? this.zipcode : this.existingZipcode;
    }

    public String getDisplayCountry() {
        return StringUtils.isNotBlank((String)this.country.getCountryName()) ? this.country.getCountryName() : this.existingCountry.getCountryName();
    }

    public String getExistingZipcode() {
        return this.existingZipcode;
    }

    public void setExistingZipcode(String existingZipcode) {
        this.existingZipcode = existingZipcode;
    }

    public Country getExistingCountry() {
        return this.existingCountry;
    }

    public void setExistingCountry(Country existingCountry) {
        this.existingCountry = existingCountry;
    }

    public String getZipcodeError() {
        return this.zipcodeError;
    }

    public String getCountryError() {
        return this.countryError;
    }

    public String getZipcode() {
        return this.zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
        this.validate();
        super.fireChangeEvent(this);
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
        this.validate();
        super.fireChangeEvent(this);
    }

    public String getExistingAddressOne() {
        return this.existingAddressOne;
    }

    public void setExistingAddressOne(String existingAddressOne) {
        this.existingAddressOne = existingAddressOne;
    }

    public void setExistingLocalAddressOne(String existingLocalAddressOne) {
        this.existingLocalAddressOne = existingLocalAddressOne;
    }

    public void setExistingLocalAddressTwo(String existingLocalAddressTwo) {
        this.existingLocalAddressTwo = existingLocalAddressTwo;
    }

    public void setExistingLocalAddressThree(String existingLocalAddressThree) {
        this.existingLocalAddressThree = existingLocalAddressThree;
    }

    public String getExistingAddressTwo() {
        return this.existingAddressTwo;
    }

    public void setExistingAddressTwo(String existingAddressTwo) {
        this.existingAddressTwo = existingAddressTwo;
    }

    public String getExistingAddressThree() {
        return this.existingAddressThree;
    }

    public void setExistingAddressThree(String existingAddressThree) {
        this.existingAddressThree = existingAddressThree;
    }

    public String getAddressOne() {
        return this.addressOne;
    }

    public String getAddressTwo() {
        return this.addressTwo;
    }

    public String getAddressThree() {
        return this.addressThree;
    }

    public void setAddressOne(String addressOne) {
        this.addressOne = StringUtils.trim((String)addressOne);
        this.validate();
        super.fireChangeEvent(this);
    }

    public void setAddressTwo(String addressTwo) {
        this.addressTwo = StringUtils.trim((String)addressTwo);
        this.validate();
        super.fireChangeEvent(this);
    }

    public void setAddressThree(String addressThree) {
        this.addressThree = StringUtils.trim((String)addressThree);
        this.validate();
        super.fireChangeEvent(this);
    }

    public String getAddressOneError() {
        return this.addressOneError;
    }

    public String getAddressTwoError() {
        return this.addressTwoError;
    }

    public String getAddressThreeError() {
        return this.addressThreeError;
    }

    public String getFormattedAddress() {
        StringBuilder formattedAddress = new StringBuilder();
        formattedAddress.append(this.getAddressOne()).append(", ").append(this.getAddressTwo()).append(", ").append(this.getAddressThree()).append(", ");
        return formattedAddress.toString();
    }

    public String getExistingFormattedAddress() {
        StringBuilder formattedAddress = new StringBuilder();
        formattedAddress.append(this.getExistingAddressOne()).append(", ").append(this.getExistingAddressTwo()).append(", ").append(this.getExistingAddressThree()).append(", ");
        return formattedAddress.toString();
    }

    public String getLocalAddressOne() {
        return this.localAddressOne;
    }

    public void setLocalAddressOne(String localAddressOne) {
        this.localAddressOne = localAddressOne;
        super.fireChangeEvent(this);
    }

    public String getLocalAddressTwo() {
        return this.localAddressTwo;
    }

    public void setLocalAddressTwo(String localAddressTwo) {
        this.localAddressTwo = localAddressTwo;
        super.fireChangeEvent(this);
    }

    public String getLocalAddressThree() {
        return this.localAddressThree;
    }

    public void setLocalAddressThree(String localAddressThree) {
        this.localAddressThree = localAddressThree;
        super.fireChangeEvent(this);
    }

    public String getLocalZipcode() {
        return this.localZipcode;
    }

    public void setLocalZipcode(String localZipcode) {
        this.localZipcode = localZipcode;
        super.fireChangeEvent(this);
    }

    public String getLocalCountry() {
        return this.localCountry;
    }

    public void setLocalCountry(String localCountry) {
        this.localCountry = localCountry;
        super.fireChangeEvent(this);
    }

    private void formatAddress(StringBuilder formattedAddress, String building, String street, String landmark, String locality) {
        if (StringUtils.isNotBlank((String)building)) {
            formattedAddress.append(building).append(", ");
        }
        if (StringUtils.isNotBlank((String)street)) {
            formattedAddress.append(street).append(", ");
        }
        if (StringUtils.isNotBlank((String)landmark)) {
            formattedAddress.append("(").append(landmark).append(") ");
        }
        if (StringUtils.isNotBlank((String)locality)) {
            formattedAddress.append(locality).append(", ");
        }
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        this.validate();
        this.fireChangeEvent(this);
    }

    @Override
    public void setUpdated(boolean updated) {
        super.setUpdated(updated);
        super.setUpdatedBit(updated, BitIdentifierSelection.ADDRESSBIT.getBitIndentifier());
        this.validate();
        super.fireChangeEvent(this);
        super.fireUpdateChangeEvent(this);
    }

    private void validateAddressChange() {
        if (this.isMandatory() && this.enrollmentService.isUpdateUC() && this.getFormattedAddress().equals(this.getExistingFormattedAddress())) {
            MsgKeysILV errorMsgKey = MsgKeysILV.ADDR_SAME_OR_EMPTY;
            this.addressOneError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.addressTwoError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.addressThreeError = this.getMessage((Object)errorMsgKey, new Object[0]);
        }
    }

    private void validate() {
        this.validateAddressOne();
        this.validateAddressTwo();
        this.validateAddressThree();
        this.validateZipcode();
        this.validateCountry();
        this.validateAddressChange();
        this.reEvaluateAddressValidity();
    }

    private void validateAddressOne() {
        MsgKeysILV errorMsgKey = null;
        if (this.isMandatory() && StringUtils.isBlank((String)this.addressOne)) {
            errorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.addressOneError = this.getMessage((Object)errorMsgKey, new Object[0]);
    }

    private void validateAddressTwo() {
        MsgKeysILV errorMsgKey = null;
        if (this.isMandatory() && StringUtils.isBlank((String)this.addressTwo)) {
            errorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.addressTwoError = this.getMessage((Object)errorMsgKey, new Object[0]);
    }

    private void validateAddressThree() {
        MsgKeysILV errorMsgKey = null;
        if (this.isMandatory() && !this.addressThree.equals("") && StringUtils.isBlank((String)this.addressThree)) {
            errorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.addressThreeError = this.getMessage((Object)errorMsgKey, new Object[0]);
    }

    private void validateZipcode() {
        Object zipcodeErrorMsgKey = null;
        this.zipcodeError = this.getMessage(zipcodeErrorMsgKey, new Object[0]);
    }

    private void validateCountry() {
        MsgKeysILV countryErrorMsgKey = null;
        if (this.isMandatory() && this.country.getCountryName().equals("Select")) {
            countryErrorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.countryError = this.getMessage((Object)countryErrorMsgKey, new Object[0]);
    }

    private void reEvaluateAddressValidity() {
        this.validateAddressChange();
        this.setValid(this.allFieldvalid());
    }

    private boolean allFieldvalid() {
        return this.addressOneError == null && this.addressTwoError == null && this.addressThreeError == null && this.zipcodeError == null && this.countryError == null;
    }

    public void reset() {
        this.setAddressOne("");
        this.setAddressTwo("");
        this.setAddressThree("");
        this.setZipcode("");
        this.setCountry(new Country("Select", ""));
        this.addressOneError = "";
        this.addressTwoError = "";
        this.addressThreeError = "";
        this.zipcodeError = "";
        this.countryError = "";
        super.fireChangeEvent(this);
    }

    public void setToExistingAddress() {
        this.setAddressOne(this.existingAddressOne);
        this.setAddressTwo(this.existingAddressTwo);
        this.setAddressThree(this.existingAddressThree);
        this.setZipcode(this.existingZipcode);
        this.setCountry(this.existingCountry);
    }

    public boolean valueChanged() {
        return !this.addressOne.equals(this.existingAddressOne) || !this.addressTwo.equals(this.existingAddressTwo) || !this.addressThree.equals(this.existingAddressThree) || !this.zipcode.equals(this.existingZipcode) || !this.country.equals(this.existingCountry);
    }
}

