/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import org.apache.commons.lang.StringUtils;

public enum Gender {
    MALE,
    FEMALE,
    TRANSGENDER,
    NOT_GIVEN;


    public static Gender fromString(String str) {
        if (str.equalsIgnoreCase("M")) {
            return MALE;
        }
        if (str.equalsIgnoreCase("F")) {
            return FEMALE;
        }
        if (str.equalsIgnoreCase("T")) {
            return TRANSGENDER;
        }
        if (StringUtils.isBlank((String)str)) {
            return NOT_GIVEN;
        }
        return Gender.valueOf(str.toUpperCase());
    }

    public static String getDefaultSelect() {
        return "Select";
    }

    public String toString() {
        switch (this) {
            case MALE: {
                return "Male";
            }
            case FEMALE: {
                return "Female";
            }
            case TRANSGENDER: {
                return "Transgender";
            }
        }
        return "";
    }

    public String toShorthand() {
        switch (this) {
            case MALE: {
                return "M";
            }
            case FEMALE: {
                return "F";
            }
            case TRANSGENDER: {
                return "T";
            }
        }
        return "";
    }
}

