/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.BothIris;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Iris
extends EnrolmentModelBase<Iris> {
    private final Biometrics leftEye;
    private final Biometrics rightEye;
    private final BothIris bothIris;
    private final BiometricsException exception;
    private final List<Consumer<BiometricsException>> irisBiometricExceptionChangeListeners = new ArrayList<Consumer<BiometricsException>>();
    private boolean captureBothIrisSeparately;

    Iris(EnrollmentService enrollmentService, Demographics demographics, BiometricsException exception) {
        super(enrollmentService);
        this.exception = exception;
        AgeDob ageDob = demographics.getPersonalDetail().getAgeDob();
        boolean newEnrolment = !enrollmentService.isUpdateEnrollment();
        this.leftEye = new Biometrics(enrollmentService, CaptureModality.LEFT_IRIS, this.getAvailableBodyPartsForLeftEye(), this.getMissingBodyPartsForLeftEye(), newEnrolment);
        this.rightEye = new Biometrics(enrollmentService, CaptureModality.RIGHT_IRIS, this.getAvailableBodyPartsForRightEye(), this.getMissingBodyPartsForRightEye(), newEnrolment);
        this.bothIris = new BothIris(enrollmentService, exception);
        this.leftEye.addValidityChangeListener(this::reEvaluateIrisValidity);
        this.rightEye.addValidityChangeListener(this::reEvaluateIrisValidity);
        this.bothIris.addValidityChangeListener(this::reEvaluateIrisValidity);
        this.leftEye.addChangeListener(this::onBiometricChange);
        this.rightEye.addChangeListener(this::onBiometricChange);
        this.bothIris.addChangeListener(this::onBiometricChange);
        this.exception.addChangeListener(this::onBiometricExceptionChange);
        ageDob.addChangeListener(this::reEvaluateIris);
        this.addEventListenersForUpdateEnrollment(enrollmentService.isUpdateEnrollment());
        this.setMandatory(newEnrolment && ageDob.isValid() && !ageDob.isChild());
        this.validate();
    }

    private void addEventListenersForUpdateEnrollment(boolean isUpdateEnrollment) {
        if (!isUpdateEnrollment) {
            return;
        }
        this.enrollmentService.addBiometricUpdateChangeListener(this::onBiometricUpdateTypeChange);
        this.enrollmentService.addResidentChildListeners(this::onResidentChildUpdateTypeChange);
    }

    private void onBiometricUpdateTypeChange(Boolean biometricUpdate) {
        boolean childUpdate = this.enrollmentService.getDemoPersonalDetails().getAgeDob().isChild();
        this.setMandatory(!childUpdate && biometricUpdate != false);
    }

    private void onResidentChildUpdateTypeChange(Boolean childUpdate) {
        boolean biometricUpdate = this.enrollmentService.isBiometricUpdate();
        this.setMandatory(childUpdate == false && biometricUpdate);
    }

    public void addIrisBiometricExceptionChangeListener(Consumer<BiometricsException> delegate) {
        this.irisBiometricExceptionChangeListeners.add(delegate);
    }

    private void fireIrisBiometricExceptionChange(BiometricsException biometricsException) {
        this.irisBiometricExceptionChangeListeners.forEach(listener -> listener.accept(biometricsException));
    }

    private void onBiometricChange(BothIris bothIris) {
        super.fireChangeEvent(this);
    }

    private void onBiometricChange(Biometrics biometrics) {
        super.fireChangeEvent(this);
    }

    private void onBiometricExceptionChange(BiometricsException biometricsException) {
        BiometricsExceptionDetail biometricsExceptionDetail = biometricsException.getExceptionDetail();
        this.leftEye.setAvailableBodyParts(this.getAvailableBodyPartsForLeftEye());
        this.rightEye.setAvailableBodyParts(this.getAvailableBodyPartsForRightEye());
        this.leftEye.setMissingBodyParts(this.getMissingBodyPartsForLeftEye());
        this.rightEye.setMissingBodyParts(this.getMissingBodyPartsForRightEye());
        boolean leftIrisMandatory = true;
        boolean rightIrisMandatory = true;
        if (biometricsExceptionDetail.isBiometricExceptionApplied()) {
            if (biometricsExceptionDetail.isLeftEyeExceptionApplied()) {
                leftIrisMandatory = false;
            }
            if (biometricsExceptionDetail.isRightEyeExceptionApplied()) {
                rightIrisMandatory = false;
            }
        }
        this.setLeftEyeMandatory(leftIrisMandatory);
        this.setRightEyeMandatory(rightIrisMandatory);
        this.reset();
        this.fireIrisBiometricExceptionChange(biometricsException);
    }

    public Biometrics getLeftEye() {
        if (this.captureBothIrisSeparately) {
            return this.leftEye;
        }
        return this.bothIris.getLeftEye();
    }

    public Biometrics getRightEye() {
        if (this.captureBothIrisSeparately) {
            return this.rightEye;
        }
        return this.bothIris.getRightEye();
    }

    public BothIris getBothIris() {
        return this.bothIris;
    }

    private List<BodyPart> getBodyPartsForLeftEye() {
        return Collections.singletonList(BodyPart.IRIS_LEFT);
    }

    private List<BodyPart> getBodyPartsForRightEye() {
        return Collections.singletonList(BodyPart.IRIS_RIGHT);
    }

    private List<BodyPart> getAvailableBodyPartsForLeftEye() {
        List<BodyPart> bodyPartsForLeftEye = this.getBodyPartsForLeftEye();
        List<BodyPart> availableBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getAvailableEyes());
        return availableBodyPartList.stream().filter(bodyPartsForLeftEye::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getAvailableBodyPartsForRightEye() {
        List<BodyPart> bodyPartsForRightEye = this.getBodyPartsForRightEye();
        List<BodyPart> availableBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getAvailableEyes());
        return availableBodyPartList.stream().filter(bodyPartsForRightEye::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getMissingBodyPartsForLeftEye() {
        List<BodyPart> bodyPartsForLeftEye = this.getBodyPartsForLeftEye();
        List<BodyPart> missingBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getMissingEyes());
        return missingBodyPartList.stream().filter(bodyPartsForLeftEye::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getMissingBodyPartsForRightEye() {
        List<BodyPart> bodyPartsForRightEye = this.getBodyPartsForRightEye();
        List<BodyPart> missingBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getMissingEyes());
        return missingBodyPartList.stream().filter(bodyPartsForRightEye::contains).collect(Collectors.toList());
    }

    public boolean isCaptureBothIrisSeparately() {
        return this.captureBothIrisSeparately;
    }

    public void setCaptureBothIrisSeparately(boolean captureBothIrisSeparately) {
        boolean prevCaptureBothIrisSeparatelyValue = this.captureBothIrisSeparately;
        this.captureBothIrisSeparately = captureBothIrisSeparately;
        this.validate();
        if (prevCaptureBothIrisSeparatelyValue != captureBothIrisSeparately) {
            this.fireChangeEvent(this);
        }
    }

    private void reEvaluateIrisValidity(boolean valid) {
        this.validate();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        this.leftEye.setMandatory(mandatory);
        this.rightEye.setMandatory(mandatory);
        this.bothIris.setMandatory(mandatory);
        this.reset();
    }

    public void reset() {
        this.leftEye.clearAttempts();
        this.rightEye.clearAttempts();
        this.bothIris.reset();
        this.validate();
    }

    public void setLeftEyeMandatory(boolean mandatory) {
        this.leftEye.setMandatory(mandatory);
        this.getBothIris().getLeftEye().setMandatory(mandatory);
        this.validate();
    }

    public void setRightEyeMandatory(boolean mandatory) {
        this.rightEye.setMandatory(mandatory);
        this.getBothIris().getRightEye().setMandatory(mandatory);
        this.validate();
    }

    public void setCaptureAttempts(BiometricPosition biometricPosition, CaptureAttempt captureAttempt) {
        Biometrics field = this.getField(biometricPosition);
        if (field != null) {
            field.addCaptureAttempt(captureAttempt);
        }
        this.validate();
    }

    public void setDeletedAttempts(BiometricPosition biometricPosition, CaptureAttempt captureAttempt) {
        Biometrics field = this.getField(biometricPosition);
        if (field != null) {
            field.deleteCaptureAttempt(captureAttempt);
        }
        this.validate();
    }

    public void setMaxCaptureAttempt(int maxCaptureAttempt) {
        this.leftEye.setMaxCaptureAttempts(maxCaptureAttempt);
        this.rightEye.setMaxCaptureAttempts(maxCaptureAttempt);
        this.bothIris.getLeftEye().setMaxCaptureAttempts(maxCaptureAttempt);
        this.bothIris.getRightEye().setMaxCaptureAttempts(maxCaptureAttempt);
    }

    public void clearAttempts(BiometricPosition biometricPosition) {
        Biometrics field = this.getField(biometricPosition);
        if (field != null) {
            field.clearAttempts();
        }
        this.validate();
    }

    public void setBestAttempt(BiometricPosition biometricPosition, CaptureAttempt bestAttempt) {
        Biometrics field = this.getField(biometricPosition);
        if (field != null) {
            field.setBestAttempt(bestAttempt);
        }
        this.validate();
    }

    private Biometrics getField(BiometricPosition biometricPosition) {
        Biometrics field = null;
        if (this.captureBothIrisSeparately) {
            if (biometricPosition.equals((Object)BiometricPosition.LEFT_IRIS)) {
                field = this.leftEye;
            } else if (biometricPosition.equals((Object)BiometricPosition.RIGHT_IRIS)) {
                field = this.rightEye;
            }
        } else if (biometricPosition.equals((Object)BiometricPosition.LEFT_IRIS)) {
            field = this.bothIris.getLeftEye();
        } else if (biometricPosition.equals((Object)BiometricPosition.RIGHT_IRIS)) {
            field = this.bothIris.getRightEye();
        }
        return field;
    }

    private void reEvaluateIris(AgeDob ageDob) {
        boolean mandatory;
        boolean isChild = ageDob.isChild();
        if (this.enrollmentService.isUniversalClientTrnx() && (this.enrollmentService.getBiometricsException().getExceptionDetail().isLeftEyeExceptionApplied() || this.enrollmentService.getBiometricsException().getExceptionDetail().isRightEyeExceptionApplied())) {
            return;
        }
        if (this.enrollmentService.isUpdateEnrollment()) {
            mandatory = !isChild && this.enrollmentService.isBiometricUpdate();
        } else {
            boolean bl = mandatory = !isChild;
        }
        if (this.isMandatory() != mandatory) {
            this.setMandatory(mandatory);
        }
    }

    private void validate() {
        if (this.isMandatory() && this.captureBothIrisSeparately) {
            super.setValid(this.leftEye.isValid() && this.rightEye.isValid());
        } else if (this.isMandatory()) {
            super.setValid(this.bothIris.isValid());
        } else {
            super.setValid(true);
        }
    }

    private List<BodyPart> mapBioPosToBodyParts(List<BiometricPosition> biometricPositionList) {
        ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
        for (BiometricPosition bioPos : biometricPositionList) {
            switch (bioPos) {
                case LEFT_IRIS: {
                    bodyParts.add(BodyPart.IRIS_LEFT);
                    break;
                }
                case RIGHT_IRIS: {
                    bodyParts.add(BodyPart.IRIS_RIGHT);
                }
            }
        }
        return bodyParts;
    }
}

