/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.findaadhaar.model.BitIdentifierSelection;
import org.apache.commons.lang.StringUtils;

public class Mobile
extends EnrolmentModelBase<Mobile> {
    public static final String INDIA_ISD_CODE = "+91";
    private String isdCode = "+91";
    private String number = "";
    private String existingNumber = "";
    private String numberError;
    private boolean isMobileVerified = true;

    public boolean isMobileVerified() {
        return this.isMobileVerified;
    }

    public void setMobileVerified(boolean mobileVerified) {
        this.isMobileVerified = mobileVerified;
        this.validate();
        super.fireChangeEvent(this);
    }

    Mobile(EnrollmentService enrollmentService) {
        super(enrollmentService);
        super.setValid(true);
    }

    public String number() {
        return this.number;
    }

    public String getNumberForDisplay() {
        return StringUtils.isNotBlank((String)this.number) ? this.number : this.existingNumber;
    }

    public String isdCode() {
        return this.isdCode;
    }

    public String numberError() {
        return this.numberError;
    }

    public void setIsdCode(String isdCode) {
        this.isdCode = isdCode;
        this.validate();
        super.fireChangeEvent(this);
    }

    public void setNumber(String number) {
        this.number = number;
        super.setMandatory(StringUtils.isNotBlank((String)number) || super.isUpdated());
        this.validate();
        super.fireChangeEvent(this);
    }

    public String getExistingNumber() {
        return this.existingNumber;
    }

    public void setExistingNumber(String existingNumber) {
        this.existingNumber = existingNumber;
    }

    @Override
    public void setUpdated(boolean updated) {
        super.setUpdated(updated);
        super.setUpdatedBit(updated, BitIdentifierSelection.MOBILEBIT.getBitIndentifier());
        this.validate();
        super.fireChangeEvent(this);
        super.fireUpdateChangeEvent(this);
    }

    private void validate() {
        Object errorMsgKey = null;
        boolean indianMobileNumber = this.isdCode.equals(INDIA_ISD_CODE);
        if (super.isMandatory()) {
            errorMsgKey = StringUtils.isBlank((String)this.number) ? MsgKeysILV.MANDATORY : (indianMobileNumber ? this.validateIndianMobileNumber() : this.validateNonIndianMobileNumber());
        }
        this.numberError = this.getMessage(errorMsgKey, new Object[0]);
        if (this.enrollmentService.isUniversalClientTrnx() && this.isMandatory()) {
            if (this.enrollmentService.isNewEnrollmentUC()) {
                this.setValid(this.numberError == null && this.isMobileVerified);
            }
            if (this.enrollmentService.isUpdateUC()) {
                boolean isMobileUpdateValid = this.isMobileVerified || !this.enrollmentService.getFieldsUpdateCount().getMobile().hasToBeUpdated();
                this.setValid(this.numberError == null && isMobileUpdateValid);
            }
        } else {
            this.setValid(this.numberError == null);
        }
    }

    private Object validateIndianMobileNumber() {
        if (this.number.length() != 10) {
            return MsgKeysILV.MOBILE_LENGTH;
        }
        if (this.number.equals(this.existingNumber)) {
            return MsgKeysILV.MOBILE_SAME;
        }
        return null;
    }

    private Object validateNonIndianMobileNumber() {
        return this.number.length() > 15 ? MsgKeysILV.MOBILE_MAXLENGTH : null;
    }
}

