/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysEnrol;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.findaadhaar.model.BitIdentifierSelection;
import org.apache.commons.lang.StringUtils;

public class Name
extends EnrolmentModelBase<Name> {
    private String name = "";
    private String nameLocal = "";
    private String newName = "";
    private String newNameLocal = "";
    private String nameError;
    private String nameLocalError;
    private String newNameError;
    private String newNameLocalError;
    private boolean nameTransliterationMismatch;
    private boolean newNameTransliterationMismatch;

    Name(EnrollmentService enrollmentService) {
        super(enrollmentService);
        if (enrollmentService.isUniversalClientTrnx()) {
            this.setMandatory(enrollmentService.isNewEnrollmentUC() || enrollmentService.isDemoUpdate() && enrollmentService.getFieldsUpdateCount().getName().hasToBeUpdated());
        }
        this.validate();
    }

    public String english() {
        return this.name;
    }

    public String local() {
        return this.nameLocal;
    }

    public String newEnglish() {
        return this.newName;
    }

    public String getNewNameForDisplay() {
        return this.newName != null ? this.newName : "";
    }

    public String newNameLocal() {
        return this.newNameLocal;
    }

    public boolean hasTransliterationMismatchForName() {
        return this.nameTransliterationMismatch;
    }

    public boolean hasTransliterationMismatchForNewName() {
        return this.newNameTransliterationMismatch;
    }

    public String nameError() {
        return this.nameError;
    }

    public String nameLocalError() {
        return this.nameLocalError;
    }

    public String newNameError() {
        return this.newNameError;
    }

    public String newNameLocalError() {
        return this.newNameLocalError;
    }

    public void setName(String name) {
        this.name = name;
        this.nameTransliterationMismatch = super.isTransliterationDiffValid(this.name, this.local());
        this.validate();
        this.fireChangeEvent(this);
    }

    public void setNameLocal(String nameLocal) {
        this.nameLocal = nameLocal;
        this.nameTransliterationMismatch = super.isTransliterationDiffValid(this.name, this.local());
        this.validate();
        this.fireChangeEvent(this);
    }

    public void setNewName(String newName) {
        this.newName = newName;
        this.newNameTransliterationMismatch = super.isTransliterationDiffValid(this.newName, this.newNameLocal());
        this.validate();
        this.fireChangeEvent(this);
    }

    public void setNewNameLocal(String newNameLocal) {
        this.newNameLocal = newNameLocal;
        this.newNameTransliterationMismatch = super.isTransliterationDiffValid(this.newName, this.newNameLocal());
        this.validate();
        this.fireChangeEvent(this);
    }

    @Override
    public void setUpdated(boolean updated) {
        super.setUpdated(updated);
        super.setUpdatedBit(updated, BitIdentifierSelection.NAMEBIT.getBitIndentifier());
        this.validate();
        super.fireChangeEvent(this);
        super.fireUpdateChangeEvent(this);
    }

    private void validate() {
        this.validateName();
        this.validateNameLocal();
        if (this.enrollmentService.isUpdateEnrollment() || this.enrollmentService.isUpdateUC()) {
            this.validateNewName();
            this.validateNewNameLocal();
        }
        if (this.enrollmentService.isUniversalClientTrnx() && !this.isMandatory()) {
            this.setValid(true);
        } else {
            this.setValid(this.nameError == null && this.nameLocalError == null && this.newNameError == null && this.newNameLocalError == null);
        }
    }

    private boolean nameNotChanged() {
        return this.newName.equals(this.name) && this.newNameLocal.equals(this.nameLocal);
    }

    private void validateName() {
        Enum nameErrorMsgKey = null;
        if (StringUtils.isBlank((String)this.name)) {
            nameErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.name.length() < 2) {
            nameErrorMsgKey = MsgKeysEnrol.NAME_TOOSHORT_WARNING;
        } else if (!this.name.matches("^[a-zA-Z][a-zA-Z\\s.()']+")) {
            nameErrorMsgKey = MsgKeysEnrol.NAME_INVALID_WARNING;
        }
        this.nameError = this.getMessage(nameErrorMsgKey, new Object[0]);
    }

    private void validateNameLocal() {
        Enum nameLocalErrorMsgKey = null;
        if (StringUtils.isBlank((String)this.nameLocal)) {
            nameLocalErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.nameLocal.length() < 2) {
            nameLocalErrorMsgKey = MsgKeysEnrol.NAME_TOOSHORT_WARNING;
        } else if (this.nameLocal.matches("[\\d]+")) {
            nameLocalErrorMsgKey = MsgKeysEnrol.NAME_INVALID_WARNING;
        }
        this.nameLocalError = this.getMessage(nameLocalErrorMsgKey, new Object[0]);
    }

    private void validateNewName() {
        Enum newNameErrorMsgKey = null;
        if (this.isMandatory()) {
            if (StringUtils.isBlank((String)this.newName)) {
                newNameErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.newName.length() < 2) {
                newNameErrorMsgKey = MsgKeysEnrol.NEWNAME_TOOSHORT_WARNING;
            } else if (!this.newName.matches("^[a-zA-Z][a-zA-Z\\s.()']+")) {
                newNameErrorMsgKey = MsgKeysEnrol.NAME_INVALID_WARNING;
            } else if (this.nameNotChanged()) {
                newNameErrorMsgKey = MsgKeysILV.FULLNAME_SAME;
            }
        }
        this.newNameError = this.getMessage(newNameErrorMsgKey, new Object[0]);
    }

    private void validateNewNameLocal() {
        Enum newNameLocalErrorMsgKey = null;
        if (this.isMandatory()) {
            if (StringUtils.isBlank((String)this.newNameLocal)) {
                newNameLocalErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.newNameLocal.length() < 2) {
                newNameLocalErrorMsgKey = MsgKeysEnrol.NEWNAME_TOOSHORT_WARNING;
            } else if (this.newNameLocal.matches("[\\d]+")) {
                newNameLocalErrorMsgKey = MsgKeysEnrol.NAME_INVALID_WARNING;
            } else if (this.nameNotChanged()) {
                newNameLocalErrorMsgKey = MsgKeysILV.FULLNAME_SAME;
            }
        }
        this.newNameLocalError = this.getMessage(newNameLocalErrorMsgKey, new Object[0]);
    }

    public boolean valueChanged() {
        return !this.name.equals(this.newName);
    }
}

