/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import org.apache.commons.lang.StringUtils;

public class Npr
extends EnrolmentModelBase<Npr> {
    private static final int MINIMUM_NPR_CHARACTERS = 24;
    private final boolean isMandatory;
    private String nprNumber = "";
    private String nprError;

    Npr(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.isMandatory = enrollmentService.getSessionService().isNrcMandatory() && !enrollmentService.isDocumentUpdate();
        this.validate();
    }

    public String getNprNumber() {
        return this.nprNumber;
    }

    void setNprNumber(String nprNumber) {
        this.nprNumber = nprNumber;
        this.validate();
    }

    public String getNprError() {
        return this.nprError;
    }

    private void validate() {
        MsgKeysILV nprErrorMsgKey = null;
        if (this.isMandatory && StringUtils.isBlank((String)this.nprNumber)) {
            nprErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.isMandatory && this.nprNumber.length() < 24) {
            nprErrorMsgKey = MsgKeysILV.NPR_MINIMUM;
        }
        this.nprError = this.getMessage((Object)nprErrorMsgKey, new Object[0]);
        this.setValid(this.nprError == null);
    }
}

