/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AadhaarNo;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.ApplicantConfirmGender;
import in.gov.uidai.ec.service.enrollment.model.ApplicantGender;
import in.gov.uidai.ec.service.enrollment.model.ConfirmDob;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.ForeignDetail;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.service.enrollment.model.Name;
import in.gov.uidai.ec.service.enrollment.model.Npr;

public class PersonalDetail
extends EnrolmentModelBase<PersonalDetail> {
    private final Name name;
    private final AadhaarNo aadhaarNo;
    private final ApplicantGender applicantGender;
    private final ApplicantConfirmGender applicantConfirmGender;
    private final AgeDob ageDob;
    private final ConfirmDob confirmDob;
    private final Npr npr;
    private final ForeignDetail foreignDetail;
    private final boolean isUpdateEnrollment;

    PersonalDetail(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.isUpdateEnrollment = enrollmentService.isUpdateEnrollment();
        this.name = new Name(enrollmentService);
        this.aadhaarNo = new AadhaarNo(enrollmentService);
        this.applicantGender = new ApplicantGender(enrollmentService);
        this.applicantConfirmGender = new ApplicantConfirmGender(enrollmentService);
        this.ageDob = new AgeDob(enrollmentService);
        this.confirmDob = new ConfirmDob(enrollmentService);
        this.npr = new Npr(enrollmentService);
        this.name.addValidityChangeListener(this::reEvaluatePersonalDetailValidity);
        this.aadhaarNo.addValidityChangeListener(this::reEvaluatePersonalDetailValidity);
        this.applicantGender.addValidityChangeListener(this::reEvaluatePersonalDetailValidity);
        this.applicantConfirmGender.addValidityChangeListener(this::reEvaluatePersonalDetailValidity);
        this.ageDob.addValidityChangeListener(this::reEvaluatePersonalDetailValidity);
        this.confirmDob.addValidityChangeListener(this::reEvaluatePersonalDetailValidity);
        this.npr.addValidityChangeListener(this::reEvaluatePersonalDetailValidity);
        this.foreignDetail = new ForeignDetail(enrollmentService);
        this.addEventListenersForUpdateEnrollment(enrollmentService.isUpdateEnrollment());
    }

    private void addEventListenersForUpdateEnrollment(boolean isUpdateEnrollment) {
        if (!isUpdateEnrollment) {
            return;
        }
        this.name.addUpdateChangeListener(this::reEvaluatePersonalDetailUpdateState);
        this.aadhaarNo.addChangeListener(this::reEvaluatePersonalDetailUpdateState);
        this.applicantGender.addUpdateChangeListener(this::reEvaluatePersonalDetailUpdateState);
        this.applicantConfirmGender.addUpdateChangeListener(this::reEvaluatePersonalDetailUpdateState);
        this.ageDob.addUpdateChangeListener(this::reEvaluatePersonalDetailUpdateState);
        this.confirmDob.addUpdateChangeListener(this::reEvaluatePersonalDetailUpdateState);
        this.npr.addChangeListener(this::reEvaluatePersonalDetailUpdateState);
    }

    public ForeignDetail getForeignDetail() {
        return this.foreignDetail;
    }

    public Name getName() {
        return this.name;
    }

    public AadhaarNo getAadhaarNumber() {
        return this.aadhaarNo;
    }

    public void setAadhaarNumber(String aadhaarNo) {
        this.aadhaarNo.setAadhaarNumber(aadhaarNo);
    }

    public ApplicantGender getApplicantGender() {
        return this.applicantGender;
    }

    public void setApplicantGender(String applicantGender) {
        this.applicantGender.setGender(Gender.fromString(applicantGender));
    }

    public ApplicantConfirmGender getApplicantConfirmGender() {
        return this.applicantConfirmGender;
    }

    public ConfirmDob getConfirmDob() {
        return this.confirmDob;
    }

    public void setApplicantConfirmGender(String applicantConfirmGender) {
        this.applicantConfirmGender.setGender(Gender.fromString(applicantConfirmGender));
    }

    public AgeDob getAgeDob() {
        return this.ageDob;
    }

    public Npr getNpr() {
        return this.npr;
    }

    public void setNpr(String npr) {
        this.npr.setNprNumber(npr);
    }

    @Override
    public boolean isUpdated() {
        boolean update = false;
        if (this.applicantGender.isUpdated() && !this.ageDob.isUpdated()) {
            if (this.applicantConfirmGender.isUpdated() && !this.confirmDob.isUpdated()) {
                update = true;
            }
        } else if (this.ageDob.isUpdated() && !this.applicantGender.isUpdated()) {
            if (this.confirmDob.isUpdated() && !this.applicantConfirmGender.isUpdated()) {
                update = true;
            }
        } else if (this.applicantGender.isUpdated() && this.ageDob.isUpdated()) {
            if (this.applicantConfirmGender.isUpdated() && this.confirmDob.isUpdated()) {
                update = true;
            }
        } else if (this.name.isUpdated()) {
            update = true;
        }
        return update;
    }

    public void setFullName(String fullName) {
        this.name.setName(fullName);
    }

    public void setNewName(String originalName) {
        this.name.setNewName(originalName);
    }

    public void setFullNameLocal(String fullNameLocal) {
        this.name.setNameLocal(fullNameLocal);
    }

    public void setNewNameLocal(String fullOriginalNameLocal) {
        this.name.setNewNameLocal(fullOriginalNameLocal);
    }

    public void setGenderLocal(String genderLocal) {
        this.applicantGender.setGenderLocal(genderLocal);
    }

    public void setConfirmGenderLocal(String genderLocal) {
        this.applicantConfirmGender.setGenderLocal(genderLocal);
    }

    private void reEvaluatePersonalDetailValidity(boolean valid) {
        if (this.isUpdateEnrollment || this.enrollmentService.isOnlineUpdate()) {
            super.setValid(valid && this.name.isValid() && this.applicantGender.isValid() && this.applicantConfirmGender.isValid() && this.ageDob.isValid() && this.confirmDob.isValid() && this.npr.isValid() && this.aadhaarNo.isValid());
        } else {
            super.setValid(valid && this.name.isValid() && this.applicantGender.isValid() && this.ageDob.isValid() && this.npr.isValid() && this.aadhaarNo.isValid());
        }
    }

    private void reEvaluatePersonalDetailUpdateState(EnrolmentModelBase modelBase) {
        boolean prevUpdateValue = super.isUpdated();
        boolean update = false;
        if (this.applicantGender.isUpdated() && !this.ageDob.isUpdated()) {
            if (this.applicantConfirmGender.isUpdated() && !this.confirmDob.isUpdated()) {
                update = true;
            }
        } else if (this.ageDob.isUpdated() && !this.applicantGender.isUpdated()) {
            if (this.confirmDob.isUpdated() && !this.applicantConfirmGender.isUpdated()) {
                update = true;
            }
        } else if (this.applicantGender.isUpdated() && this.ageDob.isUpdated()) {
            if (this.applicantConfirmGender.isUpdated() && this.confirmDob.isUpdated()) {
                update = true;
            }
        } else if (this.name.isUpdated()) {
            update = true;
        } else if (this.aadhaarNo.isUpdated()) {
            update = true;
        } else if (this.npr.isUpdated()) {
            update = true;
        }
        super.setUpdated(update);
        boolean isUpdated = super.isUpdated();
        if (prevUpdateValue != isUpdated) {
            super.fireUpdateChangeEvent(this);
        }
    }

    public void cleanValues() {
        this.name.setName("");
        this.name.setNameLocal("");
        this.applicantGender.setGender(Gender.NOT_GIVEN);
        this.applicantConfirmGender.setGender(Gender.NOT_GIVEN);
        this.ageDob.setAge("-1");
        this.ageDob.setDob("-1", "-1", "-1");
        this.confirmDob.setAge("-1");
        this.confirmDob.setDob("-1", "-1", "-1");
    }
}

