/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.ResidentConfirmation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class Photograph
extends EnrolmentModelBase<Photograph> {
    private final Biometrics photo;
    private final Biometrics exceptionPhoto;
    private final BiometricsException exception;
    private final List<Consumer<BiometricsException>> biometricExceptionChangeListeners = new ArrayList<Consumer<BiometricsException>>();
    private final List<Consumer<Boolean>> biometricUpdateChangeListeners = new ArrayList<Consumer<Boolean>>();
    private final List<Consumer<Boolean>> ageUpdateChangeListeners = new ArrayList<Consumer<Boolean>>();
    private final ResidentConfirmation residentConfirmation;
    private final boolean updateEnrollment;

    Photograph(EnrollmentService enrollmentService, BiometricsException exception) {
        super(enrollmentService);
        this.updateEnrollment = enrollmentService.isUpdateEnrollment();
        this.exception = exception;
        this.photo = new Biometrics(enrollmentService, CaptureModality.FACE, Collections.singletonList(BodyPart.FACE), new ArrayList<BodyPart>(), true);
        this.exceptionPhoto = new Biometrics(enrollmentService, CaptureModality.BIOX, Collections.singletonList(BodyPart.FACE), new ArrayList<BodyPart>(), false);
        this.exceptionPhoto.addValidityChangeListener(this::reEvaluatePhotoValidity);
        this.photo.addValidityChangeListener(this::reEvaluatePhotoValidity);
        this.exception.addChangeListener(this::onBiometricsExceptionChange);
        this.residentConfirmation = new ResidentConfirmation(enrollmentService);
        if (this.updateEnrollment) {
            this.addEventListenersForUpdateEnrollment();
        } else if (!enrollmentService.isUniversalClientTrnx()) {
            this.residentConfirmation.addValidityChangeListener(this::reEvaluatePhotoValidity);
        }
    }

    private void addEventListenersForUpdateEnrollment() {
        this.residentConfirmation.addValidityChangeListener(this::reEvaluatePhotoValidity);
        this.enrollmentService.addBiometricUpdateChangeListener(this::onBiometricUpdateTypeChange);
        this.enrollmentService.addResidentChildListeners(this::onAgeUpdateTypeChange);
    }

    public void addBiometricsExceptionChangeListener(Consumer<BiometricsException> delegate) {
        this.biometricExceptionChangeListeners.add(delegate);
    }

    private void fireBiometricExceptionChange(BiometricsException biometricsException) {
        this.biometricExceptionChangeListeners.forEach(listener -> listener.accept(biometricsException));
    }

    public void addBiometricUpdateChangeListener(Consumer<Boolean> delegate) {
        this.biometricUpdateChangeListeners.add(delegate);
    }

    public void addAgeUpdateChangeListener(Consumer<Boolean> delegate) {
        this.ageUpdateChangeListeners.add(delegate);
    }

    private void fireBiometricUpdateChange(boolean biometricUpdate) {
        this.biometricUpdateChangeListeners.forEach(listener -> listener.accept(biometricUpdate));
    }

    private void onBiometricsExceptionChange(BiometricsException biometricException) {
        BiometricsExceptionDetail biometricsExceptionDetail = biometricException.getExceptionDetail();
        this.exceptionPhoto.setMandatory(biometricsExceptionDetail.isBiometricExceptionApplied());
        if (this.updateEnrollment) {
            this.residentConfirmation.setMandatory(!biometricsExceptionDetail.isBiometricExceptionApplied());
        }
        this.resetExceptionPhoto();
        this.fireBiometricExceptionChange(this.exception);
    }

    private void onBiometricUpdateTypeChange(boolean isBiometricUpdate) {
        this.residentConfirmation.setMandatory(!isBiometricUpdate);
        if (!isBiometricUpdate) {
            this.exceptionPhoto.setMandatory(false);
        }
        this.fireBiometricUpdateChange(isBiometricUpdate);
    }

    private void onAgeUpdateTypeChange(boolean isChildAgeUpdate) {
        this.fireChildAgeUpdateChange(isChildAgeUpdate);
    }

    private void fireChildAgeUpdateChange(boolean isChildAgeUpdate) {
        this.ageUpdateChangeListeners.forEach(listener -> listener.accept(isChildAgeUpdate));
    }

    public Biometrics getPhoto() {
        return this.photo;
    }

    public Biometrics getExceptionPhoto() {
        return this.exceptionPhoto;
    }

    public ResidentConfirmation getResidentConfirmation() {
        return this.residentConfirmation;
    }

    public void resetExceptionPhoto() {
        this.exceptionPhoto.clearAttempts();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        if (!mandatory) {
            this.setValid(true);
        }
    }

    public void setMaxCaptureAttempts(int maxCaptureAttempts) {
        this.photo.setMaxCaptureAttempts(maxCaptureAttempts);
        this.exceptionPhoto.setMaxCaptureAttempts(maxCaptureAttempts);
    }

    private void reEvaluatePhotoValidity(boolean valid) {
        if (this.enrollmentService.isUniversalClientTrnx()) {
            valid = valid && this.photo.isValid();
        } else {
            boolean bl = valid = valid && this.photo.isValid() && this.exceptionPhoto.isValid() && this.exception.isValid();
            if (this.updateEnrollment) {
                boolean bl2 = valid = valid && this.residentConfirmation.isValid();
            }
            if (!this.enrollmentService.isPhotographCaptureEnabled()) {
                valid = this.residentConfirmation.isValid();
            }
            if (!this.enrollmentService.isUniversalClientTrnx() && this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().getAgeGroup().equals((Object)AgeGroup.BELOW5) && !this.updateEnrollment) {
                valid = valid && this.residentConfirmation.isValid();
            }
        }
        this.setValid(valid);
    }
}

