/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.ProofDetails;
import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.document.IDocumentService;
import in.gov.uidai.ec.service.document.ModeType;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.document.digilocker.DigilockerDocument;
import in.gov.uidai.ec.service.document.digilocker.VerifiableDocument;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReferenceAllowedDocuments
extends EnrolmentModelBase<ReferenceAllowedDocuments> {
    private final IDocumentService documentService;
    private List<ProofDocument> pobDocuments = new ArrayList<ProofDocument>();
    private List<ProofDocument> poiDocuments = new ArrayList<ProofDocument>();
    private List<ProofDocument> poaDocuments = new ArrayList<ProofDocument>();
    private List<ProofDocument> hofDocuments = new ArrayList<ProofDocument>();
    private List<ProofDocument> porDocuments = new ArrayList<ProofDocument>();
    private List<ProofDocument> pofDocuments = new ArrayList<ProofDocument>();
    private AgeGroup ageGroup;
    private boolean isNRI;
    private RelationshipType relationshipType;
    private boolean isDocBasedChildEnrollment;
    private String foreignType;

    public ReferenceAllowedDocuments(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.documentService = enrollmentService.isUniversalClientTrnx() ? enrollmentService.getOnlineDocumentService() : enrollmentService.getDocumentService();
        if (enrollmentService.isUniversalClientTrnx()) {
            this.isDocBasedChildEnrollment = (enrollmentService.isChildEnrollment() || enrollmentService.isMinorEnrollment()) && !enrollmentService.isHofEnrollment();
            this.loadDocumentsList(enrollmentService.getDemoPersonalDetails().getAgeDob().getAgeGroup(), enrollmentService.isNRIEnrolment(), enrollmentService.getDemographics().getHofRelationType());
        } else if (enrollmentService.getDemoPersonalDetails().getAgeDob().getAge() < 18 && !enrollmentService.isForeignResident()) {
            this.loadDocumentsList(AgeGroup.ABOVE18, enrollmentService.isNRIEnrolment(), null);
        } else if (enrollmentService.isForeignResident()) {
            if (enrollmentService.getDemoPersonalDetails().getAgeDob().getAge() < 18 && enrollmentService.getDemoPersonalDetails().getAgeDob().getAge() >= 5) {
                this.loadDocumentsList(AgeGroup.BETWEEN5TO18, false, null);
            } else if (enrollmentService.getDemoPersonalDetails().getAgeDob().getAge() < 5) {
                this.loadDocumentsList(AgeGroup.BELOW5, false, null);
            } else {
                this.loadDocumentsList(AgeGroup.ABOVE18, false, null);
            }
        } else {
            this.loadDocumentsList(AgeGroup.ABOVE18, enrollmentService.isNRIEnrolment(), null);
        }
    }

    AgeGroup currentAgeGroup() {
        return this.ageGroup;
    }

    boolean currentIsNRI() {
        return this.isNRI;
    }

    public List<ProofDocument> getPobDocs() {
        return this.pobDocuments;
    }

    public List<ProofDocument> getPoiDocs() {
        return this.poiDocuments;
    }

    public List<ProofDocument> getPoaDocs() {
        return this.poaDocuments;
    }

    public List<ProofDocument> getHofDocs() {
        return this.hofDocuments;
    }

    public List<ProofDocument> getPorDocs() {
        return this.porDocuments;
    }

    public List<ProofDocument> getPofDocs() {
        return this.pofDocuments;
    }

    public Map<String, DigilockerDocument> getDigilockerList() {
        return this.documentService.getDigilockerList();
    }

    public Map<String, VerifiableDocument> getVerifiableDocumentsList() {
        return this.documentService.getVerifiableDocumentsList();
    }

    public Map<String, ProofDetails> getMdaOnlineDocumentsMap() {
        return this.documentService.getMdaOnlineDocumentsMap();
    }

    public ProofDocument getDocumentDefaultSelect() {
        return this.documentService.getDefaultSelect();
    }

    void loadDocumentsList(AgeGroup ageGroup, boolean isNRI, RelationshipType type) {
        this.ageGroup = ageGroup;
        this.isNRI = isNRI;
        this.relationshipType = type;
        ModeType mode = this.getModeType();
        this.foreignType = this.enrollmentService.getDemoResidentialStatus().getForeignType().getCode().isEmpty() ? "INDIAN" : this.enrollmentService.getDemoResidentialStatus().getForeignType().getCode();
        this.initDocumentsProofs(ageGroup, isNRI, mode);
    }

    private void initDocumentsProofs(AgeGroup ageGroup, boolean isNRI, ModeType mode) {
        this.initIdentityProofDetails(mode, ageGroup, isNRI);
        this.initAddressProofDetails(mode, ageGroup);
        this.initDobProofDetails(mode, ageGroup);
        this.initHOFSupportingDocDetails(mode, ageGroup);
        this.initRelationProofDetails(mode, ageGroup);
        this.initForeignProofDetails(mode, ageGroup);
    }

    private void initIdentityProofDetails(ModeType mode, AgeGroup ageGroup, boolean isNRI) {
        this.poiDocuments = new ArrayList<ProofDocument>();
        this.poiDocuments.add(0, this.documentService.getDefaultSelect());
        this.poiDocuments.addAll(this.documentService.getIdentityProofs(mode, ageGroup, isNRI, this.isDocBasedChildEnrollment, this.foreignType));
        this.fireChangeEvent(this);
    }

    private void initAddressProofDetails(ModeType mode, AgeGroup ageGroup) {
        this.poaDocuments = new ArrayList<ProofDocument>();
        this.poaDocuments.add(0, this.documentService.getDefaultSelect());
        this.poaDocuments.addAll(this.documentService.getAddressProofs(mode, ageGroup, this.enrollmentService.doesNriHaveForeignAddress(), this.isDocBasedChildEnrollment, this.foreignType));
        this.fireChangeEvent(this);
    }

    private void initDobProofDetails(ModeType mode, AgeGroup ageGroup) {
        this.pobDocuments = new ArrayList<ProofDocument>();
        this.pobDocuments.add(0, this.documentService.getDefaultSelect());
        this.pobDocuments.addAll(this.documentService.getDobProofs(mode, ageGroup, this.isNRI, this.enrollmentService.doesNriHaveForeignAddress(), this.foreignType));
        this.fireChangeEvent(this);
    }

    private void initRelationProofDetails(ModeType mode, AgeGroup ageGroup) {
        this.porDocuments = new ArrayList<ProofDocument>();
        this.porDocuments.add(0, this.documentService.getDefaultSelect());
        this.porDocuments.addAll(this.documentService.getRelationProofs(mode, ageGroup, this.relationshipType, this.isNRI, this.foreignType));
        this.fireChangeEvent(this);
    }

    private void initHOFSupportingDocDetails(ModeType mode, AgeGroup ageGroup) {
        this.hofDocuments = new ArrayList<ProofDocument>();
        this.hofDocuments.add(0, this.documentService.getDefaultSelect());
        this.hofDocuments.addAll(this.documentService.getHOFSupportingDocs(mode, ageGroup, this.isNRI));
    }

    private void initForeignProofDetails(ModeType mode, AgeGroup ageGroup) {
        this.pofDocuments = new ArrayList<ProofDocument>();
        this.pofDocuments.add(0, this.documentService.getDefaultSelect());
        this.pofDocuments.addAll(this.documentService.getForeignProofs(mode, ageGroup, this.foreignType));
        this.fireChangeEvent(this);
    }

    private ModeType getModeType() {
        return this.enrollmentService.isUpdateEnrollment() ? ModeType.UPDATE : ModeType.NEW;
    }
}

