/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ReferenceAllowedRelationship
extends EnrolmentModelBase<ReferenceAllowedRelationship> {
    private List<RelationshipType> masterList = new ArrayList<RelationshipType>();
    private List<RelationshipType> allowedRelationships = new ArrayList<RelationshipType>();
    private Gender gender = Gender.NOT_GIVEN;

    ReferenceAllowedRelationship(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.loadRelationshipList();
    }

    private void loadRelationshipList() {
        this.masterList = new ArrayList<RelationshipType>(){
            {
                this.add(RelationshipType.NOT_GIVEN);
                this.add(RelationshipType.FATHER);
                this.add(RelationshipType.MOTHER);
                this.add(RelationshipType.SPOUSE);
                this.add(RelationshipType.SIBLING);
                this.add(RelationshipType.CHILD_WARD);
                this.add(RelationshipType.LEGAL_GUARDIAN);
                this.add(RelationshipType.MOTHER_FATHER);
            }
        };
        this.allowedRelationships = this.masterList;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public List<RelationshipType> getAllowedRelationshipList() {
        return this.allowedRelationships;
    }

    void loadRelativeRelationshipList(Gender gender, AgeDob ageDob, String age) {
        this.gender = gender;
        if (ageDob.isMinor() && ageDob.getAge() >= 5 || age.equals("BETWEEN5TO18")) {
            this.allowedRelationships = this.masterList.stream().filter(r -> !r.equals((Object)RelationshipType.SIBLING) && !r.equals((Object)RelationshipType.CHILD_WARD) && !r.equals((Object)RelationshipType.SPOUSE) && !r.equals((Object)RelationshipType.MOTHER_FATHER)).collect(Collectors.toList());
            return;
        }
        if (age.equals("BELOW5") || age.equals("") || ageDob.getAge() < 5) {
            this.allowedRelationships = this.masterList.stream().filter(r -> !r.equals((Object)RelationshipType.SIBLING) && !r.equals((Object)RelationshipType.CHILD_WARD) && !r.equals((Object)RelationshipType.SPOUSE) && !r.equals((Object)RelationshipType.MOTHER_FATHER)).collect(Collectors.toList());
            return;
        }
        if (ageDob.isAdult() && !this.enrollmentService.isUpdateEnrollment()) {
            this.allowedRelationships = this.masterList.stream().filter(r -> !r.equals((Object)RelationshipType.SIBLING) && !r.equals((Object)RelationshipType.CHILD_WARD) && !r.equals((Object)RelationshipType.SPOUSE) && !r.equals((Object)RelationshipType.MOTHER_FATHER)).collect(Collectors.toList());
            return;
        }
        this.allowedRelationships = this.masterList.stream().filter(r -> !r.equals((Object)RelationshipType.MOTHER_FATHER)).collect(Collectors.toList());
    }
}

