/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import org.apache.commons.lang.StringUtils;

public class ReferenceDocument
extends EnrolmentModelBase<ReferenceDocument> {
    private final DocumentType documentType;
    private ProofDocument proofDocument;
    private String proofDocumentError;

    ReferenceDocument(EnrollmentService enrollmentService, DocumentType documentType) {
        super(enrollmentService);
        this.documentType = documentType;
        enrollmentService.getDocManager().addChangeListener(e -> this.setDocumentAttached());
    }

    public ProofDocument getProof() {
        return this.proofDocument;
    }

    public String getProofDocumentError() {
        return this.proofDocumentError;
    }

    void setProofDocumentError(String proofDocumentError) {
        this.proofDocumentError = proofDocumentError;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        this.validate();
        this.fireChangeEvent(this);
    }

    public void setProofDocument(ProofDocument doc) {
        this.proofDocument = doc;
        this.validate();
        this.fireChangeEvent(this);
    }

    public void setProofDocumentForForeign(ProofDocument doc) {
        boolean fire = this.proofDocument != null && this.proofDocument.equals(doc);
        this.proofDocument = doc;
        this.validate();
        if (!fire) {
            this.fireDocNameChangeEvent(this);
        }
    }

    public void setDocumentAttached() {
        this.validate();
        this.fireChangeEvent(this);
    }

    public void setReadyToVerify() {
        this.validate();
        this.fireDocumentUploadEvent(this);
    }

    private void validate() {
        MsgKeysILV refDocErrorKey = null;
        if (super.isMandatory()) {
            if (this.proofDocument == null || this.proofDocument.toString().equalsIgnoreCase("Select")) {
                refDocErrorKey = MsgKeysILV.MANDATORY;
            } else if (StringUtils.isNotBlank((String)this.enrollmentService.getDocManager().getError(this.documentType))) {
                refDocErrorKey = MsgKeysILV.DOC_ATTACH_MANDATORY;
            }
        }
        this.proofDocumentError = this.getMessage((Object)refDocErrorKey, new Object[0]);
        this.setValid(this.proofDocumentError == null);
    }
}

