/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.icas.util.Verhoeff;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysEnrol;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.model.ReferenceRelative;
import org.apache.commons.lang.StringUtils;

public class ReferenceIntroducer
extends EnrolmentModelBase<ReferenceIntroducer> {
    private String name = "";
    private String nameLocal = "";
    private String aadhaarNumber = "";
    private String aadhaarNumberError;
    private String nameError;
    private String nameLocalError;
    private boolean nameTransliterationMismatch;

    ReferenceIntroducer(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.validate();
    }

    public void addRelativeDetailsChangeListener(ReferenceRelative referenceRelative) {
        referenceRelative.addChangeListener(this::onRelativeDetailChange);
    }

    private void onRelativeDetailChange(ReferenceRelative referenceRelative) {
        this.validate();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        boolean dataChanged = !this.name.equals(name);
        this.name = name;
        this.nameTransliterationMismatch = super.isTransliterationDiffValid(this.name, this.nameLocal);
        this.validate();
        if (dataChanged) {
            super.fireChangeEvent(this);
        }
    }

    public String getNameLocal() {
        return this.nameLocal;
    }

    public void setNameLocal(String nameLocal) {
        boolean dataChanged = !this.nameLocal.equals(nameLocal);
        this.nameLocal = nameLocal;
        this.nameTransliterationMismatch = super.isTransliterationDiffValid(this.name, this.nameLocal);
        this.validate();
        if (dataChanged) {
            super.fireChangeEvent(this);
        }
    }

    public String getNameError() {
        return this.nameError;
    }

    public String getNameLocalError() {
        return this.nameLocalError;
    }

    public String getAadhaarNumber() {
        return this.aadhaarNumber;
    }

    public void setAadhaarNumber(String aadhaarNumber) {
        boolean dataChanged = !this.aadhaarNumber.equals(aadhaarNumber);
        this.aadhaarNumber = aadhaarNumber;
        this.validate();
        if (dataChanged) {
            super.fireChangeEvent(this);
        }
    }

    public String getFormattedAadhaarNumber() {
        if (StringUtils.length((String)this.aadhaarNumber) == 12) {
            return String.format("%s-%s-%s", this.aadhaarNumber.substring(0, 4), this.aadhaarNumber.substring(4, 8), this.aadhaarNumber.substring(8, 12));
        }
        return "";
    }

    public String getAadhaarNumberError() {
        return this.aadhaarNumberError;
    }

    public boolean hasTransliterationMismatchForName() {
        return this.nameTransliterationMismatch;
    }

    public void unset(boolean unset) {
        if (unset) {
            this.setName("");
            this.setNameLocal("");
            this.setAadhaarNumber("");
        }
    }

    @Override
    public void setMandatory(boolean mandatory) {
        boolean isMandatory = super.isMandatory();
        super.setMandatory(mandatory);
        this.validate();
        if (isMandatory != mandatory) {
            super.fireChangeEvent(this);
        }
    }

    private void validate() {
        this.validateName();
        this.validateNameLocal();
        this.validateAadhaarNumber();
        super.setValid(this.nameError == null && this.nameLocalError == null && this.aadhaarNumberError == null);
    }

    private void validateName() {
        Enum nameErrorMsgKey = null;
        if (this.isMandatory() && StringUtils.isBlank((String)this.name)) {
            nameErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.isMandatory() && this.name.length() < 2) {
            nameErrorMsgKey = MsgKeysEnrol.NAME_TOOSHORT_WARNING;
        } else if (this.isMandatory() && !this.name.matches("^[a-zA-Z][a-zA-Z\\s.()']+")) {
            nameErrorMsgKey = MsgKeysEnrol.NAME_INVALID_WARNING;
        }
        this.nameError = this.getMessage(nameErrorMsgKey, new Object[0]);
    }

    private void validateNameLocal() {
        Enum nameLocalErrorMsgKey = null;
        if (this.isMandatory() && StringUtils.isBlank((String)this.nameLocal)) {
            nameLocalErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.isMandatory() && this.nameLocal.length() < 2) {
            nameLocalErrorMsgKey = MsgKeysEnrol.NAME_TOOSHORT_WARNING;
        } else if (this.isMandatory() && this.nameLocal.matches("[\\d]+")) {
            nameLocalErrorMsgKey = MsgKeysEnrol.NAME_INVALID_WARNING;
        }
        this.nameLocalError = this.getMessage(nameLocalErrorMsgKey, new Object[0]);
    }

    private void validateAadhaarNumber() {
        MsgKeysILV aadhaarErrorMsgKey = null;
        if (this.isMandatory()) {
            if (this.aadhaarNumber == null || this.aadhaarNumber.equals("")) {
                aadhaarErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.aadhaarNumber.startsWith("0") || this.aadhaarNumber.startsWith("1")) {
                aadhaarErrorMsgKey = MsgKeysILV.ZERO;
            } else if (!Verhoeff.validate((String)this.aadhaarNumber)) {
                aadhaarErrorMsgKey = MsgKeysILV.UID;
            } else if (!this.aadhaarNumber.equals("") && this.enrollmentService.getReferences().getReferenceRelative().getAadhaarNumber().equals(this.aadhaarNumber)) {
                aadhaarErrorMsgKey = MsgKeysILV.INTRO_UID_SAME;
            }
        }
        this.aadhaarNumberError = this.getMessage((Object)aadhaarErrorMsgKey, new Object[0]);
    }
}

