/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.icas.util.Verhoeff;
import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AadhaarNo;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.ApplicantGender;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysEnrol;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceAllowedRelationship;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.ReferenceIntroducer;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ReferenceRelative
extends EnrolmentModelBase<ReferenceRelative> {
    private final ReferenceAllowedRelationship allowedRelationshipType;
    private final List<References.Action> relationshipListRefreshListeners = new ArrayList<References.Action>();
    private RelationshipType relationshipType = RelationshipType.NOT_GIVEN;
    private String relationshipTypeError;
    private String name = "";
    private String nameLocal = "";
    private String nameError;
    private String nameLocalError;
    private boolean nameTransliterationMismatch;
    private String enrolmentId = "";
    private String enrolmentIdError;
    private String enrolmentDateTime = "";
    private String enrolmentDateTimeError;
    private String aadhaarNumber = "";
    private String aadhaarNumberError;
    private boolean notGiven;
    private boolean aadhaarNumberMandatory;
    private boolean enrolmentIdMandatory;
    private boolean enrolmentIdSelected = true;
    private boolean aadhaarNumberSelected;
    private AgeGroup ageGroup;

    ReferenceRelative(EnrollmentService enrollmentService, Demographics demographics) {
        super(enrollmentService);
        PersonalDetail personalDetail = demographics.getPersonalDetail();
        this.allowedRelationshipType = new ReferenceAllowedRelationship(enrollmentService);
        personalDetail.getAgeDob().addChangeListener(this::onDobChange);
        personalDetail.getApplicantGender().addChangeListener(this::onGenderChange);
        if (this.enrollmentService.isUpdateEnrollment()) {
            personalDetail.getAadhaarNumber().addChangeListener(this::onAadhaarNumberChange);
            enrollmentService.addResidentChildListeners(this::onChildUpdateChange);
        }
        if (this.enrollmentService.isUniversalClientTrnx()) {
            enrollmentService.addResidentChildListeners(this::onChildUpdateChangeForUC);
        }
        this.validate();
    }

    private void onChildUpdateChange(boolean childUpdate) {
        PersonalDetail personalDetail = this.enrollmentService.getDemographics().getPersonalDetail();
        AgeDob ageDob = personalDetail.getAgeDob();
        this.ageGroup = ageDob.getAgeGroup();
        Gender gender = personalDetail.getApplicantGender().getGender();
        if (this.enrollmentService.isChildEnrollment()) {
            this.allowedRelationshipType.loadRelativeRelationshipList(gender, ageDob, "BELOW5");
        } else if (this.enrollmentService.isMinorEnrollment()) {
            this.allowedRelationshipType.loadRelativeRelationshipList(gender, ageDob, "BETWEEN5TO18");
        } else if (this.enrollmentService.isAdultEnrollment()) {
            this.allowedRelationshipType.loadRelativeRelationshipList(gender, ageDob, "ABOVE18");
        }
        this.reEvaluateReferenceRelative();
        this.fireRelationshipListRefreshed();
    }

    private void onChildUpdateChangeForUC(boolean childUpdate) {
        PersonalDetail personalDetail = this.enrollmentService.getDemographics().getPersonalDetail();
        AgeDob ageDob = personalDetail.getAgeDob();
        this.ageGroup = ageDob.getAgeGroup();
        Gender gender = personalDetail.getApplicantGender().getGender();
        if (this.enrollmentService.isChildEnrollment()) {
            this.allowedRelationshipType.loadRelativeRelationshipList(gender, ageDob, "BELOW5");
        } else if (this.enrollmentService.isMinorEnrollment()) {
            this.allowedRelationshipType.loadRelativeRelationshipList(gender, ageDob, "BETWEEN5TO18");
        } else if (this.enrollmentService.isAdultEnrollment()) {
            this.allowedRelationshipType.loadRelativeRelationshipList(gender, ageDob, "ABOVE18");
        }
        this.reEvaluateReferenceRelative();
        this.fireRelationshipListRefreshed();
    }

    private void onMinorUpdateChange(boolean childUpdate) {
        PersonalDetail personalDetail = this.enrollmentService.getDemographics().getPersonalDetail();
        AgeDob ageDob = personalDetail.getAgeDob();
        this.ageGroup = ageDob.getAgeGroup();
        Gender gender = personalDetail.getApplicantGender().getGender();
        if (this.enrollmentService.isMinorEnrollment()) {
            this.allowedRelationshipType.loadRelativeRelationshipList(gender, ageDob, "BETWEEN5TO18");
        }
        this.reEvaluateReferenceRelative();
        this.fireRelationshipListRefreshed();
    }

    private void onAdultUpdateChange(boolean childUpdate) {
        PersonalDetail personalDetail = this.enrollmentService.getDemographics().getPersonalDetail();
        AgeDob ageDob = personalDetail.getAgeDob();
        this.ageGroup = ageDob.getAgeGroup();
        Gender gender = personalDetail.getApplicantGender().getGender();
        if (this.enrollmentService.isAdultEnrollment()) {
            this.allowedRelationshipType.loadRelativeRelationshipList(gender, ageDob, "ABOVE18");
        }
        this.reEvaluateReferenceRelative();
        this.fireRelationshipListRefreshed();
    }

    private void onAadhaarNumberChange(AadhaarNo aadhaarNo) {
        if (aadhaarNo.getAadhaarNumber().equalsIgnoreCase(this.aadhaarNumber)) {
            this.validate();
        }
    }

    private void onDobChange(AgeDob ageDob) {
        this.ageGroup = ageDob.getAgeGroup();
        this.reEvaluateReferenceRelative();
        Gender gender = this.enrollmentService.getDemographics().getPersonalDetail().getApplicantGender().getGender();
        this.allowedRelationshipType.loadRelativeRelationshipList(gender, ageDob, "");
        this.fireRelationshipListRefreshed();
    }

    private void onGenderChange(ApplicantGender gender) {
        PersonalDetail personalDetail = this.enrollmentService.getDemographics().getPersonalDetail();
        AgeDob ageDob = personalDetail.getAgeDob();
        String savedGender = this.allowedRelationshipType.getGender().toString();
        if (savedGender.equalsIgnoreCase(gender.toString()) && ageDob.getAgeGroup() == this.ageGroup) {
            return;
        }
        this.validate();
        this.allowedRelationshipType.loadRelativeRelationshipList(gender.getGender(), ageDob, "");
        this.fireRelationshipListRefreshed();
    }

    public void addReferenceIntroducerChangeListener(ReferenceIntroducer referenceIntroducer) {
        referenceIntroducer.addChangeListener(this::onRelativeIntroducerChange);
    }

    public void addHofDocumentChangeListener(ReferenceDocument hofDoc) {
        hofDoc.addChangeListener(this::onHofDocumentChange);
    }

    private void onHofDocumentChange(ReferenceDocument referenceDocument) {
        this.reEvaluateReferenceRelative();
    }

    private void onRelativeIntroducerChange(ReferenceIntroducer referenceIntroducer) {
        this.validate();
    }

    public void addRelationshipListRefreshListener(References.Action delegate) {
        this.relationshipListRefreshListeners.add(delegate);
    }

    public boolean isNotGiven() {
        return this.notGiven;
    }

    public void setNotGiven(boolean notGiven) {
        boolean valueChanged = notGiven != this.notGiven;
        this.notGiven = notGiven;
        if (this.notGiven) {
            this.reset();
        }
        this.reEvaluateReferenceRelative();
        if (valueChanged) {
            this.fireChangeEvent(this);
        }
    }

    ReferenceAllowedRelationship getAllowedRelationship() {
        return this.allowedRelationshipType;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        boolean valueChanged = relationshipType != this.relationshipType;
        this.relationshipType = relationshipType;
        this.reEvaluateReferenceRelative();
        if (valueChanged) {
            this.fireChangeEvent(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        boolean valueChanged = !name.equals(this.name);
        this.name = name;
        this.nameTransliterationMismatch = super.isTransliterationDiffValid(this.name, this.nameLocal);
        this.reEvaluateReferenceRelative();
        if (valueChanged) {
            this.fireChangeEvent(this);
        }
    }

    public String getNameLocal() {
        return this.nameLocal;
    }

    public void setNameLocal(String nameLocal) {
        boolean valueChanged = !nameLocal.equals(this.nameLocal);
        this.nameLocal = nameLocal;
        this.nameTransliterationMismatch = super.isTransliterationDiffValid(this.name, this.nameLocal);
        this.reEvaluateReferenceRelative();
        if (valueChanged) {
            this.fireChangeEvent(this);
        }
    }

    public String getNameError() {
        return this.nameError;
    }

    public String getNameLocalError() {
        return this.nameLocalError;
    }

    public boolean hasTransliterationMismatchForName() {
        return this.nameTransliterationMismatch;
    }

    public String getEnrolmentId() {
        return this.enrolmentId;
    }

    public void setEnrolmentId(String enrolmentId) {
        boolean valueChanged = !enrolmentId.equals(this.enrolmentId);
        this.enrolmentId = enrolmentId;
        this.reEvaluateReferenceRelative();
        if (valueChanged) {
            this.fireChangeEvent(this);
        }
    }

    public String getFormattedEID() {
        try {
            String eid = this.getRelativeEID();
            return String.format("%s/%s/%s %s/%s/%s %s:%s:%s", eid.substring(0, 4), eid.substring(4, 9), eid.substring(9, 14), eid.substring(20, 22), eid.substring(18, 20), eid.substring(14, 18), eid.substring(22, 24), eid.substring(24, 26), eid.substring(26));
        }
        catch (Exception e) {
            return this.enrolmentId + this.enrolmentDateTime;
        }
    }

    public String getRelativeEID() {
        return this.enrolmentId + ECMPDateFormatHelper.getReformattedDate(ECMPDateFormats.FULL_DATE_FORMAT1, ECMPDateFormats.FULL_DATE_FORMAT, this.enrolmentDateTime);
    }

    public String getEnrolmentIdError() {
        return this.enrolmentIdError;
    }

    public String getEnrolmentDateTime() {
        return this.enrolmentDateTime;
    }

    public void setEnrolmentDateTime(String enrolmentDateTime) {
        boolean valueChanged = !enrolmentDateTime.equals(this.enrolmentDateTime);
        this.enrolmentDateTime = enrolmentDateTime;
        this.reEvaluateReferenceRelative();
        if (valueChanged) {
            this.fireChangeEvent(this);
        }
    }

    public String getFormattedEnrolmentId() {
        if (StringUtils.length((String)this.enrolmentId) == 14) {
            return String.format("%s-%s-%s", this.enrolmentId.substring(0, 4), this.enrolmentId.substring(4, 9), this.enrolmentId.substring(9));
        }
        return "";
    }

    public String getEnrolmentDateTimeError() {
        return this.enrolmentDateTimeError;
    }

    public String getFormattedEnrolmentDateTime() {
        if (StringUtils.length((String)this.enrolmentDateTime) == 14) {
            return String.format("%s/%s/%s/%s/%s/%s", this.enrolmentDateTime.substring(0, 2), this.enrolmentDateTime.substring(2, 4), this.enrolmentDateTime.substring(4, 8), this.enrolmentDateTime.substring(8, 10), this.enrolmentDateTime.substring(10, 12), this.enrolmentDateTime.substring(12, 14));
        }
        return "";
    }

    public String getAadhaarNumber() {
        return this.aadhaarNumber;
    }

    public void setAadhaarNumber(String aadhaarNumber) {
        boolean valueChanged = !aadhaarNumber.equals(this.aadhaarNumber);
        this.aadhaarNumber = aadhaarNumber;
        this.reEvaluateReferenceRelative();
        if (valueChanged) {
            this.fireChangeEvent(this);
        }
    }

    public String getFormattedAadhaarNumber() {
        if (StringUtils.length((String)this.aadhaarNumber) == 12) {
            return String.format("%s-%s-%s", this.aadhaarNumber.substring(0, 4), this.aadhaarNumber.substring(4, 8), this.aadhaarNumber.substring(8, 12));
        }
        return "";
    }

    public String getAadhaarNumberError() {
        return this.aadhaarNumberError;
    }

    public String getRelationshipTypeError() {
        return this.relationshipTypeError;
    }

    public RelationshipType getDisplayRelationshipType() {
        return "Select".equalsIgnoreCase(String.valueOf((Object)this.relationshipType)) ? RelationshipType.NOT_GIVEN : this.relationshipType;
    }

    public String getDisplayEnrolmentId() {
        return StringUtils.isBlank((String)this.enrolmentId) ? "" : this.enrolmentId;
    }

    public String getDisplayEnrolmentDateTime() {
        return StringUtils.isBlank((String)this.enrolmentDateTime) ? "" : this.enrolmentDateTime;
    }

    public String getDisplayAadhaarNumber() {
        return StringUtils.isBlank((String)this.aadhaarNumber) ? "" : this.aadhaarNumber;
    }

    public boolean isAadhaarNumberMandatory() {
        return this.aadhaarNumberMandatory;
    }

    public boolean isEnrolmentIdMandatory() {
        return this.enrolmentIdMandatory;
    }

    private void reset() {
        this.setRelationshipType(RelationshipType.NOT_GIVEN);
        this.setName("");
        this.setNameLocal("");
        this.setAadhaarNumber("");
        this.setEnrolmentId("");
        this.setEnrolmentDateTime("");
        this.setMandatory(false);
        this.setEnrolmentIdSelected(true);
        this.setAadhaarNumberSelected(false);
    }

    public void setEnrolmentIdSelected(boolean selected) {
        this.enrolmentIdSelected = selected;
        this.aadhaarNumberSelected = !selected;
        this.reEvaluateReferenceRelative();
    }

    public void setAadhaarNumberSelected(boolean selected) {
        this.aadhaarNumberSelected = selected;
        this.enrolmentIdSelected = !selected;
        this.reEvaluateReferenceRelative();
    }

    private void reEvaluateReferenceRelative() {
        boolean isMandatory = super.isMandatory();
        boolean isChild = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().isChild();
        boolean hofBased = this.enrollmentService.getReferences().getHofDoc().isMandatory();
        this.setMandatory(isChild || hofBased || !this.name.equals("") || !this.nameLocal.equals("") || !this.enrolmentId.equals("") || !this.enrolmentDateTime.equals("") || !this.aadhaarNumber.equals("") || !this.relationshipType.toMnemonic().equals(""));
        if (this.isMandatory() && this.enrolmentIdSelected) {
            this.enrolmentIdMandatory = true;
            this.aadhaarNumberMandatory = false;
        } else if (this.isMandatory() && this.aadhaarNumberSelected) {
            this.aadhaarNumberMandatory = true;
            this.enrolmentIdMandatory = false;
        } else if (!this.isMandatory()) {
            this.enrolmentIdMandatory = false;
            this.aadhaarNumberMandatory = false;
        }
        if (isMandatory != super.isMandatory()) {
            this.fireChangeEvent(this);
        }
        this.validate();
    }

    private void validate() {
        this.validateRelationship();
        this.validateName();
        this.validateNameLocal();
        this.validateAadhaarNumber();
        this.validateEnrolmentId();
        this.validateEnrolmentDateTime();
        this.setValid(this.relationshipTypeError == null && this.nameError == null && this.nameLocalError == null && this.aadhaarNumberError == null && this.enrolmentIdError == null && this.enrolmentDateTimeError == null);
    }

    private void validateRelationship() {
        MsgKeysILV relationshipTypeErrorMsgKey = null;
        List<RelationshipType> allowedRelationships = this.allowedRelationshipType.getAllowedRelationshipList();
        if (this.isMandatory() && this.relationshipType.toMnemonic().equals("")) {
            relationshipTypeErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.isMandatory() && allowedRelationships.stream().noneMatch(r -> r.toMnemonic().equals(this.relationshipType.toMnemonic()))) {
            relationshipTypeErrorMsgKey = MsgKeysILV.RELATION_TYPE;
        }
        this.relationshipTypeError = this.getMessage((Object)relationshipTypeErrorMsgKey, new Object[0]);
    }

    private void validateName() {
        Enum nameErrorMsgKey = null;
        if (this.isMandatory() && StringUtils.isBlank((String)this.name)) {
            nameErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.isMandatory() && this.name.length() < 2) {
            nameErrorMsgKey = MsgKeysEnrol.NAME_TOOSHORT_WARNING;
        } else if (this.isMandatory() && !this.name.matches("^[a-zA-Z][a-zA-Z\\s.()']+")) {
            nameErrorMsgKey = MsgKeysEnrol.NAME_INVALID_WARNING;
        }
        this.nameError = this.getMessage(nameErrorMsgKey, new Object[0]);
    }

    private void validateNameLocal() {
        Enum nameLocalErrorMsgKey = null;
        if (this.isMandatory() && StringUtils.isBlank((String)this.nameLocal)) {
            nameLocalErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.isMandatory() && this.nameLocal.length() < 2) {
            nameLocalErrorMsgKey = MsgKeysEnrol.NAME_TOOSHORT_WARNING;
        } else if (this.isMandatory() && this.nameLocal.matches("[\\d]+")) {
            nameLocalErrorMsgKey = MsgKeysEnrol.NAME_INVALID_WARNING;
        }
        this.nameLocalError = this.getMessage(nameLocalErrorMsgKey, new Object[0]);
    }

    private void validateAadhaarNumber() {
        MsgKeysILV aadhaarErrorMsgKey = null;
        if (this.isMandatory() && this.aadhaarNumberMandatory) {
            if (this.aadhaarNumber == null || this.aadhaarNumber.equals("")) {
                aadhaarErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.aadhaarNumber.startsWith("0") || this.aadhaarNumber.startsWith("1")) {
                aadhaarErrorMsgKey = MsgKeysILV.ZERO;
            } else if (!Verhoeff.validate((String)this.aadhaarNumber)) {
                aadhaarErrorMsgKey = MsgKeysILV.UID;
            } else if (!this.aadhaarNumber.equals("") && this.enrollmentService.getReferences().getReferenceIntroducer().getAadhaarNumber().equals(this.aadhaarNumber)) {
                aadhaarErrorMsgKey = MsgKeysILV.INTRO_UID_SAME;
            } else if (this.enrollmentService.isUpdateEnrollment() && this.enrollmentService.getDemographics().getPersonalDetail().getAadhaarNumber().getAadhaarNumber().equalsIgnoreCase(this.aadhaarNumber)) {
                aadhaarErrorMsgKey = MsgKeysILV.UID_SAME;
            }
        }
        this.aadhaarNumberError = this.getMessage((Object)aadhaarErrorMsgKey, new Object[0]);
    }

    private void validateEnrolmentId() {
        MsgKeysILV enrolmentIdErrorMsgKey = null;
        if (this.isMandatory() && this.enrolmentIdMandatory && this.enrolmentId.equals("")) {
            enrolmentIdErrorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.enrolmentIdError = this.getMessage((Object)enrolmentIdErrorMsgKey, new Object[0]);
    }

    private void validateEnrolmentDateTime() {
        MsgKeysILV enrolmentDateTimeErrorMsgKey = null;
        if (this.isMandatory() && this.enrolmentIdMandatory && this.enrolmentDateTime.equals("")) {
            enrolmentDateTimeErrorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.enrolmentDateTimeError = this.getMessage((Object)enrolmentDateTimeErrorMsgKey, new Object[0]);
    }

    private void fireRelationshipListRefreshed() {
        this.relationshipListRefreshListeners.forEach(References.Action::accept);
    }
}

