/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.model.Name;
import in.gov.uidai.ec.service.enrollment.model.ReferenceAllowedDocuments;
import in.gov.uidai.ec.service.enrollment.model.ReferenceAllowedRelationship;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.ReferenceIntroducer;
import in.gov.uidai.ec.service.enrollment.model.ReferenceRelative;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInformation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class References
extends EnrolmentModelBase<References> {
    private final ReferenceDocument pob;
    private final ReferenceDocument poi;
    private final ReferenceDocument poa;
    private final ReferenceDocument hofDoc;
    private final ReferenceDocument por;
    private final ReferenceDocument pof;
    private ReferenceAllowedDocuments allowedDocuments;
    private final ReferenceIntroducer referenceIntroducer;
    private final ReferenceRelative referenceRelative;
    private final List<Action> documentListRefreshListeners = new ArrayList<Action>();

    public References(EnrollmentService enrollmentService, Demographics demographics) {
        super(enrollmentService);
        this.allowedDocuments = new ReferenceAllowedDocuments(enrollmentService);
        this.pob = new ReferenceDocument(enrollmentService, DocumentType.POB);
        this.poi = new ReferenceDocument(enrollmentService, DocumentType.POI);
        this.poa = new ReferenceDocument(enrollmentService, DocumentType.POA);
        this.hofDoc = new ReferenceDocument(enrollmentService, DocumentType.HOF);
        this.por = new ReferenceDocument(enrollmentService, DocumentType.POR);
        this.pof = new ReferenceDocument(enrollmentService, DocumentType.POF);
        this.referenceIntroducer = new ReferenceIntroducer(enrollmentService);
        this.referenceRelative = new ReferenceRelative(enrollmentService, demographics);
        if (enrollmentService.isUniversalClientTrnx()) {
            this.pob.setMandatory(false);
            this.poi.setMandatory(false);
            this.poa.setMandatory(false);
            this.por.setMandatory(false);
            this.pof.setMandatory(false);
            this.hofDoc.setMandatory(false);
        } else {
            this.pob.setMandatory(enrollmentService.isNewEnrollmentUC() && !enrollmentService.isForeignResident());
            this.poi.setMandatory(!enrollmentService.isUpdateEnrollment() || enrollmentService.isDocumentUpdate() || enrollmentService.isOffLineDocumentUpdate());
            this.poa.setMandatory(!enrollmentService.isUpdateEnrollment() || enrollmentService.isDocumentUpdate() || enrollmentService.isOffLineDocumentUpdate());
            this.hofDoc.setMandatory(enrollmentService.isOnlineUpdate() && enrollmentService.isHofEnrollment());
            this.por.setMandatory(enrollmentService.isOnlineUpdate() && enrollmentService.isHofEnrollment());
            this.pof.setMandatory(enrollmentService.isForeignResident());
        }
        if (!enrollmentService.isUniversalClientTrnx()) {
            demographics.getResidentialStatus().addChangeListener(residentialStatus -> this.reEvaluateReferences(residentialStatus.isNRI(), enrollmentService.getDemoPersonalDetails().getAgeDob().getAgeGroup()));
            demographics.getPersonalDetail().getAgeDob().addChangeListener(ageDob -> this.reEvaluateReferences(enrollmentService.getDemoResidentialStatus().isNRI(), ageDob.getAgeGroup()));
        }
        this.pob.addValidityChangeListener(this::reEvalReferenceValidity);
        this.pob.addChangeListener(this::onDocumentChange);
        this.poi.addValidityChangeListener(this::reEvalReferenceValidity);
        this.poi.addChangeListener(this::onDocumentChange);
        this.poa.addValidityChangeListener(this::reEvalReferenceValidity);
        this.poa.addChangeListener(this::onDocumentChange);
        this.hofDoc.addValidityChangeListener(this::reEvalReferenceValidity);
        this.hofDoc.addChangeListener(this::onDocumentChange);
        this.por.addValidityChangeListener(this::reEvalReferenceValidity);
        this.por.addChangeListener(this::onDocumentChange);
        this.pof.addValidityChangeListener(this::reEvalReferenceValidity);
        this.pof.addChangeListener(this::onDocumentChange);
        this.referenceIntroducer.addValidityChangeListener(this::reEvalReferenceValidity);
        this.referenceIntroducer.addChangeListener(this::onIntroducerValueChange);
        this.referenceIntroducer.addRelativeDetailsChangeListener(this.referenceRelative);
        this.referenceRelative.addValidityChangeListener(this::reEvalReferenceValidity);
        this.referenceRelative.addChangeListener(this::onReferenceRelativeValueChange);
        this.referenceRelative.addReferenceIntroducerChangeListener(this.referenceIntroducer);
        this.referenceRelative.addHofDocumentChangeListener(this.hofDoc);
        this.addEventListenersForUpdate(enrollmentService.isUpdateEnrollment());
        this.validateOnTabLoad();
    }

    private void addEventListenersForUpdate(boolean isUpdateEnrollment) {
        if (!isUpdateEnrollment) {
            return;
        }
        Demographics demographics = this.enrollmentService.getDemographics();
        demographics.getPersonalDetail().getName().addUpdateChangeListener(this::onNameUpdate);
        demographics.getContact().getAddress().addUpdateChangeListener(this::onAddressUpdate);
        demographics.getPersonalDetail().getAgeDob().addUpdateChangeListener(this::onAgeDobUpdate);
    }

    private void onNameUpdate(Name name) {
        this.evaluateDocumentMandatory();
    }

    private void onAddressUpdate(Address address) {
        this.evaluateDocumentMandatory();
    }

    private void onAgeDobUpdate(AgeDob ageDob) {
        this.pob.setMandatory(ageDob.isUpdated() || this.enrollmentService.getIsPobRequired());
    }

    private void onReferenceRelativeValueChange(ReferenceRelative referenceRelative) {
        this.fireChangeEvent(this);
    }

    private void onIntroducerValueChange(ReferenceIntroducer referenceIntroducer) {
        this.fireChangeEvent(this);
    }

    private void onDocumentChange(ReferenceDocument referenceDocument) {
        this.fireChangeEvent(this);
    }

    public void reEvalReferenceValidity(boolean isValid) {
        if (!this.enrollmentService.isEnrolmentStateNull() && this.enrollmentService.isUniversalClientTrnx()) {
            this.setValid(isValid && this.pob.isValid() && this.poi.isValid() && this.poa.isValid() && this.pof.isValid() && this.por.isValid());
        } else {
            this.setValid(isValid && this.pob.isValid() && this.poi.isValid() && this.poa.isValid() && this.hofDoc.isValid() && this.referenceRelative.isValid());
        }
    }

    public void addDocumentListRefreshListener(Action delegate) {
        this.documentListRefreshListeners.add(delegate);
    }

    public ReferenceAllowedDocuments getAllowedDocuments() {
        return this.allowedDocuments;
    }

    public ReferenceAllowedRelationship getAllowedRelationship() {
        return this.referenceRelative.getAllowedRelationship();
    }

    public ReferenceDocument getPob() {
        return this.pob;
    }

    public ReferenceDocument getPoi() {
        return this.poi;
    }

    public ReferenceDocument getPoa() {
        return this.poa;
    }

    public ReferenceDocument getHofDoc() {
        return this.hofDoc;
    }

    public ReferenceDocument getPor() {
        return this.por;
    }

    public ReferenceDocument getPof() {
        return this.pof;
    }

    public ReferenceDocument getReferenceDoc(DocumentType docType) {
        switch (docType) {
            case POI: {
                return this.poi;
            }
            case POA: {
                return this.poa;
            }
            case POB: {
                return this.pob;
            }
            case HOF: {
                return this.hofDoc;
            }
            case POR: {
                return this.por;
            }
            case POF: {
                return this.pof;
            }
        }
        return null;
    }

    public ReferenceIntroducer getReferenceIntroducer() {
        return this.referenceIntroducer;
    }

    public ReferenceRelative getReferenceRelative() {
        return this.referenceRelative;
    }

    private void validateOnTabLoad() {
        this.validatePob();
        this.validatePoi();
        this.validatePoa();
        this.setValid(this.pob.isValid() && this.poi.isValid() && this.poa.isValid() && this.hofDoc.isValid() && this.referenceIntroducer.isValid() && this.referenceRelative.isValid());
    }

    private void validatePob() {
        MsgKeysILV pobErrorMsgKey = null;
        if (this.pob.isMandatory() && (this.pob.getProof() == null || StringUtils.isBlank((String)this.pob.getProof().toString()))) {
            pobErrorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.pob.setProofDocumentError(this.getMessage((Object)pobErrorMsgKey, new Object[0]));
    }

    private void validatePoi() {
        MsgKeysILV poiErrorMsgKey = null;
        if (this.poi.isMandatory() && (this.poi.getProof() == null || StringUtils.isBlank((String)this.poi.getProof().toString()))) {
            poiErrorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.poi.setProofDocumentError(this.getMessage((Object)poiErrorMsgKey, new Object[0]));
    }

    private void validatePoa() {
        MsgKeysILV poaErrorMsgKey = null;
        if (this.poa.isMandatory() && (this.poa.getProof() == null || StringUtils.isBlank((String)this.poa.getProof().toString()))) {
            poaErrorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.poa.setProofDocumentError(this.getMessage((Object)poaErrorMsgKey, new Object[0]));
    }

    public void reEvaluateReferences(boolean isNRI, AgeGroup ageGroup) {
        if (ageGroup == this.allowedDocuments.currentAgeGroup() || isNRI == this.allowedDocuments.currentIsNRI()) {
            this.evaluateDocumentMandatory();
            this.allowedDocuments.loadDocumentsList(ageGroup, isNRI, null);
            if (this.documentNotInAllowedList(this.pob.getProof(), this.allowedDocuments.getPobDocs())) {
                this.pob.setProofDocument(null);
            }
            if (this.documentNotInAllowedList(this.poi.getProof(), this.allowedDocuments.getPoiDocs())) {
                this.poi.setProofDocument(null);
            }
            if (this.documentNotInAllowedList(this.poa.getProof(), this.allowedDocuments.getPoaDocs())) {
                this.poa.setProofDocument(null);
            }
            if (this.documentNotInAllowedList(this.hofDoc.getProof(), this.allowedDocuments.getHofDocs())) {
                this.hofDoc.setProofDocument(null);
            }
            if (this.documentNotInAllowedList(this.por.getProof(), this.allowedDocuments.getPorDocs())) {
                this.por.setProofDocument(null);
            }
            if (this.documentNotInAllowedList(this.pof.getProof(), this.allowedDocuments.getPofDocs())) {
                this.pof.setProofDocument(null);
            }
            this.fireDocumentListRefreshed();
        }
    }

    public void reEvaluateReferences(boolean isNRI, AgeGroup ageGroup, RelationshipType type) {
        this.evaluateDocumentMandatory();
        this.allowedDocuments.loadDocumentsList(ageGroup, isNRI, type);
        if (this.documentNotInAllowedList(this.pob.getProof(), this.allowedDocuments.getPobDocs())) {
            this.pob.setProofDocument(null);
        }
        if (this.documentNotInAllowedList(this.poi.getProof(), this.allowedDocuments.getPoiDocs())) {
            this.poi.setProofDocument(null);
        }
        if (this.documentNotInAllowedList(this.poa.getProof(), this.allowedDocuments.getPoaDocs())) {
            this.poa.setProofDocument(null);
        }
        if (this.documentNotInAllowedList(this.hofDoc.getProof(), this.allowedDocuments.getHofDocs())) {
            this.hofDoc.setProofDocument(null);
        }
        if (this.documentNotInAllowedList(this.por.getProof(), this.allowedDocuments.getPorDocs())) {
            this.por.setProofDocument(null);
        }
        if (this.documentNotInAllowedList(this.pof.getProof(), this.allowedDocuments.getPofDocs())) {
            this.pof.setProofDocument(null);
        }
        this.fireDocumentListRefreshed();
    }

    public ReferenceDocument getProof(DocumentType docType) {
        switch (docType) {
            case POI: {
                return this.poi;
            }
            case POA: {
                return this.poa;
            }
            case POB: {
                return this.pob;
            }
            case HOF: {
                return this.hofDoc;
            }
            case POR: {
                return this.por;
            }
            case POF: {
                return this.pof;
            }
        }
        return null;
    }

    public void evaluateDocumentMandatory() {
        boolean isUpdateEnrollment = this.enrollmentService.isUpdateEnrollment();
        boolean nriEnrolment = this.enrollmentService.isNRIEnrolment();
        boolean isDocumentUpdate = this.enrollmentService.isDocumentUpdate();
        boolean isOffLineDocumentUpdate = this.enrollmentService.isOffLineDocumentUpdate();
        Name name = this.enrollmentService.getDemographics().getPersonalDetail().getName();
        Address address = this.enrollmentService.getDemographics().getContact().getAddress();
        AgeDob ageDob = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            if (this.enrollmentService.isUpdateUC()) {
                this.poi.setMandatory(FieldInfoUtils.isFieldEnabled(FieldInformation.POI));
                this.poa.setMandatory(FieldInfoUtils.isFieldEnabled(FieldInformation.POA));
                this.por.setMandatory(FieldInfoUtils.isFieldEnabled(FieldInformation.POR));
                this.pof.setMandatory(FieldInfoUtils.isFieldEnabled(FieldInformation.POF));
            } else {
                this.poi.setMandatory(this.enrollmentService.isDocumentBasedEnrollment());
                this.poa.setMandatory(this.enrollmentService.isDocumentBasedEnrollment());
                this.por.setMandatory(this.enrollmentService.isHofEnrollment());
                this.pof.setMandatory(this.enrollmentService.isForeignResident());
                this.pob.setMandatory(this.enrollmentService.getIsPobRequired());
            }
        } else {
            if (isUpdateEnrollment) {
                if (this.enrollmentService.isHofEnrollment()) {
                    this.poi.setMandatory(false);
                    this.poa.setMandatory(false);
                } else {
                    this.poi.setMandatory(name.isUpdated() || nriEnrolment || isDocumentUpdate || isOffLineDocumentUpdate);
                    this.poa.setMandatory(address.isUpdated() || isDocumentUpdate || isOffLineDocumentUpdate);
                }
                if (!(name.isUpdated() || address.isUpdated() || ageDob.isUpdated())) {
                    this.hofDoc.setMandatory(false);
                }
                if (this.enrollmentService.isChildEnrollment() && ageDob.isUpdated()) {
                    this.hofDoc.setMandatory(true);
                }
            }
            if (nriEnrolment && !this.enrollmentService.isUpdateEnrollment()) {
                if (!this.poi.isMandatory() && !this.poa.isMandatory()) {
                    this.hofDoc.setMandatory(true);
                } else if (this.poi.isMandatory() && this.poa.isMandatory()) {
                    this.hofDoc.setMandatory(false);
                } else {
                    this.poi.setMandatory(true);
                    this.hofDoc.setMandatory(true);
                }
            }
        }
    }

    private void fireDocumentListRefreshed() {
        for (Action listener : this.documentListRefreshListeners) {
            listener.accept();
        }
    }

    private boolean documentNotInAllowedList(ProofDocument document, List<ProofDocument> allDocuments) {
        if (document == null) {
            return true;
        }
        return allDocuments.stream().noneMatch(doc -> doc.toString().equalsIgnoreCase(document.toString()));
    }

    public void setAllowedDocuments(ReferenceAllowedDocuments allowedDocuments) {
        this.allowedDocuments = allowedDocuments;
    }

    public void setMandatory(boolean foreign, boolean isRequired) {
        this.pof.setMandatory(foreign);
        this.pob.setMandatory(!foreign && isRequired);
    }

    public static interface Action {
        public void accept();
    }
}

