/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.icas.util.Verhoeff;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysEnrol;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import org.apache.commons.lang.StringUtils;

public class RelativeDetail
extends EnrolmentModelBase<RelativeDetail> {
    private String name = "";
    private String uid = "";
    private RelationshipType relationType;
    private String reasonCode;
    private String relativeError;
    private String nameError;
    private String uidError;
    private boolean isHOF;

    public RelativeDetail(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.setMandatory(true);
        this.validate();
    }

    private void validate() {
        if (this.isMandatory()) {
            MsgKeysILV error = null;
            this.validateName();
            this.validateAadhaarNumber();
            if (this.relationType == null || this.relationType.equals((Object)RelationshipType.NOT_GIVEN)) {
                error = MsgKeysILV.MANDATORY;
            }
            this.relativeError = this.getMessage((Object)error, new Object[0]);
            this.setValid(this.relativeError == null && this.nameError == null && this.uidError == null);
        } else {
            this.relativeError = null;
            this.nameError = null;
            this.uidError = null;
            this.setValid(true);
        }
    }

    private void validateName() {
        MsgKeysEnrol nameErrorMsgKey = null;
        if (!StringUtils.isBlank((String)this.name)) {
            if (this.name.length() < 2) {
                nameErrorMsgKey = MsgKeysEnrol.NAME_TOOSHORT_WARNING;
            } else if (!this.name.matches("^[a-zA-Z][a-zA-Z\\s.()']+")) {
                nameErrorMsgKey = MsgKeysEnrol.NAME_INVALID_WARNING;
            }
        } else if (this.enrollmentService.isUpdateUC()) {
            nameErrorMsgKey = MsgKeysEnrol.NAME_MANDATORY;
        }
        this.nameError = this.getMessage((Object)nameErrorMsgKey, new Object[0]);
    }

    private void validateAadhaarNumber() {
        MsgKeysILV aadhaarErrorMsgKey = null;
        if (this.uid.startsWith("0") || this.uid.startsWith("1")) {
            aadhaarErrorMsgKey = MsgKeysILV.ZERO;
        } else if (!Verhoeff.validate((String)this.uid)) {
            aadhaarErrorMsgKey = MsgKeysILV.UID;
        }
        this.uidError = this.getMessage((Object)aadhaarErrorMsgKey, new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
        this.validate();
        this.fireChangeEvent(this);
    }

    public RelationshipType getRelationType() {
        return this.relationType;
    }

    public void setRelationType(RelationshipType relationType) {
        this.relationType = relationType;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public String getRelativeError() {
        return this.relativeError;
    }

    public String getNameError() {
        return this.nameError;
    }

    public String getUidError() {
        return this.uidError;
    }

    public boolean isHOF() {
        return this.isHOF;
    }

    public void setHOF(boolean HOF) {
        this.isHOF = HOF;
    }
}

