/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.ecmpapi.xml.bioverify.auth.Signature;
import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.BiometricsCaptureTrail;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResidentConfirmation
extends EnrolmentModelBase<ResidentConfirmation> {
    private final Biometrics leftSlap;
    private final Biometrics rightSlap;
    private final Biometrics bothThumbs;
    private final Biometrics leftIris;
    private final Biometrics rightIris;
    private BiometricPosition biometricPosition;
    private BiometricsCaptureTrail residentRdCaptureTrail;
    private Signature rdSignature;

    ResidentConfirmation(EnrollmentService enrollmentService) {
        super(enrollmentService);
        super.setMandatory(true);
        this.leftSlap = new Biometrics(enrollmentService, CaptureModality.LEFT_SLAP, this.getBodyPartsForLeftSlap(), new ArrayList<BodyPart>(), true);
        this.rightSlap = new Biometrics(enrollmentService, CaptureModality.RIGHT_SLAP, this.getBodyPartsForRightSlap(), new ArrayList<BodyPart>(), false);
        this.bothThumbs = new Biometrics(enrollmentService, CaptureModality.THUMB_SLAP, this.getBodyPartsForThumbSlap(), new ArrayList<BodyPart>(), false);
        this.leftIris = new Biometrics(enrollmentService, CaptureModality.LEFT_IRIS, this.getBodyPartsForLeftEye(), new ArrayList<BodyPart>(), false);
        this.rightIris = new Biometrics(enrollmentService, CaptureModality.RIGHT_IRIS, this.getBodyPartsForRightEye(), new ArrayList<BodyPart>(), false);
        this.leftSlap.addValidityChangeListener(this::reEvaluateResidentConfirmationValidity);
        this.leftSlap.setMaxCaptureAttempts(1);
        this.leftSlap.setBypassQualityCheckAfterMaxAttempt(false);
        this.rightSlap.addValidityChangeListener(this::reEvaluateResidentConfirmationValidity);
        this.rightSlap.setMaxCaptureAttempts(1);
        this.rightSlap.setBypassQualityCheckAfterMaxAttempt(false);
        this.bothThumbs.addValidityChangeListener(this::reEvaluateResidentConfirmationValidity);
        this.bothThumbs.setMaxCaptureAttempts(1);
        this.bothThumbs.setBypassQualityCheckAfterMaxAttempt(false);
        this.leftIris.addValidityChangeListener(this::reEvaluateResidentConfirmationValidity);
        this.leftIris.setMaxCaptureAttempts(1);
        this.leftIris.setBypassQualityCheckAfterMaxAttempt(false);
        this.rightIris.addValidityChangeListener(this::reEvaluateResidentConfirmationValidity);
        this.rightIris.setMaxCaptureAttempts(1);
        this.rightIris.setBypassQualityCheckAfterMaxAttempt(false);
        this.leftSlap.addChangeListener(this::onBiometricChangeListener);
        this.rightSlap.addChangeListener(this::onBiometricChangeListener);
        this.bothThumbs.addChangeListener(this::onBiometricChangeListener);
        this.leftIris.addChangeListener(this::onBiometricChangeListener);
        this.rightIris.addChangeListener(this::onBiometricChangeListener);
        this.enrollmentService.addBiometricUpdateChangeListener(this::onEnrolmentUpdateTypeChange);
        this.reEvaluateResidentConfirmationValidity(true);
    }

    private void onBiometricChangeListener(Biometrics biometrics) {
        this.fireChangeEvent(this);
    }

    public Biometrics getLeftSlap() {
        return this.leftSlap;
    }

    public Biometrics getRightSlap() {
        return this.rightSlap;
    }

    public Biometrics getBothThumbs() {
        return this.bothThumbs;
    }

    public Biometrics getLeftIris() {
        return this.leftIris;
    }

    public Biometrics getRightIris() {
        return this.rightIris;
    }

    private List<BodyPart> getBodyPartsForLeftSlap() {
        return new ArrayList<BodyPart>(){
            {
                this.add(BodyPart.POINTER_FINGER_LEFT);
                this.add(BodyPart.MIDDLE_FINGER_LEFT);
                this.add(BodyPart.RING_FINGER_LEFT);
                this.add(BodyPart.LITTLE_FINGER_LEFT);
            }
        };
    }

    private List<BodyPart> getBodyPartsForRightSlap() {
        return new ArrayList<BodyPart>(){
            {
                this.add(BodyPart.POINTER_FINGER_RIGHT);
                this.add(BodyPart.MIDDLE_FINGER_RIGHT);
                this.add(BodyPart.RING_FINGER_RIGHT);
                this.add(BodyPart.LITTLE_FINGER_RIGHT);
            }
        };
    }

    private List<BodyPart> getBodyPartsForThumbSlap() {
        return new ArrayList<BodyPart>(){
            {
                this.add(BodyPart.THUMB_LEFT);
                this.add(BodyPart.THUMB_RIGHT);
            }
        };
    }

    private List<BodyPart> getBodyPartsForLeftEye() {
        return Collections.singletonList(BodyPart.IRIS_LEFT);
    }

    private List<BodyPart> getBodyPartsForRightEye() {
        return Collections.singletonList(BodyPart.IRIS_RIGHT);
    }

    public void setCaptureAttempt(CaptureAttempt captureAttempt, BiometricPosition biometricPosition) {
        this.biometricPosition = biometricPosition;
        switch (biometricPosition) {
            case LEFT_IRIS: {
                this.leftIris.clearAttempts();
                this.leftIris.addCaptureAttempt(captureAttempt);
                this.leftIris.setBestAttempt(captureAttempt);
                break;
            }
            case RIGHT_IRIS: {
                this.rightIris.clearAttempts();
                this.rightIris.addCaptureAttempt(captureAttempt);
                this.rightIris.setBestAttempt(captureAttempt);
                break;
            }
            case LEFT_SLAP: {
                this.leftSlap.clearAttempts();
                this.leftSlap.addCaptureAttempt(captureAttempt);
                this.leftSlap.setBestAttempt(captureAttempt);
                break;
            }
            case RIGHT_SLAP: {
                this.rightSlap.clearAttempts();
                this.rightSlap.addCaptureAttempt(captureAttempt);
                this.rightSlap.setBestAttempt(captureAttempt);
                break;
            }
            case BOTH_THUMBS: {
                this.bothThumbs.clearAttempts();
                this.bothThumbs.addCaptureAttempt(captureAttempt);
                this.bothThumbs.setBestAttempt(captureAttempt);
            }
        }
    }

    public BiometricPosition getBiometricPosition() {
        return this.biometricPosition;
    }

    public void setMandatory(BiometricPosition biometricPosition) {
        this.rightSlap.setMandatory(false);
        this.leftSlap.setMandatory(false);
        this.rightIris.setMandatory(false);
        this.leftIris.setMandatory(false);
        this.bothThumbs.setMandatory(false);
        switch (biometricPosition) {
            case LEFT_IRIS: {
                this.leftIris.setMandatory(true);
                break;
            }
            case RIGHT_IRIS: {
                this.rightIris.setMandatory(true);
                break;
            }
            case LEFT_SLAP: {
                this.leftSlap.setMandatory(true);
                break;
            }
            case RIGHT_SLAP: {
                this.rightSlap.setMandatory(true);
                break;
            }
            case BOTH_THUMBS: {
                this.bothThumbs.setMandatory(true);
            }
        }
        this.reset();
    }

    public void setRDBioCapture(Signature signature, CaptureAttempt capturedAttempt) {
        this.rdSignature = signature;
        this.residentRdCaptureTrail = new BiometricsCaptureTrail();
        this.residentRdCaptureTrail.setBestCapture(this.enrollmentService.getConfirmerDetails().getBioCapture(capturedAttempt, BodyPart.FACE));
        this.residentRdCaptureTrail.setModality(CaptureModality.FACE);
        this.validate();
    }

    public BiometricsCaptureTrail getResidentRdCaptureTrail() {
        return this.residentRdCaptureTrail;
    }

    public Signature getRdSignature() {
        return this.rdSignature;
    }

    private void onEnrolmentUpdateTypeChange(Boolean isBiometricUpdate) {
        this.setMandatory(isBiometricUpdate == false);
        this.validate();
    }

    private void reEvaluateResidentConfirmationValidity(boolean valid) {
        this.validate();
    }

    private void validate() {
        this.setValid(!this.isMandatory() || this.leftSlap.isValid() && this.rightSlap.isValid() && this.bothThumbs.isValid() && this.leftIris.isValid() && this.rightIris.isValid() || this.rdSignature != null);
    }

    public void reset() {
        this.leftSlap.clearAttempts();
        this.rightSlap.clearAttempts();
        this.bothThumbs.clearAttempts();
        this.leftIris.clearAttempts();
        this.rightIris.clearAttempts();
        this.rdSignature = null;
        this.validate();
    }
}

