/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.icas.util.Verhoeff;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ResidentInfo
extends EnrolmentModelBase<ResidentInfo> {
    private boolean isBioException;
    private boolean indianResident = true;
    private boolean nriResident;
    private boolean foreignResident;
    private boolean documentBased;
    private boolean hofBased;
    private boolean isPobPresent;
    private boolean indianAddress;
    private boolean foreignAddress;
    private boolean isDemoUpdate;
    private boolean isBioUpdate;
    private boolean isWhitelist;
    private String linkedEid = "";
    private String grievanceId = "";
    private String isd = "";
    private String mobile = "";
    private String email = "";
    private String hofUid = "";
    private RelationshipType residentType = RelationshipType.NOT_GIVEN;
    private String isdError;
    private String mobileError;
    private String emailError;
    private String hofUidError;
    private String relationTypeError;

    public ResidentInfo(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.validate();
    }

    private void validate() {
        this.validateHOF();
        this.validateEmail();
        this.validateRelationType();
        this.setValid(this.isdError == null && this.mobileError == null && this.emailError == null && this.hofUidError == null && this.relationTypeError == null);
    }

    private void validateHOF() {
        MsgKeysILV aadhaarErrorMsgKey = null;
        if (this.hofBased) {
            if (StringUtils.isBlank((String)this.hofUid)) {
                aadhaarErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.hofUid.startsWith("0") || this.hofUid.startsWith("1")) {
                aadhaarErrorMsgKey = MsgKeysILV.ZERO;
            } else if (!Verhoeff.validate((String)this.hofUid)) {
                aadhaarErrorMsgKey = MsgKeysILV.UID;
            }
        }
        this.hofUidError = this.getMessage((Object)aadhaarErrorMsgKey, new Object[0]);
    }

    private void validateRelationType() {
        MsgKeysILV error = null;
        if (this.hofBased && this.residentType.equals((Object)RelationshipType.NOT_GIVEN)) {
            error = MsgKeysILV.MANDATORY;
        }
        this.relationTypeError = this.getMessage((Object)error, new Object[0]);
    }

    private void validateEmail() {
        MsgKeysILV emailErrorMsgKey = null;
        String EMAIL_PATTERN = "^[_A-Za-z0-9-+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        if (!this.indianResident || !StringUtils.isBlank((String)this.email)) {
            Pattern pattern;
            Matcher matcher;
            if (StringUtils.isBlank((String)this.email)) {
                emailErrorMsgKey = MsgKeysILV.EMAIL_MANDATORY;
            } else if (!StringUtils.isBlank((String)this.email) && !(matcher = (pattern = Pattern.compile("^[_A-Za-z0-9-+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$")).matcher(this.email)).matches()) {
                emailErrorMsgKey = MsgKeysILV.EMAIL_INVALID;
            }
        }
        this.emailError = this.getMessage((Object)emailErrorMsgKey, new Object[0]);
    }

    public boolean isBioException() {
        return this.isBioException;
    }

    public void setBioException(boolean bioException) {
        this.isBioException = bioException;
    }

    public boolean isIndianResident() {
        return this.indianResident;
    }

    public void setIndianResident(boolean indianResident) {
        this.indianResident = indianResident;
        this.validate();
    }

    public RelationshipType getResidentType() {
        return this.residentType;
    }

    public void setResidentType(RelationshipType residentType) {
        this.residentType = residentType;
        this.validate();
    }

    public String getRelationTypeError() {
        return this.relationTypeError;
    }

    public boolean isNriResident() {
        return this.nriResident;
    }

    public void setNriResident(boolean nriResident) {
        this.nriResident = nriResident;
        this.validate();
    }

    public boolean isForeignResident() {
        return this.foreignResident;
    }

    public void setForeignResident(boolean foreignResident) {
        this.foreignResident = foreignResident;
        this.validate();
    }

    public boolean isDemoUpdate() {
        return this.isDemoUpdate;
    }

    public void setDemoUpdate(boolean demoUpdate) {
        this.isDemoUpdate = demoUpdate;
    }

    public boolean isBioUpdate() {
        return this.isBioUpdate;
    }

    public void setBioUpdate(boolean bioUpdate) {
        this.isBioUpdate = bioUpdate;
    }

    public void setIsWhitelist(boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
    }

    public boolean getIsWhitelist() {
        return this.isWhitelist;
    }

    public String getLinkedEid() {
        return this.linkedEid;
    }

    public void setLinkedEid(String linkedEid) {
        this.linkedEid = linkedEid;
    }

    public boolean isDocumentBased() {
        return this.documentBased;
    }

    public void setDocumentBased(boolean documentBased) {
        this.documentBased = documentBased;
        this.validate();
    }

    public boolean isHofBased() {
        return this.hofBased;
    }

    public void setHofBased(boolean hofBased) {
        this.hofBased = hofBased;
        this.validate();
    }

    public boolean isPobPresent() {
        return this.isPobPresent;
    }

    public void setPobPresent(boolean pobPresent) {
        this.isPobPresent = pobPresent;
        this.validate();
    }

    public boolean isIndianAddress() {
        return this.indianAddress;
    }

    public void setIndianAddress(boolean indianAddress) {
        this.indianAddress = indianAddress;
        this.validate();
    }

    public boolean isForeignAddress() {
        return this.foreignAddress;
    }

    public void setForeignAddress(boolean foreignAddress) {
        this.foreignAddress = foreignAddress;
        this.validate();
    }

    public String getIsd() {
        return this.isd;
    }

    public void setIsd(String isd) {
        this.isd = isd;
        this.validate();
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
        this.validate();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        this.validate();
    }

    public String getHofUid() {
        return this.hofUid;
    }

    public void setHofUid(String hofUid) {
        this.hofUid = hofUid;
        this.validate();
    }

    public String getIsdError() {
        return this.isdError;
    }

    public String getMobileError() {
        return this.mobileError;
    }

    public String getEmailError() {
        return this.emailError;
    }

    public String getHofUidError() {
        return this.hofUidError;
    }

    public String getGrievanceId() {
        return this.grievanceId;
    }

    public void setGrievanceId(String grievanceId) {
        this.grievanceId = grievanceId;
    }
}

