/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import com.google.common.base.Strings;
import in.gov.uidai.ec.icas.util.Verhoeff;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.enrollment.model.ResidentInfo;
import org.apache.commons.lang.StringUtils;

public class ResidentUpdateInfo
extends EnrolmentModelBase<ResidentInfo> {
    private String uid = "";
    private String hofUid = "";
    private boolean isWhitelist;
    private String linkedEid = "";
    private String uidError;
    private String hofUidError;
    private String linkedEidError;
    private String grievanceId = "";
    private RelationshipType relationshipType;
    private boolean isBioException;

    public void validateDetails() {
        this.validateUid();
        this.validateHOF();
    }

    public void validateUid() {
        MsgKeysILV aadhaarErrorMsgKey = null;
        if (StringUtils.isBlank((String)this.getUid())) {
            aadhaarErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.getUid().startsWith("0") || this.uid.startsWith("1")) {
            aadhaarErrorMsgKey = MsgKeysILV.ZERO;
        } else if (!Verhoeff.validate((String)this.getUid())) {
            aadhaarErrorMsgKey = MsgKeysILV.UID;
        }
        this.setUidError(this.getMessage((Object)aadhaarErrorMsgKey, new Object[0]));
    }

    public void validateHOF() {
        boolean hofBased = this.relationshipType != null && !Strings.isNullOrEmpty((String)this.relationshipType.toMnemonic());
        MsgKeysILV aadhaarErrorMsgKey = null;
        if (hofBased) {
            if (StringUtils.isBlank((String)this.hofUid)) {
                aadhaarErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.hofUid.startsWith("0") || this.hofUid.startsWith("1")) {
                aadhaarErrorMsgKey = MsgKeysILV.ZERO;
            } else if (!Verhoeff.validate((String)this.hofUid)) {
                aadhaarErrorMsgKey = MsgKeysILV.UID;
            }
        }
        this.hofUidError = this.getMessage((Object)aadhaarErrorMsgKey, new Object[0]);
    }

    public ResidentUpdateInfo(EnrollmentService enrollmentService) {
        super(enrollmentService);
    }

    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    public void setWhitelist(boolean whitelist) {
        this.isWhitelist = whitelist;
    }

    public String getLinkedEid() {
        return this.linkedEid;
    }

    public void setLinkedEid(String linkedEid) {
        this.linkedEid = linkedEid;
    }

    public String getGrievanceId() {
        return this.grievanceId;
    }

    public void setGrievanceId(String grievanceId) {
        this.grievanceId = grievanceId;
    }

    public String getHofUid() {
        return this.hofUid;
    }

    public void setHofUid(String hofUid) {
        this.hofUid = hofUid;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUidError() {
        return this.uidError;
    }

    public void setUidError(String uidError) {
        this.uidError = uidError;
    }

    public String getHofUidError() {
        return this.hofUidError;
    }

    public void setHofUidError(String hofUidError) {
        this.hofUidError = hofUidError;
    }

    public String getLinkedEidError() {
        return this.linkedEidError;
    }

    public void setLinkedEidError(String linkedEidError) {
        this.linkedEidError = linkedEidError;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
    }

    public void setBiometricException(boolean isBioException) {
        this.isBioException = isBioException;
    }

    public boolean getIsBiometricException() {
        return this.isBioException;
    }
}

