/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Country;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.model.NationalityTypes;
import in.gov.uidai.ec.service.findaadhaar.model.BitIdentifierSelection;

public class ResidentialStatus
extends EnrolmentModelBase<ResidentialStatus> {
    private boolean isNRI;
    private Country country = new Country("Select", "");
    private String countryError;
    private NationalityTypes foreignType = new NationalityTypes("", "Select");
    private String foreignTypeError;

    ResidentialStatus(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.validate();
    }

    public boolean isNRI() {
        return this.isNRI;
    }

    public void setNRI(boolean isNRI) {
        super.setUpdatedBit(isNRI, BitIdentifierSelection.NRIBIT.getBitIndentifier());
        if (isNRI == this.isNRI) {
            return;
        }
        this.isNRI = isNRI;
        this.fireChangeEvent(this);
    }

    public String isNriResidentAsString() {
        return this.isNRI ? "true" : "false";
    }

    public void setCountry(Country country) {
        this.country = country;
        this.validate();
        this.fireChangeEvent(this);
    }

    public NationalityTypes getForeignType() {
        return this.foreignType;
    }

    public String getForeignTypeEnum() {
        return this.foreignType.getCode().isEmpty() ? "INDIAN" : this.foreignType.getCode();
    }

    public void setForeignType(NationalityTypes foreignType) {
        this.foreignType = foreignType;
        this.validate();
        this.fireChangeEvent(this);
    }

    public Country getCountry() {
        return this.country;
    }

    private void validate() {
        this.validateNationality();
        this.validateForeignType();
        this.setValid(this.countryError == null && this.foreignTypeError == null);
    }

    private void validateNationality() {
        if (this.enrollmentService.isForeignResident()) {
            MsgKeysILV nationalityErrorMsgKey = null;
            if (this.country.toString().contains("Select") || this.country.toString().isEmpty()) {
                nationalityErrorMsgKey = MsgKeysILV.MANDATORY;
            }
            this.countryError = this.getMessage((Object)nationalityErrorMsgKey, new Object[0]);
        }
    }

    private void validateForeignType() {
        if (this.enrollmentService.isForeignResident()) {
            MsgKeysILV foreignErrorMsgKey = null;
            if (this.foreignType.getName().equalsIgnoreCase("Select") || this.foreignType.getName().isEmpty()) {
                foreignErrorMsgKey = MsgKeysILV.MANDATORY;
            }
            this.foreignTypeError = this.getMessage((Object)foreignErrorMsgKey, new Object[0]);
        }
    }

    public String getNationalityError() {
        return this.countryError;
    }

    public String getForeignTypeError() {
        return this.foreignTypeError;
    }
}

