/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model.document;

import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.document.MsgKeysDocuments;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachedDoc
extends EnrolmentModelBase<AttachedDoc> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachedDoc.class);
    private static final long FILE_SIZE_LIMIT = 300L;
    private static final String[] FILE_TYPES = new String[]{"pdf"};
    private File file;
    private DocumentType documentType;
    private String error;

    public AttachedDoc(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.validate();
    }

    public File getFile() {
        return this.file;
    }

    public void setDocument(DocumentType documentType, File file) {
        this.documentType = documentType;
        this.file = file;
        this.validate();
        this.fireChangeEvent(this);
    }

    public void clear() {
        this.file = null;
        this.documentType = null;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getError() {
        this.validate();
        return this.error;
    }

    private void validate() {
        MsgKeysDocuments errorMsgKey = null;
        Object[] arguments = new Object[3];
        try {
            if (this.file == null) {
                errorMsgKey = MsgKeysDocuments.ATTACH_ERROR;
            } else if (!this.file.exists()) {
                errorMsgKey = MsgKeysDocuments.FILE_NOT_EXIST;
            } else if (FileUtils.readFileToString((File)this.file).trim().isEmpty()) {
                errorMsgKey = MsgKeysDocuments.FILE_SIZE_LOWER;
                arguments[0] = 0;
            } else if (this.file.length() / 1024L > 300L) {
                errorMsgKey = MsgKeysDocuments.FILE_SIZE_EXCEED;
                arguments[0] = 300L;
            } else if (!this.isFileSupported(this.file)) {
                errorMsgKey = MsgKeysDocuments.FILE_SIZE_EXCEED;
            } else if (!StringUtils.equalsIgnoreCase((String)this.getFileNamePattern(this.documentType), (String)FilenameUtils.getBaseName((String)this.file.getName()))) {
                errorMsgKey = MsgKeysDocuments.NAME_PATTERN_MISMATCH;
                arguments[0] = this.documentType.toString();
                arguments[1] = this.getFileNamePattern(this.documentType);
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            errorMsgKey = MsgKeysDocuments.ATTACH_ERROR;
        }
        this.error = this.getMessage((Object)errorMsgKey, arguments);
        this.setValid(this.error == null);
    }

    private boolean isFileSupported(File file) throws IOException {
        Tika tika = new Tika();
        String supportedMimeTypes = "application/pdf";
        String fileMimeType = tika.detect(file);
        String fileContentMimeType = tika.detect(Files.readAllBytes(file.toPath()));
        if (StringUtils.isBlank((String)fileMimeType)) {
            return false;
        }
        return Arrays.stream(FILE_TYPES).anyMatch(type -> type.equalsIgnoreCase(FilenameUtils.getExtension((String)file.getName()))) && supportedMimeTypes.equalsIgnoreCase(fileMimeType) && supportedMimeTypes.equalsIgnoreCase(fileContentMimeType);
    }

    private String getFileNamePattern(DocumentType docType) {
        String documentType = docType.toString().toLowerCase();
        String residentName = this.enrollmentService.getDemoPersonalDetails().getName().english();
        String ageOrYOB = this.getAgeOrYOB();
        ageOrYOB = StringUtils.isBlank((String)ageOrYOB) ? "" : ageOrYOB + "_";
        return residentName + "_" + ageOrYOB + documentType;
    }

    private String getAgeOrYOB() {
        String value = "";
        AgeDob ageDob = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob();
        if (ageDob.isMandatory()) {
            value = ageDob.isDobSelected() ? ageDob.getYear().toString() : ageDob.getAge().toString();
        }
        return value;
    }

    public BufferedImage getBufferedImage() throws IOException {
        PDDocument document = PDDocument.load((File)this.file);
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        BufferedImage bim = null;
        for (int page = 0; page < document.getNumberOfPages(); ++page) {
            bim = pdfRenderer.renderImageWithDPI(page, 300.0f, ImageType.RGB);
        }
        document.close();
        return bim;
    }

    public List<BufferedImage> getListBufferedImage() throws IOException {
        PDDocument document = PDDocument.load((File)this.file);
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        ArrayList<BufferedImage> bim = new ArrayList<BufferedImage>();
        for (int page = 0; page < document.getNumberOfPages(); ++page) {
            bim.add(pdfRenderer.renderImageWithDPI(page, 100.0f, ImageType.RGB));
        }
        document.close();
        return bim;
    }
}

