/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model.document;

import com.google.common.base.Strings;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfWriter;
import in.gov.uidai.ec.service.document.Annotation;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.model.document.AttachedDoc;
import in.gov.uidai.ec.service.enrollment.model.document.ResidentDocument;
import in.gov.uidai.ec.service.enrollment.model.document.ScannedDoc;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentsManager
extends EnrolmentModelBase<DocumentsManager> {
    public static final String PDF_FILE_EXTENSION = "pdf";
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentsManager.class);
    private final Map<DocumentType, ResidentDocument> residentDocuments;
    private final Map<DocumentType, String> error;
    private DocumentType currentOperatingDocType;
    private Map<DocumentType, List<Annotation>> docAnnotations;
    private Map<String, List<String>> dvsResultMap;
    private boolean isDocValidationOverride;
    private boolean isDvsSuccess;
    private DocumentType previewDocType;
    private Runnable documentUploadSuccessDigilocker;
    private String previewType;
    private ActionListener previewSaveButtonListener;
    private final String UPLOAD_DOCUMENT = "label-stat:Action.upload";
    private DocumentType currentOperatingDocTypeForVerification;
    List<String> broadCastMessages = new ArrayList<String>();

    public List<String> getBroadCastMessages() {
        return this.broadCastMessages;
    }

    public DocumentsManager(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.residentDocuments = new HashMap<DocumentType, ResidentDocument>();
        this.error = new HashMap<DocumentType, String>();
        this.docAnnotations = new HashMap<DocumentType, List<Annotation>>();
        this.dvsResultMap = new HashMap<String, List<String>>();
    }

    public void addNextDocument(BufferedImage bufferedImage, String scanMode) {
        this.residentDocuments.putIfAbsent(this.currentOperatingDocType, new ResidentDocument(this.enrollmentService));
        this.residentDocuments.get((Object)this.currentOperatingDocType).getScannedDoc().addNextDocument(bufferedImage, scanMode);
    }

    public byte[] getDocumentBytes(DocumentType docType) {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)docType);
        return residentDocument != null && residentDocument.getBytes() != null && residentDocument.getAttachedDoc() != null && (residentDocument.getAttachedDoc().getFile() != null || residentDocument.getScannedDoc().getTotalScannedPages() != 0) ? residentDocument.getBytes() : null;
    }

    public void copyFrom(DocumentType srcDocType) {
        this.residentDocuments.put(this.currentOperatingDocType, this.residentDocuments.get((Object)srcDocType));
        this.validate(this.currentOperatingDocType);
    }

    public void copyFromUC(DocumentType srcDocType) {
        ResidentDocument newDocument = new ResidentDocument(this.enrollmentService);
        newDocument.setBytes(this.residentDocuments.get((Object)srcDocType).getBytes());
        newDocument.setScannedDoc(this.residentDocuments.get((Object)srcDocType).getScannedDoc());
        newDocument.setDocCompressAndSaved(this.residentDocuments.get((Object)srcDocType).isDocCompressAndSaved());
        this.residentDocuments.put(this.currentOperatingDocType, newDocument);
        this.validate(this.currentOperatingDocType);
    }

    public boolean isDocumentSaved(DocumentType documentType) {
        return this.getDocumentBytes(documentType) != null;
    }

    public void setDocumentBytes(File file) throws IOException {
        this.residentDocuments.putIfAbsent(this.currentOperatingDocType, new ResidentDocument(this.enrollmentService));
        this.residentDocuments.get((Object)this.currentOperatingDocType).setBytes(FileUtils.readFileToByteArray((File)file));
        this.residentDocuments.get((Object)this.currentOperatingDocType).getAttachedDoc().setDocument(this.currentOperatingDocType, file);
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            this.validate(this.currentOperatingDocType);
            this.fireChangeEvent(this);
        }
    }

    public Set<DocumentType> getDocumentTypes() {
        return this.residentDocuments.keySet();
    }

    public void deleteFilesFromDisk() {
        this.residentDocuments.forEach((key, value) -> FileUtils.deleteQuietly((File)value.getAttachedDoc().getFile()));
    }

    public void resetDocument() {
        this.residentDocuments.remove((Object)this.currentOperatingDocType);
        this.validate(this.currentOperatingDocType);
        this.fireChangeEvent(this);
    }

    public void resetDocument(DocumentType documentType) {
        this.residentDocuments.remove((Object)documentType);
        this.validate(documentType);
        this.fireChangeEvent(this);
    }

    public void resetDocumentPages() {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)this.currentOperatingDocType);
        if (residentDocument != null) {
            residentDocument.setAnnotations(null);
        }
    }

    public Map<String, List<String>> getDvsResultMap() {
        return this.dvsResultMap;
    }

    public List<Annotation> getAnnotations(DocumentType documentType) {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)documentType);
        return residentDocument != null ? residentDocument.getAnnotations() : Collections.emptyList();
    }

    public void setAnnotations(List<Annotation> annotations) {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)this.currentOperatingDocType);
        if (residentDocument != null) {
            residentDocument.setAnnotations(annotations);
        }
    }

    public void setAnnotations(DocumentType documentType, List<Annotation> annotations) {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)documentType);
        if (residentDocument != null) {
            residentDocument.setAnnotations(annotations);
        }
    }

    public void clearAnnotations() {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)this.currentOperatingDocType);
        if (residentDocument != null && residentDocument.getAnnotations() != null) {
            residentDocument.getAnnotations().clear();
        }
    }

    public void updateDvsResultMap(String key, List<String> mismatchLabelList) {
        if (mismatchLabelList.isEmpty()) {
            this.dvsResultMap.remove(key);
            if (this.dvsResultMap.isEmpty()) {
                this.setDocValidationOverride(false);
            }
        } else {
            this.dvsResultMap.put(key, mismatchLabelList);
        }
    }

    public boolean isDvsSuccess() {
        return this.isDvsSuccess;
    }

    public void setDvsSuccess(boolean DvsSuccess) {
        this.isDvsSuccess = DvsSuccess;
    }

    public void reset() {
        this.deleteFilesFromDisk();
        this.residentDocuments.clear();
    }

    public void resetUC() {
        for (DocumentType type : this.residentDocuments.keySet()) {
            if (this.residentDocuments.get((Object)type).getAttachedDoc() != null) {
                this.residentDocuments.get((Object)type).getAttachedDoc().clear();
            }
            if (this.residentDocuments.get((Object)type).getScannedDoc() != null) {
                this.residentDocuments.get((Object)type).getScannedDoc().clear();
            }
            if (this.residentDocuments.get((Object)type).getBytes() == null) continue;
            this.residentDocuments.get((Object)type).clearBytes();
        }
        this.residentDocuments.clear();
        System.gc();
    }

    public AttachedDoc getAttachedDoc() {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)this.currentOperatingDocType);
        return residentDocument != null ? residentDocument.getAttachedDoc() : null;
    }

    public ScannedDoc getScannedDoc() {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)this.getCurrentDocumentTypeForUploadOrVerify());
        return residentDocument != null ? residentDocument.getScannedDoc() : null;
    }

    public ScannedDoc getScannedDoc(DocumentType documentType) {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)documentType);
        return residentDocument != null ? residentDocument.getScannedDoc() : null;
    }

    public void setDocumentUploadSuccess(DocumentType docType) {
        if (this.residentDocuments.containsKey((Object)docType)) {
            this.residentDocuments.get((Object)docType).setUploadSuccess(true);
            this.documentUploadSuccess();
            this.fireChangeEvent(this);
        }
    }

    public void setDocumentUploadSuccessFalse(DocumentType docType) {
        if (this.residentDocuments.containsKey((Object)docType)) {
            this.residentDocuments.get((Object)docType).setUploadSuccess(false);
        }
    }

    public void setDocumentUploadSuccessFalseForDigilocker(DocumentType docType) {
        if (this.residentDocuments.containsKey((Object)docType)) {
            this.residentDocuments.get((Object)docType).setUploadSuccess(false);
        }
    }

    public boolean isDocValidationOverride() {
        return this.isDocValidationOverride;
    }

    public boolean isDocumentUploaded(DocumentType docType) {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)docType);
        return residentDocument != null && residentDocument.isUploadSuccess();
    }

    public boolean isDocumentCompressAndSaved(DocumentType docType) {
        ResidentDocument residentDocument = this.residentDocuments.get((Object)docType);
        return residentDocument != null && residentDocument.isDocCompressAndSaved();
    }

    public void setDocumentCompressAndSaved(DocumentType docType) {
        this.residentDocuments.get((Object)docType).setDocCompressAndSaved(true);
    }

    public void setDocValidationOverride(boolean docValidationOverride) {
        this.isDocValidationOverride = docValidationOverride;
        this.fireChangeEvent(this);
    }

    public DocumentType getCurrentOperatingDocType() {
        return this.currentOperatingDocType;
    }

    public void setCurrentOperatingDocType(DocumentType currentOperatingDocType) {
        this.currentOperatingDocType = currentOperatingDocType;
        this.resetDocument();
    }

    public DocumentType getPreviewDocType() {
        return this.previewDocType;
    }

    public void setPreviewDocType(DocumentType previewDocType) {
        this.previewDocType = previewDocType;
    }

    public void addToDocAnnotations(DocumentType docType, List<Annotation> annotations) {
        this.docAnnotations.put(docType, annotations);
    }

    public List<Annotation> getDocAnnotations(DocumentType docType) {
        return this.docAnnotations.get((Object)docType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToJp2000() throws Exception {
        try {
            this.getScannedDoc().finishCompression();
            if (!this.getScannedDoc().getCompressionStatus()) {
                throw new Exception("Failed to compress the document");
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                for (int page = 0; page < this.getScannedDoc().getTotalScannedPages(); ++page) {
                    byte[] convertedDataBytes = this.getScannedDoc().getConvertedBytes(page);
                    baos.write(convertedDataBytes);
                }
                this.residentDocuments.putIfAbsent(this.currentOperatingDocType, new ResidentDocument(this.enrollmentService));
                this.residentDocuments.get((Object)this.currentOperatingDocType).setBytes(baos.toByteArray());
            }
            LOGGER.info("Document converted to JP2000 format");
        }
        finally {
            this.resetDocumentPages();
        }
    }

    public void validateDocs(DocumentType documentType) {
        this.validate(documentType);
        this.fireChangeEvent(this);
        this.resetDocumentPages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertToPdf() throws Exception {
        try {
            this.getScannedDoc().finishCompression();
            if (!this.getScannedDoc().getCompressionStatus()) {
                throw new Exception("Failed to compress the document");
            }
            Document document = new Document();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
                writer.open();
                document.open();
                for (int page = 0; page < this.getScannedDoc().getTotalScannedPages(); ++page) {
                    byte[] convertedDataBytes = this.getScannedDoc().getConvertedBytes(page);
                    LOGGER.debug("Converting to PDF, page no: " + page + 1);
                    document.newPage();
                    Image image = Image.getInstance((byte[])convertedDataBytes);
                    image.setAbsolutePosition(0.0f, 0.0f);
                    image.setBorderWidth(0.0f);
                    image.scaleAbsoluteHeight(PageSize.A4.getHeight());
                    image.scaleAbsoluteWidth(PageSize.A4.getWidth());
                    document.add((Element)image);
                }
                document.close();
                writer.close();
                this.residentDocuments.putIfAbsent(this.currentOperatingDocType, new ResidentDocument(this.enrollmentService));
                this.residentDocuments.get((Object)this.currentOperatingDocType).setBytes(baos.toByteArray());
            }
            this.validate(this.currentOperatingDocType);
            this.fireChangeEvent(this);
            LOGGER.debug("Document converted to PDF");
        }
        finally {
            this.resetDocumentPages();
        }
    }

    public String getError(DocumentType documentType) {
        this.validate(documentType);
        return this.error.get((Object)documentType);
    }

    private void validate(DocumentType documentType) {
        this.error.put(documentType, this.getDocumentBytes(documentType) != null ? null : this.getMessage((Object)MsgKeysILV.DOC_ATTACH_MANDATORY, new Object[0]));
        this.setValid(this.getDocumentBytes(documentType) != null);
    }

    public void setDocumentUploadSuccessDigilocker(Runnable documentUploadSuccessDigilocker) {
        this.documentUploadSuccessDigilocker = documentUploadSuccessDigilocker;
    }

    private void documentUploadSuccess() {
        this.documentUploadSuccessDigilocker.run();
    }

    public String getPreviewType() {
        return this.previewType;
    }

    public void setPreviewType(String previewType) {
        this.previewType = previewType;
    }

    public ActionListener getPreviewSaveButtonListener() {
        return this.previewSaveButtonListener;
    }

    public void setPreviewSaveButtonListener(ActionListener previewSaveButtonListener) {
        this.previewSaveButtonListener = previewSaveButtonListener;
    }

    public void setcurrentOperatingDocTypeForVerification(DocumentType currentOperatingDocTypeForVerification) {
        this.currentOperatingDocTypeForVerification = currentOperatingDocTypeForVerification;
    }

    public DocumentType getCurrentDocumentTypeForUploadOrVerify() {
        String previewType = this.getPreviewType();
        if (Strings.isNullOrEmpty((String)previewType) || "label-stat:Action.upload".equals(previewType)) {
            return this.currentOperatingDocType;
        }
        return this.currentOperatingDocTypeForVerification;
    }
}

