/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model.document;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.document.ScannedPage;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannedDoc
extends EnrolmentModelBase<ScannedDoc> {
    public static final String PDF_FILE_EXTENSION = "pdf";
    private static final Logger LOGGER = LoggerFactory.getLogger(ScannedDoc.class);
    LinkedList<ScannedPage> pages = new LinkedList();
    private String error;

    public ScannedDoc(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.validate();
    }

    public void finishCompression() throws InterruptedException {
        for (int i = 0; i < this.pages.size(); ++i) {
            long startTime = System.currentTimeMillis();
            this.pages.get(i).waitForCompressionToComplete();
            long endTime = System.currentTimeMillis();
            LOGGER.info("Time consumed to compress page: {} is {} ms", (Object)(i + 1), (Object)(endTime - startTime));
            LOGGER.debug("Compression completed for page : " + i + 1);
        }
    }

    public byte[] getConvertedBytes(int index) {
        return this.pages.get(index).getJpeg2000DocumentData();
    }

    public int getTotalScannedPages() {
        LinkedList<ScannedPage> residentDocument = this.pages;
        if (residentDocument == null) {
            return 0;
        }
        return residentDocument.size();
    }

    public ScannedPage getLastScannedPage() {
        LinkedList<ScannedPage> residentDocument = this.pages;
        if (residentDocument == null) {
            return null;
        }
        return residentDocument.getLast();
    }

    public void addNextDocument(BufferedImage bufferedImage, String scanMode) {
        this.pages.add(new ScannedPage(bufferedImage, scanMode));
    }

    public boolean getCompressionStatus() {
        boolean allCompressed = true;
        for (ScannedPage documentPage : this.pages) {
            if (!documentPage.isCompressed()) {
                documentPage.compressJPEG2000();
            }
            allCompressed = allCompressed && documentPage.isCompressed();
        }
        return allCompressed;
    }

    public String getError() {
        return this.error;
    }

    private void validate() {
        String errorMsgKey = null;
        Object[] arguments = new Object[3];
        if (this.pages.stream().anyMatch(scannedPage -> scannedPage.getOriginalScannedDocument() == null)) {
            errorMsgKey = "Failed to compress the document";
        }
        this.error = this.getMessage(errorMsgKey, arguments);
        this.setValid(this.error == null);
    }

    public LinkedList<ScannedPage> getPages() {
        return this.pages;
    }

    public void clear() {
        this.pages.forEach(ScannedPage::clear);
        this.pages.clear();
        System.gc();
    }
}

