/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model.document;

import com.github.jaiimageio.jpeg2000.J2KImageWriteParam;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannedPage
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScannedPage.class);
    private static final int COMPRESSION_RATIO = 25;
    private static final long waitingTime = 180000L;
    private final String scanMode;
    private byte[] jpeg2000DocumentData;
    private BufferedImage originalScannedDocument;
    private double rotateAngle = 0.0;
    private boolean isCompressed;
    private Thread thread;

    public ScannedPage(BufferedImage scannedDocument, String scanMode) {
        this.originalScannedDocument = scannedDocument;
        this.scanMode = scanMode;
        this.isCompressed = false;
        LOGGER.info("Scanned page size : " + scannedDocument.getData().getDataBuffer().getSize() / 1024 + " KB");
    }

    @Override
    public void run() {
        LOGGER.debug("Compressing the scanned document");
        this.compressJPEG2000();
    }

    public synchronized void compressJPEG2000() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            double encodingRate = this.calculateEncodingRate(this.originalScannedDocument);
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("JPEG2000").next();
            J2KImageWriteParam imageWriteParam = (J2KImageWriteParam)imageWriter.getDefaultWriteParam();
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionType("JPEG2000");
            imageWriteParam.setEncodingRate(encodingRate);
            imageWriteParam.setWriteCodeStreamOnly(true);
            imageWriteParam.setLossless(false);
            imageWriteParam.setFilter("w5x3");
            try (ImageOutputStream outputStream = ImageIO.createImageOutputStream(baos);){
                imageWriter.setOutput(outputStream);
                IIOImage outputImage = new IIOImage(this.originalScannedDocument, null, null);
                imageWriter.write(null, outputImage, (ImageWriteParam)imageWriteParam);
                outputStream.flush();
                imageWriter.dispose();
            }
            this.jpeg2000DocumentData = baos.toByteArray();
            LOGGER.info("Compressed document size : " + this.jpeg2000DocumentData.length / 1024 + " KB");
        }
        catch (IOException e) {
            LOGGER.error("Error while compressing the document", (Throwable)e);
        }
        this.isCompressed = true;
    }

    private double calculateEncodingRate(BufferedImage bi) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            long imageSize;
            try (ImageOutputStream outputStream = ImageIO.createImageOutputStream(baos);){
                ImageIO.write((RenderedImage)bi, "png", outputStream);
            }
            int grayScaleAdjustment = 1;
            if (!this.scanMode.equalsIgnoreCase("COLOR")) {
                grayScaleAdjustment = 2;
            }
            if ((imageSize = (long)(baos.toByteArray().length / 1024 * grayScaleAdjustment)) > 7500L) {
                imageSize = 7500L;
            }
            int bitsPerPixel = bi.getColorModel().getPixelSize();
            double encodingRate = (double)(imageSize * (long)bitsPerPixel * 1024L) / (double)(25 * bi.getData().getDataBuffer().getSize());
            DecimalFormat df = new DecimalFormat("#.####");
            double d = Double.parseDouble(df.format(encodingRate));
            return d;
        }
    }

    public void waitForCompressionToComplete() throws InterruptedException {
        if (this.thread != null) {
            this.thread.join(180000L);
        }
    }

    public void finalizeDocument() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public byte[] getJpeg2000DocumentData() {
        return this.jpeg2000DocumentData;
    }

    public BufferedImage getOriginalScannedDocument() {
        return this.originalScannedDocument;
    }

    public void setOriginalScannedDocument(BufferedImage originalScannedDocument) {
        this.originalScannedDocument = originalScannedDocument;
        this.isCompressed = false;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public double getRotateAngle() {
        return this.rotateAngle;
    }

    public void addRotateAngle(double rotateAngle) {
        this.rotateAngle += rotateAngle;
        if (this.rotateAngle >= 360.0) {
            this.rotateAngle -= 360.0;
        } else if (this.rotateAngle <= -360.0) {
            this.rotateAngle += 360.0;
        }
    }

    public void resetRotateAngle() {
        this.rotateAngle = 0.0;
    }

    public void reset() {
        this.originalScannedDocument.flush();
        this.originalScannedDocument = null;
        this.rotateAngle = 0.0;
    }

    public void clear() {
        if (this.originalScannedDocument != null) {
            this.originalScannedDocument.flush();
            this.originalScannedDocument = null;
        }
        this.jpeg2000DocumentData = null;
        this.thread = null;
        System.gc();
    }
}

