/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.findaadhaar;

import in.gov.uidai.ec.service.findaadhaar.FindAadhaarAttempt;
import in.gov.uidai.ec.service.findaadhaar.IFindAadhaarDao;
import in.gov.uidai.ec.service.packet.PacketSummaryDAO;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindAadhaarDao
implements IFindAadhaarDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketSummaryDAO.class);
    private SqlSession session;

    public void setSqlSession(SqlSession session) {
        this.session = session;
    }

    @Override
    public void saveAttempt(FindAadhaarAttempt findAadhaarAttempt) {
        try {
            this.session.insert("insertFindAadhaarAttempt", (Object)findAadhaarAttempt);
        }
        catch (Exception e) {
            LOGGER.error("error inserting find aadhaar attempt", (Throwable)e);
        }
    }

    @Override
    public List<FindAadhaarAttempt> getAttempts(long fromTime, long toTime) {
        HashMap<String, Timestamp> paramMap = new HashMap<String, Timestamp>();
        paramMap.put("fromTime", new Timestamp(fromTime));
        paramMap.put("toTime", new Timestamp(toTime));
        try {
            return this.session.selectList("listFindAadhaarAttempts", paramMap);
        }
        catch (Exception e) {
            LOGGER.error("error getting find aadhaar attempts", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<Date, HashMap<String, Object>> getDateWiseAttemptSummary() {
        try {
            return this.session.selectMap("listDateWiseFindAadhaarAttempts", "date");
        }
        catch (Exception e) {
            LOGGER.error("error getting find aadhaar attempts date-wise summary", (Throwable)e);
            return null;
        }
    }

    @Override
    public void cleanupOldAttempts(Integer age) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(System.currentTimeMillis()));
        cal.add(5, -age.intValue());
        try {
            this.session.delete("cleanupOldAttempts", (Object)cal.getTime());
        }
        catch (Exception e) {
            LOGGER.error("error cleaning up find aadhaar attempts older than " + age + " days", (Throwable)e);
        }
    }
}

