/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.findaadhaar;

import com.lowagie.text.pdf.codec.Base64;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.ecmpapi.CommonUtils;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.api.ApiResponseMessage;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.AadhaarPdfInfo;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.AuditData;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.AuthRDData;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.Demo;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.FindAadhaarRequest;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.FindAadhaarRes;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.Gender;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.GpsDataType;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.IdDataType;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.IdType;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.Pa;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.Pi;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.SearchData;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.YesOrNo;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.PrintAadharInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.rd.device.xml.DeviceRdInfo;
import in.gov.uidai.ec.rd.device.xml.Param;
import in.gov.uidai.ec.rd.device.xml.additional_info;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.findaadhaar.EnvironmentProperty;
import in.gov.uidai.ec.service.findaadhaar.FindAadhaarAttempt;
import in.gov.uidai.ec.service.findaadhaar.FindAadhaarException;
import in.gov.uidai.ec.service.findaadhaar.FindAadhaarExceptionType;
import in.gov.uidai.ec.service.findaadhaar.IFindAadhaarDao;
import in.gov.uidai.ec.service.findaadhaar.IFindAadhaarRequestConstants;
import in.gov.uidai.ec.service.findaadhaar.model.AadhaarSearch;
import in.gov.uidai.ec.service.findaadhaar.model.DemographicsSearch;
import in.gov.uidai.ec.service.findaadhaar.model.IdentifierSearch;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.SessionService;
import in.gov.uidai.ec.utils.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindAadhaarService
implements IFindAadhaarRequestConstants {
    public static final String DEFAULT_ENROL_DATE = "00000000000000";
    private static final Logger LOGGER = LoggerFactory.getLogger(FindAadhaarService.class);
    private static final int MAX_ALLOWED_DAYS = 30;
    private IRegistrationService registrationService;
    private IFindAadhaarDao findAadhaarAttemptsDao;
    private BiometricsAuthService biometricsAuthService;
    private SessionService sessionService;
    private EcmpApiService ecmpApiService;
    private AadhaarSearch search;
    private IOucDataStore oucDataStore;

    public AadhaarSearch newSearch(IResourceBundleContext context) {
        this.search = new AadhaarSearch(context);
        return this.search;
    }

    public void setBiometricsAuthService(BiometricsAuthService biometricsAuthService) {
        this.biometricsAuthService = biometricsAuthService;
    }

    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void setOucDataStore(IOucDataStore dataStore) {
        this.oucDataStore = dataStore;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setFindAadhaarAttemptsDao(IFindAadhaarDao findAadhaarAttemptsDao) {
        this.findAadhaarAttemptsDao = findAadhaarAttemptsDao;
    }

    public FindAadhaarRes makeFindAadhaarRequest() throws FindAadhaarException {
        String message;
        block10: {
            try {
                FindAadhaarRequest findAadhaarRequest = this.createFindAadhaarRequest();
                ApiResponseMessage responseMessage = this.ecmpApiService.makeFindAadhaarRequest(findAadhaarRequest);
                if (responseMessage != null) {
                    if (responseMessage.getData() != null) {
                        String findAadhaarResponseStr = new String(responseMessage.getData(), StandardCharsets.UTF_8);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(findAadhaarResponseStr.getBytes(StandardCharsets.UTF_8));
                        FindAadhaarRes findAadhaarResponse = (FindAadhaarRes)CommonUtils.unMarshal((InputStream)inputStream, FindAadhaarRes.class);
                        if (!findAadhaarResponse.getErrorStatus().value().equals("NO_ERROR")) {
                            String error = findAadhaarResponse.getErrorMessage();
                            if (error != null) {
                                LOGGER.info("FindAadhaar response message: " + error);
                                message = error;
                                break block10;
                            }
                            throw new FindAadhaarException(FindAadhaarExceptionType.ServerError);
                        }
                        return findAadhaarResponse;
                    }
                    if (responseMessage.getErrorMessage().equalsIgnoreCase("Printing Aadhaar by requester on behalf of resident has been restricted.")) {
                        message = responseMessage.getErrorMessage();
                        break block10;
                    }
                    throw new FindAadhaarException(FindAadhaarExceptionType.InternalServerError, responseMessage.getErrorMessage());
                }
                throw new FindAadhaarException(FindAadhaarExceptionType.NetworkError, "Response message is null");
            }
            catch (FindAadhaarException e) {
                throw e;
            }
            catch (IOException e) {
                throw new FindAadhaarException(FindAadhaarExceptionType.EnrolServiceClientConnectionError, e);
            }
            catch (StationInfoStoreException e) {
                throw new FindAadhaarException(FindAadhaarExceptionType.EnrolServiceClientError, (Exception)((Object)e));
            }
            catch (Exception e) {
                throw new FindAadhaarException(FindAadhaarExceptionType.InternalError, e);
            }
        }
        throw new FindAadhaarException(FindAadhaarExceptionType.Other, message);
    }

    private FindAadhaarRequest createFindAadhaarRequest() throws IOException, StationInfoStoreException {
        Demo demo = new Demo();
        SearchData searchData = new SearchData();
        IdDataType idDataType = new IdDataType();
        AuthRDData residentRdData = new AuthRDData();
        if (this.search.getSearchType().isIdentifier()) {
            IdentifierSearch identifier = this.search.getIdentifierSearch();
            String enrollmentDate = identifier.getEnrolmentDate().getValue();
            if (identifier.getSelection().isUid()) {
                idDataType.setIdType(IdType.UID);
                idDataType.setId(identifier.getUid().getValue());
                residentRdData.setUid(this.getFormattedUid(identifier));
            } else {
                String formattedEnrollmentDate = ECMPDateFormatHelper.getReformattedDate(ECMPDateFormats.FULL_DATE_FORMAT1, ECMPDateFormats.FULL_DATE_FORMAT, enrollmentDate);
                if (this.isValidENO(formattedEnrollmentDate)) {
                    idDataType.setIdType(IdType.ENO);
                } else {
                    idDataType.setIdType(IdType.EID);
                }
                idDataType.setId(this.getId(identifier.getEnrolId().getValue(), formattedEnrollmentDate));
            }
            searchData.setIdData(idDataType);
        } else {
            Pi pi = new Pi();
            DemographicsSearch demographics = this.search.getDemographicsSearch();
            pi.setName(StringUtils.upperCase((String)demographics.getName().getValue()));
            pi.setEmail(demographics.getEmail().getValue());
            pi.setPhone(demographics.getMobile().getValue());
            pi.setDobt(demographics.getYobType().getValue().substring(0, 1));
            pi.setDob(demographics.getYob().getValue());
            pi.setGender(Gender.valueOf((String)demographics.getGender().getValue().substring(0, 1)));
            demo.setPi(pi);
            Pa pa = new Pa();
            pa.setCo(demographics.getCareOf().getValue());
            pa.setPc(demographics.getPinCode().getValue());
            pa.setDist(demographics.getDistrict().getValue());
            pa.setState(demographics.getState().getValue());
            demo.setPa(pa);
            searchData.setDemoData(demo);
        }
        residentRdData.setContent(this.biometricsAuthService.getRdAuthBiometrics().getCapRdPid(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS).getBytes());
        AuthRDData operatorRDData = new AuthRDData();
        operatorRDData.setUid(this.sessionService.getOperatorCredentials().getUid());
        operatorRDData.setContent(this.biometricsAuthService.getRdAuthBiometrics().getCapRdPid(AuthParamType.OPERATOR, DeviceType.FINGER_OR_IRIS).getBytes());
        FindAadhaarRequest findAadhaar = new FindAadhaarRequest();
        findAadhaar.setVer("2.5");
        findAadhaar.setTid("registered");
        findAadhaar.setLk("cc258a8c9810484d98b1070d90b8353e");
        findAadhaar.setRetry(YesOrNo.N);
        findAadhaar.setTxn(this.getTxnId());
        findAadhaar.setTs(DateUtils.getXMLTimeStamp().toString().substring(0, 19));
        findAadhaar.setAuditData(this.getAuditData());
        findAadhaar.setOad(operatorRDData);
        findAadhaar.setRad(residentRdData);
        findAadhaar.setSearchData(searchData);
        findAadhaar.setMode("PDF");
        return findAadhaar;
    }

    private String getFormattedUid(IdentifierSearch identifier) {
        String plainUid = identifier.getUid().getValue();
        if (StringUtils.isNotBlank((String)plainUid) && plainUid.length() == 12) {
            return plainUid.substring(0, 4) + "-" + plainUid.substring(4, 8) + "-" + plainUid.substring(8, 12);
        }
        return null;
    }

    private AuditData getAuditData() throws IOException, StationInfoStoreException {
        AuditData auditData = new AuditData();
        GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
        auditData.setRegistrarCode(this.registrationService.getRegistrarId());
        auditData.setRegistrarName(this.registrationService.getRegistrarName());
        auditData.setAgencyCode(this.registrationService.getAgencyId());
        auditData.setAgencyName(this.registrationService.getAgencyName());
        auditData.setClientId(this.registrationService.getRegisteredMachineCode());
        auditData.setClientMachineId(this.registrationService.getRegisteredMachineCode());
        auditData.setClientVersion(ApplicationVersion.VERSION);
        auditData.setOperatorId(this.sessionService.getOperatorCredentials().getOperatorId());
        auditData.setOperatorUid(this.sessionService.getOperatorCredentials().getUid());
        auditData.setClientType("UCL");
        auditData.setTimestamp(DateUtils.getXMLTimeStamp().toString().substring(0, 19));
        auditData.setLocation(this.registrationService.getClientLocation().equalsIgnoreCase("") ? "0000" : this.registrationService.getClientLocation());
        auditData.setClientPlatform(System.getProperty("os.name") + " " + System.getProperty("os.arch"));
        DeviceRdInfo devRdInfo = this.biometricsAuthService.getRdAuthBiometrics().getCapturedAttempt(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS).getDevRdInfo();
        auditData.setDeviceModel(devRdInfo.getMi());
        List deviceInfo = devRdInfo.getAdditional_info();
        auditData.setDeviceSerialNumber(deviceInfo != null ? ((Param)((additional_info)deviceInfo.get(0)).getParam().get(0)).getValue() : "UCL12345");
        auditData.setStationCode(this.registrationService.getStationId());
        GpsDataType gpsDataType = new GpsDataType();
        gpsDataType.setAltitude(String.valueOf(gpsInfo.getAltitude()));
        gpsDataType.setLatitude(String.valueOf(gpsInfo.getLatitude()));
        gpsDataType.setLongitude(String.valueOf(gpsInfo.getLongitude()));
        auditData.setGpsCordinates(gpsDataType);
        return auditData;
    }

    private String getTxnId() throws IOException, StationInfoStoreException {
        String agencyId = this.registrationService.getAgencyId();
        String stationId = this.registrationService.getStationId();
        String eAadhaarSeq = this.getNextEaadhaarSequence();
        this.registrationService.setEaadhaarSequenceNumber(eAadhaarSeq);
        String txnId = "UPR:" + agencyId + stationId + eAadhaarSeq;
        return txnId;
    }

    public String getNextEaadhaarSequence() throws IOException, StationInfoStoreException {
        String sequenceNumber = this.getPrintAadharSequenceNumber();
        DecimalFormat df = new DecimalFormat("00000");
        String eAadhaarSeqNum = df.format(Integer.parseInt(sequenceNumber) + 1);
        this.storePrintAadharSequenceNumber(eAadhaarSeqNum);
        return eAadhaarSeqNum;
    }

    private String getPrintAadharSequenceNumber() throws IOException, StationInfoStoreException {
        PrintAadharInfo printAadharInfo = this.oucDataStore.getPrintAadharInfo();
        if (printAadharInfo.isEmpty()) {
            throw new StationInfoStoreException("PrintAadhar information not available with Enrol Service Client. Please make sure the printaadhar_sequence.json file is present.");
        }
        return printAadharInfo.getSequenceNumber();
    }

    private void storePrintAadharSequenceNumber(String sequenceNumber) throws IOException, StationInfoStoreException {
        PrintAadharInfo printAadharInfo = new PrintAadharInfo();
        printAadharInfo.setSequenceNumber(sequenceNumber);
        this.oucDataStore.setPrintAadharInfo(printAadharInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storePdf(FindAadhaarRes findAadhaarResponse) {
        AadhaarPdfInfo aadhaarPdfInfo = findAadhaarResponse.getPrintPdfData();
        String fileName = EnvironmentProperty.getWorkingDirectory() + File.separator + "EAadhaar.pdf";
        byte[] inputBytes = Base64.decode((String)aadhaarPdfInfo.getPdfString());
        FileOutputStream outputStream = null;
        try {
            File aadhaarPdfFile = new File(fileName);
            outputStream = new FileOutputStream(aadhaarPdfFile);
            outputStream.write(inputBytes);
            outputStream.flush();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Error while finding the file", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Error while writing to the file", (Throwable)e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while closing the buffer", (Throwable)e);
            }
        }
        return false;
    }

    public void storeAttemptInfo() {
        String uid = "";
        String eid = "";
        String eno = "";
        if (this.search.getSearchType().isIdentifier()) {
            String enrolId = this.search.getIdentifierSearch().getEnrolId().getValue();
            String enrollmentDate = this.search.getIdentifierSearch().getEnrolmentDate().getValue();
            if (this.search.getIdentifierSearch().getSelection().isUid()) {
                uid = this.search.getIdentifierSearch().getUid().getValue().substring(8);
            } else if (this.isValidENO(enrollmentDate)) {
                eno = this.getId(enrolId, enrollmentDate);
            } else {
                eid = this.getId(enrolId, enrollmentDate);
            }
        }
        String operatorId = this.sessionService.getOperatorCredentials().getOperatorId();
        FindAadhaarAttempt attempt = new FindAadhaarAttempt(eid, eno, uid, operatorId, this.search.getDemographicsSearch().getName().getValue());
        this.findAadhaarAttemptsDao.saveAttempt(attempt);
    }

    public void cleanOldData() {
        this.findAadhaarAttemptsDao.cleanupOldAttempts(30);
    }

    public void cleanGeneratedFile() {
        String encryptedPdfFileAbsolutePath = EnvironmentProperty.getWorkingDirectory() + File.separator + "EAadhaar.pdf";
        File pdfFile = new File(encryptedPdfFileAbsolutePath);
        if (pdfFile.exists() && !pdfFile.delete()) {
            LOGGER.error("Could not delete PDF file.");
        }
    }

    private boolean isValidENO(String enrollmentDate) {
        return StringUtils.isBlank((String)enrollmentDate) || enrollmentDate.equals(DEFAULT_ENROL_DATE);
    }

    private String getId(String eid, String enrolDate) {
        if (StringUtils.isNotBlank((String)enrolDate) && !DEFAULT_ENROL_DATE.equals(enrolDate)) {
            eid = eid + enrolDate;
        }
        return eid;
    }
}

