/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.findaadhaar.model;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.ModelBase;
import in.gov.uidai.ec.service.findaadhaar.model.DemographicsSearch;
import in.gov.uidai.ec.service.findaadhaar.model.IdentifierSearch;
import in.gov.uidai.ec.service.findaadhaar.model.SearchType;

public class AadhaarSearch
extends ModelBase<AadhaarSearch> {
    private final DemographicsSearch demographicsSearch;
    private final IdentifierSearch identifierSearch;
    private SearchType searchType;

    public AadhaarSearch(IResourceBundleContext resBundleCtxt) {
        super(resBundleCtxt);
        this.demographicsSearch = new DemographicsSearch(resBundleCtxt);
        this.identifierSearch = new IdentifierSearch(resBundleCtxt);
        this.demographicsSearch.addValidityChangeListener(this::onAadhaarSearchChange);
        this.identifierSearch.addValidityChangeListener(this::onAadhaarSearchChange);
        this.clear();
    }

    private void onAadhaarSearchChange(boolean isValid) {
        if (this.searchType.isDemographics()) {
            this.setValid(this.demographicsSearch.isValid());
        } else if (this.searchType.isIdentifier()) {
            this.setValid(this.identifierSearch.isValid());
        }
    }

    public void selectDemoGraphics() {
        this.searchType = SearchType.DEMOGRAPHICS;
        this.clear();
        this.setValid(this.demographicsSearch.isValid());
    }

    public void selectIdentifier() {
        this.searchType = SearchType.IDENTIFIER;
        this.clear();
        this.setValid(this.identifierSearch.isValid());
    }

    public DemographicsSearch getDemographicsSearch() {
        return this.demographicsSearch;
    }

    public IdentifierSearch getIdentifierSearch() {
        return this.identifierSearch;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    private void clear() {
        this.demographicsSearch.clear();
        this.identifierSearch.clear();
    }
}

