/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.findaadhaar.model;

import in.gov.uidai.ec.icas.util.Verhoeff;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysEnrol;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.findaadhaar.model.Validation;
import in.gov.uidai.ec.service.findaadhaar.model.ValidationCriteria;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class FindAadhaarValidationFactory {
    public static Validation nameValidation(String name) {
        ValidationBuilder nameValidation = new ValidationBuilder();
        nameValidation.next(FindAadhaarValidationFactory.valueIsMandatory(name), (Object)MsgKeysILV.MANDATORY).next(FindAadhaarValidationFactory.valueCanNotBeLessThanTwoChars(name), (Object)MsgKeysEnrol.NAME_TOOSHORT_WARNING).next(FindAadhaarValidationFactory.valueContainsCharacters(name), (Object)MsgKeysEnrol.NAME_INVALID_WARNING).next(FindAadhaarValidationFactory.valueDoesntBeginWithSpecialCharacters(name), (Object)MsgKeysEnrol.NAME_INVALID_WARNING);
        return nameValidation.build();
    }

    public static Validation careOfValidation(String careOf) {
        ValidationBuilder nameValidation = new ValidationBuilder();
        nameValidation.next(FindAadhaarValidationFactory.canBeBlank(careOf)).next(FindAadhaarValidationFactory.valueCanNotBeLessThanTwoChars(careOf), (Object)MsgKeysEnrol.NAME_TOOSHORT_WARNING).next(FindAadhaarValidationFactory.valueContainsCharacters(careOf), (Object)MsgKeysEnrol.NAME_INVALID_WARNING).next(FindAadhaarValidationFactory.valueDoesntBeginWithSpecialCharacters(careOf), (Object)MsgKeysEnrol.NAME_INVALID_WARNING);
        return nameValidation.build();
    }

    public static Validation genderValidation(String name) {
        ValidationBuilder genderValidation = new ValidationBuilder();
        genderValidation.next(FindAadhaarValidationFactory.valueIsMandatory(name), (Object)MsgKeysILV.MANDATORY).next(FindAadhaarValidationFactory.cannotHaveDefaultComboBoxValue(name), (Object)MsgKeysILV.MANDATORY);
        return genderValidation.build();
    }

    public static Validation pinCodeValidation(String pinCode, String district) {
        ValidationBuilder pinCodeValidation = new ValidationBuilder();
        pinCodeValidation.next(FindAadhaarValidationFactory.canBeNotBlank(district)).next(FindAadhaarValidationFactory.valueIsMandatory(pinCode), (Object)MsgKeysILV.MANDATORY).next(FindAadhaarValidationFactory.pinCodeLengthValidation(pinCode), (Object)MsgKeysILV.ADDR_PIN);
        return pinCodeValidation.build();
    }

    public static Validation stateValidation(String name) {
        ValidationBuilder stateValidation = new ValidationBuilder();
        stateValidation.next(FindAadhaarValidationFactory.canBeBlank(name));
        return stateValidation.build();
    }

    public static Validation districtValidation(String district, String pinCode) {
        ValidationBuilder districtValidation = new ValidationBuilder();
        districtValidation.next(FindAadhaarValidationFactory.canBeNotBlank(pinCode)).next(FindAadhaarValidationFactory.valueIsMandatory(district), (Object)MsgKeysILV.MANDATORY).next(FindAadhaarValidationFactory.cannotHaveDefaultComboBoxValue(district), (Object)MsgKeysILV.MANDATORY);
        return districtValidation.build();
    }

    public static Validation eidValidation(String name) {
        ValidationBuilder eid1Validation = new ValidationBuilder();
        eid1Validation.next(FindAadhaarValidationFactory.valueIsMandatory(name), (Object)MsgKeysILV.MANDATORY);
        eid1Validation.next(FindAadhaarValidationFactory.valueIsNotZero(name), (Object)MsgKeysILV.MANDATORY);
        return eid1Validation.build();
    }

    public static Validation enrolmentDateValidation(String name) {
        ValidationBuilder eid2Validation = new ValidationBuilder();
        eid2Validation.next(FindAadhaarValidationFactory.canBeBlank(name));
        eid2Validation.next(FindAadhaarValidationFactory.valueCanBeZero(name), (Object)MsgKeysILV.MANDATORY);
        eid2Validation.next(FindAadhaarValidationFactory.shouldBeValidDate(name), (Object)MsgKeysILV.DATE);
        return eid2Validation.build();
    }

    public static Validation uidValidation(String name) {
        ValidationBuilder uidValidation = new ValidationBuilder();
        uidValidation.next(FindAadhaarValidationFactory.valueIsMandatory(name), (Object)MsgKeysILV.MANDATORY);
        uidValidation.next(FindAadhaarValidationFactory.canNotBeginWithZeroOrOne(name), (Object)MsgKeysILV.ZERO);
        uidValidation.next(FindAadhaarValidationFactory.isValidUidFormat(name), (Object)MsgKeysILV.UID);
        return uidValidation.build();
    }

    public static Validation mobileNumberValidation(String number) {
        ValidationBuilder mobileNumberValidation = new ValidationBuilder();
        mobileNumberValidation.next(FindAadhaarValidationFactory.canBeBlank(number)).next(FindAadhaarValidationFactory.cannotHaveLessThanTenChars(number), (Object)MsgKeysILV.MOBILE_LENGTH);
        return mobileNumberValidation.build();
    }

    public static Validation yobValidation(String yob) {
        ValidationBuilder yobValidation = new ValidationBuilder();
        yobValidation.next(FindAadhaarValidationFactory.canBeBlank(yob));
        return yobValidation.build();
    }

    public static Validation yobTypeValidation(String yob) {
        ValidationBuilder yobTypeValidation = new ValidationBuilder();
        yobTypeValidation.next(FindAadhaarValidationFactory.canBeBlank(yob));
        return yobTypeValidation.build();
    }

    public static Validation emailValidation(String email) {
        ValidationBuilder emailValidation = new ValidationBuilder();
        emailValidation.next(FindAadhaarValidationFactory.canBeBlank(email)).next(FindAadhaarValidationFactory.emailShouldHaveAtSymbolAndDot(email), (Object)MsgKeysILV.EMAIL_MANCHAR).next(FindAadhaarValidationFactory.hasValidEmailPattern(email), (Object)MsgKeysILV.EMAIL_INVALID);
        return emailValidation.build();
    }

    static ValidationCriteria canBeBlank(final String val) {
        return new ValidationCriteria(){

            @Override
            public boolean isValid() {
                return StringUtils.isBlank((String)val);
            }

            @Override
            public boolean needNextValidation() {
                return false;
            }
        };
    }

    static ValidationCriteria canBeNotBlank(final String val) {
        return new ValidationCriteria(){

            @Override
            public boolean isValid() {
                return !StringUtils.isBlank((String)val);
            }

            @Override
            public boolean needNextValidation() {
                return false;
            }
        };
    }

    static ValidationCriteria isValidUidFormat(String uid) {
        return () -> Verhoeff.validate((String)uid);
    }

    static ValidationCriteria cannotHaveLessThanTenChars(String mobile) {
        return () -> mobile.length() >= 10;
    }

    static ValidationCriteria emailShouldHaveAtSymbolAndDot(String email) {
        return () -> email.indexOf(64) >= 0 && email.indexOf(46) >= 0;
    }

    static ValidationCriteria pinCodeLengthValidation(String name) {
        return () -> name.length() == 6;
    }

    static ValidationCriteria hasValidEmailPattern(String email) {
        String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        return () -> Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$").matcher(email).matches();
    }

    static ValidationCriteria valueIsMandatory(String name) {
        return () -> StringUtils.isNotBlank((String)name);
    }

    static ValidationCriteria valueIsNotZero(String name) {
        return () -> !name.trim().matches("0+");
    }

    static ValidationCriteria valueCanBeZero(final String name) {
        return new ValidationCriteria(){

            @Override
            public boolean isValid() {
                return name.matches("0+");
            }

            @Override
            public boolean needNextValidation() {
                return false;
            }
        };
    }

    static ValidationCriteria valueCanNotBeLessThanTwoChars(String name) {
        return () -> name.length() >= 2;
    }

    static ValidationCriteria valueContainsCharacters(String name) {
        return () -> name.matches(".*[a-zA-Z]+.*");
    }

    static ValidationCriteria valueDoesntBeginWithSpecialCharacters(String name) {
        return () -> Stream.of(".", "(", ")", " ").noneMatch(name::startsWith);
    }

    static ValidationCriteria cannotHaveDefaultComboBoxValue(String state) {
        return () -> !state.equals("Select");
    }

    static ValidationCriteria canNotBeginWithZeroOrOne(String value) {
        return () -> !value.startsWith("0") && !value.startsWith("1");
    }

    static ValidationCriteria shouldBeValidDate(String value) {
        return () -> FindAadhaarValidationFactory.isValidDate(value);
    }

    private static boolean isValidDate(String eidDate) {
        SimpleDateFormat dateFmt = new SimpleDateFormat(ECMPDateFormats.FULL_DATE_FORMAT1.getFormat());
        try {
            boolean isDateValid = true;
            Date parsedDate = dateFmt.parse(eidDate);
            if (!dateFmt.format(parsedDate).equals(eidDate) || parsedDate.after(new Date())) {
                isDateValid = false;
            }
            return isDateValid;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private static class ValidationChain {
        private final ValidationCriteria criteria;
        private final Object messageKey;
        private ValidationChain next;

        private ValidationChain(ValidationCriteria criteria, Object messageKey) {
            this.criteria = criteria;
            this.messageKey = messageKey;
        }

        public Object getErrorMessage() {
            return this.messageKey;
        }

        private ValidationChain checkForFailedValidation() {
            if (this.criteria.isValid()) {
                if (this.criteria.needNextValidation()) {
                    return this.next != null ? this.next.checkForFailedValidation() : null;
                }
                return null;
            }
            if (!this.criteria.needNextValidation()) {
                return this.next != null ? this.next.checkForFailedValidation() : null;
            }
            return this;
        }

        public ValidationChain next(ValidationCriteria criteria, Object messageKey) {
            this.next = new ValidationChain(criteria, messageKey);
            return this.next;
        }

        public Validation getValidation() {
            return new Validation(){
                ValidationChain failedValidation;

                @Override
                public Object getErrorKey() {
                    return this.failedValidation != null ? this.failedValidation.getErrorMessage() : null;
                }

                @Override
                public boolean isValid() {
                    this.failedValidation = this.checkForFailedValidation();
                    return this.failedValidation == null;
                }
            };
        }
    }

    public static class ValidationBuilder {
        private ValidationChain firstValidation;
        private ValidationChain next;

        public ValidationBuilder next(ValidationCriteria criteria, Object messageKey) {
            this.next = this.firstValidation == null ? (this.firstValidation = new ValidationChain(criteria, messageKey)) : this.next.next(criteria, messageKey);
            return this;
        }

        public ValidationBuilder next(ValidationCriteria criteria) {
            return this.next(criteria, null);
        }

        public Validation build() {
            return this.firstValidation.getValidation();
        }
    }
}

