/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.findaadhaar.model;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.ModelBase;
import in.gov.uidai.ec.service.findaadhaar.model.FindAadhaarValidationFactory;
import in.gov.uidai.ec.service.findaadhaar.model.IdentifierSelection;
import in.gov.uidai.ec.service.findaadhaar.model.ValidatableModel;
import in.gov.uidai.ec.service.findaadhaar.model.ValidationProvider;

public class IdentifierSearch
extends ModelBase<IdentifierSearch> {
    private final IResourceBundleContext resBundleCtxt;
    private ValidatableModel enrolId;
    private ValidatableModel enrolmentDate;
    private ValidatableModel uid;
    private IdentifierSelection selection;

    IdentifierSearch(IResourceBundleContext resBundleCtxt) {
        super(resBundleCtxt);
        this.resBundleCtxt = resBundleCtxt;
        this.enrolId = this.getInstanceOfValidatableData(() -> FindAadhaarValidationFactory.eidValidation(this.enrolId.getValue()), this::identifierSearchValidityChange);
        this.enrolmentDate = this.getInstanceOfValidatableData(() -> FindAadhaarValidationFactory.enrolmentDateValidation(this.enrolmentDate.getValue()), this::identifierSearchValidityChange);
        this.uid = this.getInstanceOfValidatableData(() -> FindAadhaarValidationFactory.uidValidation(this.uid.getValue()), this::identifierSearchValidityChange);
        this.clear();
    }

    public void selectUid() {
        this.selection = IdentifierSelection.UID;
        this.clear();
    }

    public void selectEnrolId() {
        this.selection = IdentifierSelection.ENROL_ID;
        this.clear();
    }

    private ValidatableModel getInstanceOfValidatableData(ValidationProvider provider, ModelBase.IValidityEventListener listener) {
        return new ValidatableModel(this.resBundleCtxt, provider, listener);
    }

    public ValidatableModel getEnrolId() {
        return this.enrolId;
    }

    public ValidatableModel getEnrolmentDate() {
        return this.enrolmentDate;
    }

    public ValidatableModel getUid() {
        return this.uid;
    }

    public void identifierSearchValidityChange(boolean isValid) {
        if (this.selection != null) {
            if (this.selection.isEnrolId()) {
                this.setValid(this.enrolId.isValid() && this.enrolmentDate.isValid());
            } else if (this.selection.isUid()) {
                this.setValid(this.uid.isValid());
            }
        } else {
            this.setValid(false);
        }
    }

    void clear() {
        this.enrolId.setValue(null);
        this.enrolmentDate.setValue(null);
        this.uid.setValue(null);
    }

    public IdentifierSelection getSelection() {
        return this.selection;
    }
}

