/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.gps;

import in.gov.uidai.ec.service.gps.GeoData;
import in.gov.uidai.ec.service.gps.IGpsControl;
import in.gov.uidai.ec.service.gps.IGpsDevicePreference;
import in.gov.uidai.ec.service.gps.IGpsListener;
import in.gov.uidai.ec.service.gps._GpsDeviceManager;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class GpsControl
implements DisposableBean,
IGpsControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(GpsControl.class);
    private _GpsDeviceManager gdm;
    private Timer timer = new Timer("GPS Timer", true);
    private TimerTask conTask;
    private boolean runningFlag;

    public GpsControl() {
        this.gdm = new _GpsDeviceManager();
        this.addGpsListener(new RescheduleHandler());
    }

    public void destroy() {
        this.stop();
    }

    public void setGpsPreference(IGpsDevicePreference pref) {
        this.gdm.setPreference(pref);
    }

    @Override
    public void start() {
        this.runningFlag = true;
        this.rescheduleImpl();
    }

    @Override
    public void stop() {
        this.runningFlag = false;
        if (this.conTask != null) {
            this.conTask.cancel();
            this.conTask = null;
            this.timer.purge();
        }
        this.gdm.disconnect();
    }

    @Override
    public boolean isRunning() {
        return this.runningFlag;
    }

    @Override
    public void addGpsListener(IGpsListener gdl) {
        this.gdm.getMessageListener().addGpsListener(gdl);
    }

    @Override
    public void removeGpsListener(IGpsListener gdl) {
        this.gdm.getMessageListener().removeGpsListener(gdl);
    }

    private void rescheduleImpl() {
        if (this.conTask != null) {
            this.conTask.cancel();
            this.conTask = null;
            this.timer.purge();
        }
        if (this.runningFlag) {
            this.conTask = new GpsConnectTask();
            this.timer.schedule(this.conTask, 10000L);
        }
    }

    private class RescheduleHandler
    implements IGpsListener {
        private RescheduleHandler() {
        }

        @Override
        public void geoDataReceived(GeoData data) {
            LOGGER.debug("received lat:" + data.getLatitude() + ", long: " + data.getLongitude() + ", alt: " + data.getAltitude());
        }

        @Override
        public void deviceRemoved() {
            LOGGER.debug("device removed");
            GpsControl.this.rescheduleImpl();
        }

        @Override
        public void deviceConnected() {
            LOGGER.debug("device connected");
        }
    }

    private class GpsConnectTask
    extends TimerTask {
        private GpsConnectTask() {
        }

        @Override
        public void run() {
            LOGGER.debug("connecting to GPS device");
            GpsControl.this.gdm.connect();
        }
    }
}

