/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.gps;

import in.gov.uidai.ec.service.gps.GeoData;
import org.apache.commons.lang.StringUtils;

class _GeoMessageParser {
    private static final String DELIMITER = ",";
    private static final int GPS_FIX = 1;
    private static final int LAT_POS = 2;
    private static final int LAT_BEARING = 3;
    private static final int LON_POS = 4;
    private static final int LON_BEARING = 5;
    private static final int FIX_QUALITY_POS = 6;
    private static final int ALTITUDE_POS = 9;

    _GeoMessageParser() {
    }

    public GeoData parse(String gpsSentence) {
        String[] gpsSentenceTokens = gpsSentence.split(DELIMITER);
        if (!this.isGeoPositionAvailable(gpsSentenceTokens)) {
            return null;
        }
        return this.getGPSData(gpsSentenceTokens);
    }

    private boolean isGeoPositionAvailable(String[] gpsMessages) {
        int fixQuality = Integer.parseInt(gpsMessages[6]);
        String latitude = gpsMessages[2];
        String longitude = gpsMessages[4];
        return fixQuality >= 1 && !StringUtils.isBlank((String)latitude) && !StringUtils.isBlank((String)longitude);
    }

    private GeoData getGPSData(String[] gpsMessages) {
        GeoData gpsInfo = new GeoData();
        gpsInfo.setLatitude(gpsMessages[2]);
        gpsInfo.setLatBearing(gpsMessages[3]);
        gpsInfo.setLongitude(gpsMessages[4]);
        gpsInfo.setLongBearing(gpsMessages[5]);
        gpsInfo.setAltitude(gpsMessages[9]);
        return gpsInfo;
    }
}

