/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.gps;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import in.gov.uidai.ec.service.gps.IGpsDevicePreference;
import in.gov.uidai.ec.service.gps._GpsMessageListener;
import in.gov.uidai.ec.service.gps._GpsPortFinder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _GpsDeviceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(_GpsDeviceManager.class);
    private _GpsPortFinder portFinder = new _GpsPortFinder();
    private _GpsMessageListener gpsMsgListener = new _GpsMessageListener();
    private IGpsDevicePreference gpsPref;
    private SerialPort serialPort;

    _GpsDeviceManager() {
    }

    public void setPreference(IGpsDevicePreference pref) {
        this.gpsPref = pref;
        this.portFinder.setPreference(this.gpsPref);
    }

    public _GpsMessageListener getMessageListener() {
        return this.gpsMsgListener;
    }

    public void connect() {
        try {
            String gpsPort = this.portFinder.getGpsPort();
            if (!StringUtils.isBlank((String)gpsPort)) {
                CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)gpsPort);
                this.serialPort = (SerialPort)portIdentifier.open(this.gpsPref.getOwnerName(), this.gpsPref.getWaitTime());
                this.serialPort.setSerialPortParams(this.gpsPref.getSpeed(), 8, 1, 0);
                this.gpsMsgListener.connect(this.serialPort);
                this.serialPort.notifyOnDataAvailable(true);
            } else {
                this.disconnect();
            }
        }
        catch (Exception e) {
            LOGGER.error("GPS port not found, please reinsert the device", (Throwable)e);
            this.disconnect();
        }
        LOGGER.debug("connection complete");
    }

    void disconnect() {
        if (this.gpsMsgListener != null) {
            this.gpsMsgListener.disconnect();
        }
        if (this.serialPort != null) {
            this.serialPort.removeEventListener();
            this.serialPort.close();
        }
    }
}

