/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.gps;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import in.gov.uidai.ec.service.gps.IGpsDevicePreference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _GpsPortFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(_GpsPortFinder.class);
    private IGpsDevicePreference gpsPref;

    _GpsPortFinder() {
    }

    public void setPreference(IGpsDevicePreference pref) {
        this.gpsPref = pref;
    }

    String getGpsPort() {
        List<CommPortIdentifier> serialPorts = this.getAvailableSerialPorts();
        for (CommPortIdentifier serialPort : serialPorts) {
            String[] res;
            String gpsMessage = this.getMessageFromPort(serialPort);
            for (String gpsMessagePrefix : res = this.gpsPref.getGPSMessagePrefix().split(";")) {
                if (!StringUtils.contains((String)gpsMessage, (String)gpsMessagePrefix)) continue;
                LOGGER.info("GPS port name : " + serialPort.getName());
                LOGGER.info("GPS message : " + gpsMessage);
                return serialPort.getName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMessageFromPort(CommPortIdentifier portIdentifier) {
        StringBuilder stringBuilder = new StringBuilder();
        SerialPort serialPort = null;
        InputStream serialPortInputStream = null;
        try {
            int data;
            serialPort = (SerialPort)portIdentifier.open(this.gpsPref.getOwnerName(), this.gpsPref.getWaitTime());
            serialPort.setSerialPortParams(this.gpsPref.getSpeed(), 8, 1, 0);
            serialPortInputStream = serialPort.getInputStream();
            while ((data = serialPortInputStream.read()) > -1) {
                stringBuilder.append((char)data);
                if (!stringBuilder.toString().contains("$GNGGA") && !stringBuilder.toString().contains("$GPGGA") || !stringBuilder.toString().endsWith("\n")) continue;
                break;
            }
        }
        catch (PortInUseException portInUseException) {
            LOGGER.error("Port is in use ", (Throwable)portInUseException);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            LOGGER.error("Operation not supported in this port", (Throwable)unsupportedCommOperationException);
        }
        catch (IOException ioException) {
            LOGGER.error("IOException while reading from port", (Throwable)ioException);
        }
        finally {
            if (serialPortInputStream != null) {
                try {
                    serialPortInputStream.close();
                }
                catch (IOException ioException) {
                    LOGGER.error("IOException while closing port", (Throwable)ioException);
                }
            }
            if (serialPort != null) {
                serialPort.close();
            }
        }
        LOGGER.debug("GPS message : " + stringBuilder.toString());
        return stringBuilder.toString();
    }

    private List<CommPortIdentifier> getAvailableSerialPorts() {
        ArrayList<CommPortIdentifier> serialPorts = new ArrayList<CommPortIdentifier>();
        Enumeration portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        while (portIdentifiers.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portIdentifiers.nextElement();
            if (portIdentifier.getPortType() != 1) continue;
            try {
                CommPort commPort = portIdentifier.open(this.gpsPref.getOwnerName(), this.gpsPref.getWaitTime());
                commPort.close();
                serialPorts.add(portIdentifier);
                LOGGER.debug("Available serial port : " + portIdentifier.getName());
            }
            catch (PortInUseException portInUseException) {
                LOGGER.error("Port is in use ", (Throwable)portInUseException);
            }
        }
        return serialPorts;
    }
}

