/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.isd;

import in.gov.uidai.ec.service.isd.IISDService;
import in.gov.uidai.ec.service.isd.ISD;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ISDService
implements IISDService {
    private final String defaultISDCode = "+91";
    private final String indiaISDCode = "+91";
    private final ArrayList<ISD> isdList = new ArrayList<ISD>(Arrays.asList(new ISD("Afghanistan", "+93"), new ISD("Albania", "+355"), new ISD("Algeria", "+213"), new ISD("American Samoa", "+1"), new ISD("Andorra", "+376"), new ISD("Angola", "+244"), new ISD("Anguilla", "+1"), new ISD("Antarctica", "+672"), new ISD("Antigua and Barbuda", "+1"), new ISD("Argentina", "+54"), new ISD("Armenia", "+374"), new ISD("Aruba", "+297"), new ISD("Australia", "+61"), new ISD("Austria", "+43"), new ISD("Azerbaijan", "+994"), new ISD("Bahamas", "+1"), new ISD("Bahrain", "+973"), new ISD("Bangladesh", "+880"), new ISD("Barbados", "+1"), new ISD("Belarus", "+375"), new ISD("Belgium", "+32"), new ISD("Belize", "+501"), new ISD("Benin", "+229"), new ISD("Bermuda", "+1"), new ISD("Bhutan", "+975"), new ISD("Bolivia", "+591"), new ISD("Bosnia and Herzegovina", "+387"), new ISD("Botswana", "+267"), new ISD("Brazil", "+55"), new ISD("British Indian Ocean Territory", "+246"), new ISD("British Virgin Islands", "+1"), new ISD("Brunei", "+673"), new ISD("Bulgaria", "+359"), new ISD("Burkina Faso", "+226"), new ISD("Burundi", "+257"), new ISD("Cambodia", "+855"), new ISD("Cameroon", "+237"), new ISD("Canada", "+1"), new ISD("Cape Verde", "+238"), new ISD("Cayman Islands", "+1"), new ISD("Central African Republic", "+236"), new ISD("Chad", "+235"), new ISD("Chile", "+56"), new ISD("China", "+86"), new ISD("Christmas Island", "+61"), new ISD("Cocos Islands", "+61"), new ISD("Colombia", "+57"), new ISD("Comoros", "+269"), new ISD("Cook Islands", "+682"), new ISD("Costa Rica", "+506"), new ISD("Croatia", "+385"), new ISD("Cuba", "+53"), new ISD("Curacao", "+599"), new ISD("Cyprus", "+357"), new ISD("Czech Republic", "+420"), new ISD("Democratic Republic of the Congo", "+243"), new ISD("Denmark", "+45"), new ISD("Djibouti", "+253"), new ISD("Dominica", "+1"), new ISD("Dominican Republic", "+1"), new ISD("East Timor", "+670"), new ISD("Ecuador", "+593"), new ISD("Egypt", "+20"), new ISD("El Salvador", "+503"), new ISD("Equatorial Guinea", "+240"), new ISD("Eritrea", "+291"), new ISD("Estonia", "+372"), new ISD("Ethiopia", "+251"), new ISD("Falkland Islands", "+500"), new ISD("Faroe Islands", "+298"), new ISD("Fiji", "+679"), new ISD("Finland", "+358"), new ISD("France", "+33"), new ISD("French Polynesia", "+689"), new ISD("Gabon", "+241"), new ISD("Gambia", "+220"), new ISD("Georgia", "+995"), new ISD("Germany", "+49"), new ISD("Ghana", "+233"), new ISD("Gibraltar", "+350"), new ISD("Greece", "+30"), new ISD("Greenland", "+299"), new ISD("Grenada", "+1"), new ISD("Guam", "+1"), new ISD("Guatemala", "+502"), new ISD("Guernsey", "+44"), new ISD("Guinea", "+224"), new ISD("Guinea Bissau", "+245"), new ISD("Guyana", "+592"), new ISD("Haiti", "+509"), new ISD("Honduras", "+504"), new ISD("Hong Kong", "+852"), new ISD("Hungary", "+36"), new ISD("Iceland", "+354"), new ISD("India", "+91"), new ISD("Indonesia", "+62"), new ISD("Iran", "+98"), new ISD("Iraq", "+964"), new ISD("Ireland", "+353"), new ISD("Isle of Man", "+44"), new ISD("Israel", "+972"), new ISD("Italy", "+39"), new ISD("Ivory Coast", "+225"), new ISD("Jamaica", "+1"), new ISD("Japan", "+81"), new ISD("Jersey", "+44"), new ISD("Jordan", "+962"), new ISD("Kazakhstan", "+7"), new ISD("Kenya", "+254"), new ISD("Kiribati", "+686"), new ISD("Kosovo", "+383"), new ISD("Kuwait", "+965"), new ISD("Kyrgyzstan", "+996"), new ISD("Laos", "+856"), new ISD("Latvia", "+371"), new ISD("Lebanon", "+961"), new ISD("Lesotho", "+266"), new ISD("Liberia", "+231"), new ISD("Libya", "+218"), new ISD("Liechtenstein", "+423"), new ISD("Lithuania", "+370"), new ISD("Luxembourg", "+352"), new ISD("Macau", "+853"), new ISD("Macedonia", "+389"), new ISD("Madagascar", "+261"), new ISD("Malawi", "+265"), new ISD("Malaysia", "+60"), new ISD("Maldives", "+960"), new ISD("Mali", "+223"), new ISD("Malta", "+356"), new ISD("Marshall Islands", "+692"), new ISD("Mauritania", "+222"), new ISD("Mauritius", "+230"), new ISD("Mayotte", "+262"), new ISD("Mexico", "+52"), new ISD("Micronesia", "+691"), new ISD("Moldova", "+373"), new ISD("Monaco", "+377"), new ISD("Mongolia", "+976"), new ISD("Montenegro", "+382"), new ISD("Montserrat", "+1"), new ISD("Morocco", "+212"), new ISD("Mozambique", "+258"), new ISD("Myanmar", "+95"), new ISD("Namibia", "+264"), new ISD("Nauru", "+674"), new ISD("Nepal", "+977"), new ISD("Netherlands", "+31"), new ISD("Netherlands Antilles", "+599"), new ISD("New Caledonia", "+687"), new ISD("New Zealand", "+64"), new ISD("Nicaragua", "+505"), new ISD("Niger", "+227"), new ISD("Nigeria", "+234"), new ISD("Niue", "+683"), new ISD("North Korea", "+850"), new ISD("Northern Mariana Islands", "+1"), new ISD("Norway", "+47"), new ISD("Oman", "+968"), new ISD("Pakistan", "+92"), new ISD("Palau", "+680"), new ISD("Palestine", "+970"), new ISD("Panama", "+507"), new ISD("Papua New Guinea", "+675"), new ISD("Paraguay", "+595"), new ISD("Peru", "+51"), new ISD("Philippines", "+63"), new ISD("Pitcairn", "+64"), new ISD("Poland", "+48"), new ISD("Portugal", "+351"), new ISD("Puerto Rico", "+1"), new ISD("Qatar", "+974"), new ISD("Republic of the Congo", "+242"), new ISD("Reunion", "+262"), new ISD("Romania", "+40"), new ISD("Russia", "+7"), new ISD("Rwanda", "+250"), new ISD("Saint Barthelemy", "+590"), new ISD("Saint Helena", "+290"), new ISD("Saint Kitts and Nevis", "+1"), new ISD("Saint Lucia", "+1"), new ISD("Saint Martin", "+590"), new ISD("Saint Pierre and Miquelon", "+508"), new ISD("Saint Vincent and the Grenadines", "+1"), new ISD("Samoa", "+685"), new ISD("San Marino", "+378"), new ISD("Sao Tome and Principe", "+239"), new ISD("Saudi Arabia", "+966"), new ISD("Senegal", "+221"), new ISD("Serbia", "+381"), new ISD("Seychelles", "+248"), new ISD("Sierra Leone", "+232"), new ISD("Singapore", "+65"), new ISD("Sint Maarten", "+1"), new ISD("Slovakia", "+421"), new ISD("Slovenia", "+386"), new ISD("Solomon Islands", "+677"), new ISD("Somalia", "+252"), new ISD("South Africa", "+27"), new ISD("South Korea", "+82"), new ISD("South Sudan", "+211"), new ISD("Spain", "+34"), new ISD("Sri Lanka", "+94"), new ISD("Sudan", "+249"), new ISD("Suriname", "+597"), new ISD("Svalbard and Jan Mayen", "+47"), new ISD("Swaziland", "+268"), new ISD("Sweden", "+46"), new ISD("Switzerland", "+41"), new ISD("Syria", "+963"), new ISD("Taiwan", "+886"), new ISD("Tajikistan", "+992"), new ISD("Tanzania", "+255"), new ISD("Thailand", "+66"), new ISD("Togo", "+228"), new ISD("Tokelau", "+690"), new ISD("Tonga", "+676"), new ISD("Trinidad and Tobago", "+1"), new ISD("Tunisia", "+216"), new ISD("Turkey", "+90"), new ISD("Turkmenistan", "+993"), new ISD("Turks and Caicos Islands", "+1"), new ISD("Tuvalu", "+688"), new ISD("U.S Virgin Islands", "+1"), new ISD("Uganda", "+256"), new ISD("Ukraine", "+380"), new ISD("United Arab Emirates", "+971"), new ISD("United Kingdom", "+44"), new ISD("United States", "+1"), new ISD("Uruguay", "+598"), new ISD("Uzbekistan", "+998"), new ISD("Vanuatu", "+678"), new ISD("Vatican", "+379"), new ISD("Venezuela", "+58"), new ISD("Vietnam", "+84"), new ISD("Wallis and Futuna", "+681"), new ISD("Western Sahara", "+212"), new ISD("Yemen", "+967"), new ISD("Zambia", "+260"), new ISD("Zimbabwe", "+263")));

    @Override
    public List<ISD> getISDCodes() {
        return this.isdList;
    }

    @Override
    public ISD getDefaultSelect() {
        return this.getISDByCode("+91");
    }

    @Override
    public ISD getISDByCode(String isdCode) {
        List defaultSelectedISDs = this.isdList.stream().filter(isd -> isd.getISDCode().equalsIgnoreCase(isdCode)).collect(Collectors.toList());
        if (defaultSelectedISDs.size() >= 1) {
            return (ISD)defaultSelectedISDs.get(0);
        }
        return this.getDefaultSelect();
    }

    @Override
    public int getDefaultSelectIndex() {
        ISD defaultSelect = this.getDefaultSelect();
        return this.isdList.indexOf(defaultSelect);
    }

    @Override
    public String IndiaISDCode() {
        return "+91";
    }
}

