/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.machineidentity;

import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.security.impl.Utility;
import in.gov.uidai.ec.security.sapi.IMachineIdentity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxMachineIdentity
implements IMachineIdentity {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinuxMachineIdentity.class);
    private static final String PROCESSOR_ID_CMD = "sudo dmidecode -t 4 | grep ID";
    private static final String HARD_DISK_SERIAL_NO_CMD = "sudo hdparm -i /dev/sda";
    private static final String IFCONFIG_CMD = "ifconfig eth0";
    private static final String SYSTEM_UUID_CMD = "sudo dmidecode -t 1 | grep UUID";
    private static final String SYSTEM_SERIAL_NO_CMD = "sudo dmidecode -s system-serial-number";
    private static final String MANUFACTURER_NAME_CMD = "sudo dmidecode -t 1 | grep Manufacturer";
    private static final String[] INVALID_OEM_NAMES = new String[]{"Not Available", "NA", "To be filled by", "Provided by"};
    private String machineId;
    private String machineHash;
    private String oemName;

    public String getUniqueMachineId() {
        if (this.machineId == null) {
            this.machineId = this.getOEMName() + this.getUniqueMachineHash();
        }
        LOGGER.debug("getUniqueMachineId method machineId: " + this.machineId);
        return this.machineId;
    }

    public String getUniqueMachineHash() {
        if (this.machineHash != null) {
            LOGGER.debug("getUniqueMachineHash method machineHash: " + this.machineHash);
            return this.machineHash;
        }
        try {
            String macID = this.getLinuxMacAddress();
            String processorID = this.getProcessorId();
            String hardDiskSerialNumber = this.getLinuxHardDiskSerialNo();
            String systemUuid = this.getSystemUuid();
            String systemSerialNo = this.getSystemSerialNo();
            String uniqueSysID = macID + hardDiskSerialNumber + processorID + systemUuid + systemSerialNo;
            this.machineHash = this.getMachineUuid(uniqueSysID).toUpperCase();
            return this.machineHash;
        }
        catch (Exception exep) {
            LOGGER.error("while generating machine id", (Throwable)exep);
            throw new ClientException(exep.getMessage());
        }
    }

    public String getPrimaryMachineHash() {
        return this.getUniqueMachineHash();
    }

    public String getSecondaryMachineHash() {
        return this.getUniqueMachineHash();
    }

    public String getMachineDetails() {
        String systemSerialNo = this.getProcessorId();
        String macId = this.getLinuxMacAddress();
        String hardDiskSerialNo = this.getLinuxHardDiskSerialNo();
        String processorId = this.getProcessorId();
        return systemSerialNo + "|" + macId + "|" + hardDiskSerialNo + "|" + processorId;
    }

    public void diagnoseChangeInMachineIdentity(String registeredMachineDetails) {
        if (registeredMachineDetails == null) {
            return;
        }
        String calculatedMachineDetails = this.getMachineDetails();
        String[] registeredComponents = registeredMachineDetails.split("\\|");
        String[] calculatedComponents = calculatedMachineDetails.split("\\|");
        for (int i = 0; i < registeredComponents.length; ++i) {
            if (registeredComponents[i].equals(calculatedComponents[i])) continue;
            LOGGER.debug("Component " + (i + 1) + " for calculating machine code doesn't match");
        }
    }

    public String getMachineIdMode() {
        return "primary";
    }

    private String getProcessorId() {
        BufferedReader reader = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(PROCESSOR_ID_CMD);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null && !line.trim().startsWith("ID")) {
            }
            if (Utility.length((String)line) == 0) {
                throw new ClientException("Processor Id not found.");
            }
            String string = line.substring(4).trim();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get Processor Id for the linux machine ::" + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
            }
            catch (IOException iOException) {}
        }
    }

    private String getLinuxHardDiskSerialNo() {
        BufferedReader reader = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(HARD_DISK_SERIAL_NO_CMD);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int index = 0;
            while ((line = reader.readLine()) != null && (index = line.trim().indexOf("SerialNo")) <= -1) {
            }
            if (Utility.length((String)line) == 0) {
                String string = "";
                return string;
            }
            String string = line.substring(index + 10).trim();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get component for machine id ::" + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
            }
            catch (IOException iOException) {}
        }
    }

    private String getLinuxMacAddress() {
        BufferedReader reader = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(IFCONFIG_CMD);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int index = 0;
            String macAddr = "";
            while (!((line = reader.readLine()) == null || (index = line.trim().indexOf("HWaddr")) >= 0 && this.isMacAddressValid(macAddr = line.substring(index + 6).trim()))) {
            }
            if (Utility.length((String)macAddr) == 0) {
                throw new ClientException("Unable to get MACAddress.");
            }
            String string = macAddr;
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to get MAC Address for linux machine ::" + ex.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isMacAddressValid(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private String getSystemUuid() {
        BufferedReader reader = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(SYSTEM_UUID_CMD);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int index = 0;
            while ((line = reader.readLine()) != null && (index = line.trim().indexOf("UUID")) <= -1) {
            }
            if (Utility.length((String)line) == 0) {
                throw new ClientException("Unable to get System UUID.");
            }
            String string = line.substring(index + 7).trim();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get linux system uuid ::" + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
            }
            catch (IOException iOException) {}
        }
    }

    private String getSystemSerialNo() {
        BufferedReader reader = null;
        try {
            Process p = Runtime.getRuntime().exec(SYSTEM_SERIAL_NO_CMD);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null && Utility.length((String)line) == 0) {
            }
            String string = line.trim();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get linux system serial number ::" + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
            }
            catch (IOException iOException) {}
        }
    }

    public String getOEMName() {
        if (this.oemName != null) {
            return this.oemName;
        }
        this.oemName = "";
        BufferedReader reader = null;
        try {
            String manufacturerName;
            String line;
            Process p = Runtime.getRuntime().exec(MANUFACTURER_NAME_CMD);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int index = 0;
            while ((line = reader.readLine()) != null && (index = line.trim().indexOf("Manufacturer")) <= -1) {
            }
            int startIndexForManufacturerName = index + 15;
            if (line != null && Utility.length((String)line) > startIndexForManufacturerName && this.isCorrectOEMName(manufacturerName = line.substring(startIndexForManufacturerName).trim())) {
                this.oemName = manufacturerName.replace(",", "");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get linux Manufacturer Name ::" + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
            }
            catch (IOException iOException) {}
        }
        return this.oemName;
    }

    private boolean isCorrectOEMName(String oemName) {
        for (int i = 0; i < INVALID_OEM_NAMES.length; ++i) {
            if (!INVALID_OEM_NAMES[i].equalsIgnoreCase(oemName) && !INVALID_OEM_NAMES[i].startsWith(oemName) && !INVALID_OEM_NAMES[i].contains(oemName)) continue;
            return false;
        }
        return true;
    }

    private String getMachineUuid(String uniqueId) {
        byte[] machineCode = uniqueId.getBytes();
        byte[] hashSysId = Utility.generateHash((byte[])machineCode);
        String hashedSysId = Utility.byteArrayToHexString((byte[])hashSysId);
        return Utility.convertToUUID((String)hashedSysId.replace("-", ""));
    }
}

