/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.machineidentity;

import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.security.impl.Utility;
import in.gov.uidai.ec.security.sapi.IMachineIdentity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacMachineIdentity
implements IMachineIdentity {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacMachineIdentity.class);
    private static final String IFCONFIG_CMD = "ifconfig en0";
    private static final String PROCESSOR_ID_CMD = "sudo system_profiler SPHardwareDataType | grep Serial";
    private static final String HARD_DISK_SERIAL_NO_CMD = "sudo system_profiler SPSerialATADataType | grep \"Serial Number\"";
    private static final String PROCESSOR_UUID_CMD = "sudo system_profiler SPHardwareDataType | grep UUID";
    private String machineId;
    private String machineHash;

    private static final String getProcessorId() {
        BufferedReader reader = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(PROCESSOR_ID_CMD);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null && !line.trim().startsWith("Serial Number (system): ")) {
            }
            if (Utility.length((String)line) == 0) {
                throw new ClientException("Processor Id not found.");
            }
            String string = line.trim().substring(24).trim();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get Processor Id for the Mac machine ::" + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
            }
            catch (IOException ioe) {
                LOGGER.error("Error when closing the steam", (Throwable)ioe);
            }
        }
    }

    public String getUniqueMachineId() {
        if (this.machineId == null) {
            this.machineId = this.getOEMName() + this.getUniqueMachineHash();
        }
        return this.machineId;
    }

    public String getUniqueMachineHash() {
        if (this.machineHash != null) {
            LOGGER.debug("getUniqueMachineHash method machineHash: " + this.machineHash);
            return this.machineHash;
        }
        String macAddr = this.getMacAddress();
        String processorId = MacMachineIdentity.getProcessorId();
        String hardDiskSerialNumber = this.getMacHardDiskSerialNo();
        String processorUuid = this.getProcessorUuid();
        String uniqueSysID = macAddr + processorId + hardDiskSerialNumber + processorUuid;
        this.machineHash = this.getMachineUuid(uniqueSysID);
        return this.machineHash;
    }

    public String getPrimaryMachineHash() {
        return this.getUniqueMachineHash();
    }

    public String getSecondaryMachineHash() {
        return this.getUniqueMachineHash();
    }

    public String getMachineDetails() {
        String processorId = MacMachineIdentity.getProcessorId();
        String macId = this.getMacAddress();
        String hardDiskSerialNo = this.getMacHardDiskSerialNo();
        String processorUuid = this.getProcessorUuid();
        return processorId + "|" + macId + "|" + hardDiskSerialNo + "|" + processorUuid;
    }

    public void diagnoseChangeInMachineIdentity(String registeredMachineDetails) {
        if (registeredMachineDetails == null) {
            return;
        }
        String systemMachineDetails = this.getMachineDetails();
        String[] registeredComponents = registeredMachineDetails.split("\\|");
        String[] calculatedComponents = systemMachineDetails.split("\\|");
        for (int i = 0; i < registeredComponents.length; ++i) {
            if (registeredComponents[i].equals(calculatedComponents[i])) continue;
            LOGGER.debug("Component " + (i + 1) + " for calculating machine code doesn't match");
        }
    }

    public String getMachineIdMode() {
        return "primary";
    }

    private String getMacAddress() {
        BufferedReader reader = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(IFCONFIG_CMD);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int index = 0;
            String macAddr = "";
            while (!((line = reader.readLine()) == null || (index = line.trim().indexOf("ether")) >= 0 && this.isMacAddressValid(macAddr = line.substring(index + 6).trim()))) {
            }
            if (Utility.length((String)macAddr) == 0) {
                throw new ClientException("Unable to get MACAddress.");
            }
            String string = macAddr;
            return string;
        }
        catch (Exception ex) {
            throw new ClientException("Unable to get MAC Address for Mac machine ::" + ex.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
            }
            catch (IOException ioe) {
                LOGGER.error("Error when closing the steam", (Throwable)ioe);
            }
        }
    }

    private boolean isMacAddressValid(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private String getMacHardDiskSerialNo() {
        BufferedReader reader = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(HARD_DISK_SERIAL_NO_CMD);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int index = 0;
            while ((line = reader.readLine()) != null && (index = line.trim().indexOf("Serial Number:")) <= -1) {
            }
            if (Utility.length((String)line) == 0) {
                String string = "";
                return string;
            }
            String string = line.trim().substring(index + 14).trim();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get mac hard disk serial no ::" + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
            }
            catch (IOException ioe) {
                LOGGER.error("Error when closing the steam", (Throwable)ioe);
            }
        }
    }

    private String getProcessorUuid() {
        BufferedReader reader = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(PROCESSOR_UUID_CMD);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int index = 0;
            while ((line = reader.readLine()) != null && (index = line.trim().indexOf("Hardware UUID:")) <= -1) {
            }
            if (Utility.length((String)line) == 0) {
                String string = "";
                return string;
            }
            String string = line.trim().substring(index + 14).trim();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get linux system uuid ::" + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
            }
            catch (IOException ioe) {
                LOGGER.error("Error when closing the steam", (Throwable)ioe);
            }
        }
    }

    public String getOEMName() {
        return "Apple Computer, Inc.".replace(",", "");
    }

    private String getMachineUuid(String uniqueId) {
        byte[] machineCode = uniqueId.getBytes();
        byte[] hashSysId = Utility.generateHash((byte[])machineCode);
        String hashedSysId = Utility.byteArrayToHexString((byte[])hashSysId);
        return Utility.convertToUUID((String)hashedSysId.replace("-", ""));
    }
}

