/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.machineidentity;

import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.util.OS;
import in.gov.uidai.ec.security.sapi.IMachineIdentity;
import java.util.HashMap;
import java.util.Map;

public class MachineIdentityFactory {
    private static final Map<String, String> CLASS_MAP = new HashMap<String, String>();
    private static IMachineIdentity macIdObj;

    private MachineIdentityFactory() {
    }

    public static IMachineIdentity getIdentity() {
        if (macIdObj == null) {
            macIdObj = MachineIdentityFactory.getIdentInstance();
        }
        return macIdObj;
    }

    private static IMachineIdentity getIdentInstance() {
        try {
            Class<?> classObj = Class.forName(CLASS_MAP.get(OS.getShortName()));
            return (IMachineIdentity)classObj.newInstance();
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage());
        }
    }

    static {
        CLASS_MAP.put(OS.WINDOWS, "in.gov.uidai.ec.service.machineidentity.WindowsMachineIdentity");
        CLASS_MAP.put(OS.LINUX, "in.gov.uidai.ec.service.machineidentity.LinuxMachineIdentity");
        CLASS_MAP.put(OS.MACINTOSH, "in.gov.uidai.ec.service.machineidentity.MacMachineIdentity");
    }
}

