/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.machineidentity;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MachineInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(MachineInfo.class);
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;

    public static void printMachineInfo() {
        try {
            MachineInfo.printLoggedInUserName();
            MachineInfo.printHardwareDetails();
            MachineInfo.printOSDetails();
            MachineInfo.printDiskUsage();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        MachineInfo.monitorCPUAndMemoryUsage();
    }

    public static void monitorCPUAndMemoryUsage() {
        LOGGER.info("***Printing CPU and Memory Usages***");
        try {
            MachineInfo.printCPUUtilisation();
            MachineInfo.printMemoryUsage();
            MachineInfo.printGCStats();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private static void printLoggedInUserName() {
        LOGGER.info("User Name: " + System.getProperty("user.name"));
    }

    private static void printHardwareDetails() {
        LOGGER.info("CPU type: " + System.getenv("PROCESSOR_IDENTIFIER"));
        LOGGER.info("Architecture: " + System.getenv("PROCESSOR_ARCHITEW6432"));
        LOGGER.info("CPU cores: " + Runtime.getRuntime().availableProcessors());
        long memorySize = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
        LOGGER.info(String.format("RAM Size: %.2f GB", (double)memorySize / 1.073741824E9));
    }

    private static void printOSDetails() {
        String os = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String arch = System.getProperty("os.arch");
        LOGGER.info("OS: " + os + ", Version: " + version + ", JVM Arch: " + arch);
    }

    private static void printDiskUsage() {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File[] drives = File.listRoots();
        if (drives != null && drives.length > 0) {
            for (File aDrive : drives) {
                LOGGER.info("Drive : " + aDrive);
                LOGGER.info("\tType: " + fsv.getSystemTypeDescription(aDrive));
                LOGGER.info(String.format("\tTotal space: %.2f GB", (double)aDrive.getTotalSpace() / 1.073741824E9));
                LOGGER.info(String.format("\tFree space: %.2f GB", (double)aDrive.getFreeSpace() / 1.073741824E9));
            }
        }
    }

    private static void printMemoryUsage() {
        Runtime instance = Runtime.getRuntime();
        LOGGER.info("Total Allocated Memory: {} MB", (Object)(instance.totalMemory() / 0x100000L));
        LOGGER.info("Free Memory: {} MB", (Object)(instance.freeMemory() / 0x100000L));
        LOGGER.info("Used Memory: {} MB", (Object)((instance.totalMemory() - instance.freeMemory()) / 0x100000L));
        LOGGER.info("Max available Memory: {} MB", (Object)(instance.maxMemory() / 0x100000L));
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        LOGGER.info("Committed Virtual Memory Size: {} MB", (Object)(osBean.getCommittedVirtualMemorySize() / 0x100000L));
        LOGGER.info("Free Physical Memory Size: {} MB", (Object)(osBean.getFreePhysicalMemorySize() / 0x100000L));
    }

    private static void printGCStats() {
        long totalGarbageCollections = 0L;
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time;
            long count = gc.getCollectionCount();
            if (count >= 0L) {
                totalGarbageCollections += count;
            }
            if ((time = gc.getCollectionTime()) < 0L) continue;
            garbageCollectionTime += time;
        }
        LOGGER.info("Total Garbage Collections: " + totalGarbageCollections);
        LOGGER.info("Total Garbage Collection Time (ms): " + garbageCollectionTime);
    }

    private static void printCPUUtilisation() {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        LOGGER.info(String.format("Current Process CPU Load: %.2f%%", osBean.getProcessCpuLoad() * 100.0));
        LOGGER.info(String.format("System CPU Load: %.2f%%", osBean.getSystemCpuLoad() * 100.0));
    }
}

