/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.machineidentity;

import com.citumpe.ctpTools.jWMI;
import in.gov.uidai.ec.security.impl.HashGeneratorImpl;
import in.gov.uidai.ec.security.sapi.IMachineIdentity;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsMachineIdentity
implements IMachineIdentity {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsMachineIdentity.class);
    private static final String BLANK_STRING = "";
    private static final String MACHINE_ID_TYPE_PRIMARY = "primary";
    private static final String MACHINE_ID_TYPE_SECONDARY = "secondary";
    private static final String[] INVALID_OEM_NAMES = new String[]{"Not Available", "NA", "To be filled by", "Provided by"};
    private String machineId;
    private String machineHash;
    private String oemName = "";
    private String primaryMachineHash = "";
    private String secondaryMachineHash = "";
    private String machineIdRegisteredMode = "";

    private static String getMacAddress(byte[] macBytes) {
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < macBytes.length; ++i) {
            strBuilder.append(String.format("%02X%s", macBytes[i], i < macBytes.length - 1 ? ":" : BLANK_STRING));
        }
        return strBuilder.toString().toUpperCase();
    }

    public final String getUniqueMachineId() throws Exception {
        if (this.machineId != null) {
            LOGGER.debug("getUniqueMachineId method machineId: " + this.machineId);
            return this.machineId;
        }
        String oemName = this.getOEMName();
        this.machineId = oemName + this.getUniqueMachineHash();
        if (oemName.equals(BLANK_STRING)) {
            LOGGER.warn("OEM name is a blank value");
        }
        return this.machineId;
    }

    public final String getPrimaryMachineHash() {
        if (!this.primaryMachineHash.isEmpty()) {
            return this.primaryMachineHash;
        }
        String biosSerial = this.getWindowsBiosSerialNo();
        boolean isBIOSDefault = this.isDefaultString(biosSerial);
        if (isBIOSDefault) {
            LOGGER.warn("BIOS serial number is a default value");
        }
        byte[] machineCode = biosSerial.getBytes();
        this.primaryMachineHash = this.hash(machineCode);
        return this.primaryMachineHash;
    }

    public final String getSecondaryMachineHash() throws Exception {
        if (!this.secondaryMachineHash.isEmpty()) {
            return this.secondaryMachineHash;
        }
        String macID = this.getWindowsEthernetMacAddress();
        String processorID = this.getProcessorSerialNo();
        String hardDiskSerialNumber = this.getWindowsHardDiskSerialNo();
        String uniqueSysID = macID + hardDiskSerialNumber + processorID;
        if (this.isDefaultString(uniqueSysID)) {
            LOGGER.warn("Secondary combination for machine ID appears to be a default value");
        }
        byte[] machineCode = uniqueSysID.getBytes();
        this.secondaryMachineHash = this.hash(machineCode);
        return this.secondaryMachineHash;
    }

    public String getMachineDetails() {
        String macId;
        String biosSerialNo = this.getWindowsBiosSerialNo();
        String hardDiskSerialNo = this.getWindowsHardDiskSerialNo();
        String processorSerialNo = this.getProcessorSerialNo();
        try {
            macId = this.getWindowsEthernetMacAddress();
        }
        catch (Exception e) {
            macId = BLANK_STRING;
        }
        this.machineIdRegisteredMode = MACHINE_ID_TYPE_PRIMARY;
        if (StringUtils.isEmpty((String)biosSerialNo) || !this.isAlphaNumericOrNumeric(biosSerialNo) || this.isDefaultString(biosSerialNo)) {
            this.machineIdRegisteredMode = MACHINE_ID_TYPE_SECONDARY;
        }
        return biosSerialNo + "|" + macId + "|" + hardDiskSerialNo + "|" + processorSerialNo;
    }

    public void diagnoseChangeInMachineIdentity(String registeredMachineDetails) {
        if (registeredMachineDetails == null) {
            return;
        }
        String systemMachineDetails = this.getMachineDetails();
        String[] calculatedComponents = systemMachineDetails.split("\\|");
        String[] registeredComponents = registeredMachineDetails.split("\\|");
        if (LOGGER.isDebugEnabled()) {
            for (int i = 0; i < registeredComponents.length; ++i) {
                if (registeredComponents[i].equals(calculatedComponents[i])) continue;
                LOGGER.debug("Component " + (i + 1) + " for calculating machine code doesn't match");
            }
        }
    }

    public String getMachineIdMode() {
        return this.machineIdRegisteredMode;
    }

    public final String getUniqueMachineHash() throws Exception {
        if (this.machineHash != null) {
            LOGGER.debug("getUniqueMachineHash method machineHash:" + this.machineHash);
            return this.machineHash;
        }
        String biosSerial = this.getWindowsBiosSerialNo();
        boolean isBIOSDefault = this.isDefaultString(biosSerial);
        if (!this.isAlphaNumericOrNumeric(biosSerial) || isBIOSDefault) {
            if (isBIOSDefault) {
                LOGGER.warn("primary combination is a default value. Attempting new combination for machine ID");
            }
            this.machineIdRegisteredMode = MACHINE_ID_TYPE_SECONDARY;
            this.machineHash = this.getSecondaryMachineHash();
            LOGGER.debug("getUniqueMachineId method secondary :" + this.machineHash);
        } else {
            this.machineIdRegisteredMode = MACHINE_ID_TYPE_PRIMARY;
            this.machineHash = this.getPrimaryMachineHash();
            LOGGER.debug("getUniqueMachineId method primary :" + this.machineHash);
        }
        return this.machineHash;
    }

    private String hash(byte[] bytes) {
        HashGeneratorImpl hashGen = new HashGeneratorImpl();
        byte[] hashSysId = hashGen.generateHash(bytes);
        String hashedSysId = this.byteArrayToHexString(hashSysId);
        return this.convertToUUID(hashedSysId.replace("-", BLANK_STRING)).toUpperCase();
    }

    boolean isDefaultString(String uniqueSysID) {
        if (StringUtils.isEmpty((String)uniqueSysID)) {
            return true;
        }
        int length = uniqueSysID.length();
        char[] defaultValueArray = new char[length];
        Arrays.fill(defaultValueArray, '0');
        String defaultValueString = new String(defaultValueArray);
        return defaultValueString.equals(uniqueSysID);
    }

    private String getProcessorSerialNo() {
        String serialnum = BLANK_STRING;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"wmic", "cpu", "get", "processorid"});
            process.getOutputStream().close();
            Scanner sc1 = new Scanner(process.getInputStream());
            String property = sc1.next();
            serialnum = sc1.next();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get primary component for machine id");
        }
        return serialnum.trim();
    }

    private String getWindowsHardDiskSerialNo() {
        Process hdd = null;
        StringBuilder output = new StringBuilder(BLANK_STRING);
        try {
            String line;
            hdd = Runtime.getRuntime().exec(new String[]{"wmic", "path", "win32_physicalmedia", "get", "serialnumber"});
            BufferedReader input = new BufferedReader(new InputStreamReader(hdd.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (line.contains("Microsoft") || line.equals(BLANK_STRING)) continue;
                output.append(line).append("\r\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hdd != null) {
            hdd.destroy();
            hdd = null;
        }
        if (output.toString().contains("SerialNumber")) {
            output = new StringBuilder(output.toString().replaceFirst("SerialNumber", BLANK_STRING));
        }
        return output.toString().trim();
    }

    private String getWindowsBiosSerialNo() {
        String serialNumber = BLANK_STRING;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"wmic", "bios", "get", "serialnumber"});
            process.getOutputStream().close();
            Scanner sc = new Scanner(process.getInputStream());
            String property = sc.next();
            try {
                serialNumber = sc.next();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isEmpty((String)serialNumber) || !this.isAlphaNumericOrNumeric(serialNumber)) {
                return " ";
            }
        }
        catch (Exception e) {
            LOGGER.debug("primary machine code calculation exception" + e);
        }
        return serialNumber;
    }

    private String getWindowsEthernetMacAddress() throws Exception {
        Enumeration<NetworkInterface> inetAddresses = NetworkInterface.getNetworkInterfaces();
        ArrayList<String> addresses = new ArrayList<String>();
        while (inetAddresses.hasMoreElements()) {
            byte[] macBytes = inetAddresses.nextElement().getHardwareAddress();
            if (macBytes == null) continue;
            addresses.add(WindowsMachineIdentity.getMacAddress(macBytes));
        }
        Collections.sort(addresses);
        if (((String)addresses.get(0)).equals(BLANK_STRING)) {
            addresses.remove(0);
        }
        return (String)addresses.get(0);
    }

    private String convertToUUID(String convertString) {
        return convertString.substring(0, 8) + "-" + convertString.substring(8, 12) + "-" + convertString.substring(12, 16) + "-" + convertString.substring(16, 20) + "-" + convertString.substring(20, 32);
    }

    private String byteArrayToHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public String getOEMName() {
        String oem = BLANK_STRING;
        if (!this.oemName.equals(BLANK_STRING)) {
            return this.oemName;
        }
        try {
            oem = jWMI.getWMIValue((String)"Select Manufacturer from Win32_BIOS", (String)"Manufacturer");
        }
        catch (Exception ioe) {
            LOGGER.error("Error retrieving OEM name.");
        }
        this.oemName = this.isOEMNameCorrect(oem) ? oem.replace(",", BLANK_STRING) : BLANK_STRING;
        return this.oemName;
    }

    private boolean isOEMNameCorrect(String oemName) {
        for (String element : INVALID_OEM_NAMES) {
            if (!element.equalsIgnoreCase(oemName) && !element.startsWith(oemName) && !element.contains(oemName)) continue;
            return false;
        }
        return true;
    }

    private boolean isAlphaNumericOrNumeric(String num) {
        String pattern = "^[0-9A-Za-z-]*$";
        String numRegex = "(.)*(\\d)(.)*";
        if (num.matches(numRegex) && num.matches(pattern)) {
            return true;
        }
        LOGGER.info("isAlphaNumericOrNumeric pattern does not match:");
        return false;
    }
}

