/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.migration;

import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.service.presync.OpSyncDetailsMapper;
import in.gov.uidai.ec.service.session.IOperatorSyncDAO;
import in.gov.uidai.ec.service.session.OperatorDetails;
import in.gov.uidai.ec.service.session.OperatorDetailsInputStream;
import in.gov.uidai.ec.service.session.OperatorDetailsSer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class OperatorDetailsMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorDetailsMigration.class);
    private final EnrolServiceClientApiService enrolServiceClientApiService;
    private final IOperatorSyncDAO operatorSyncDAO;

    OperatorDetailsMigration(EnrolServiceClientApiService enrolServiceClientApiService, IOperatorSyncDAO operatorSyncDAO) {
        this.enrolServiceClientApiService = enrolServiceClientApiService;
        this.operatorSyncDAO = operatorSyncDAO;
    }

    void run() throws IOException {
        List<String> operatorIds = this.operatorSyncDAO.getOpIds();
        Map operatorDetails = this.enrolServiceClientApiService.fetchOperatorDetailsInBatch(operatorIds);
        HashMap<String, OperatorDetails> idToDetails = new HashMap<String, OperatorDetails>();
        operatorDetails.forEach((id, details) -> {
            if (details != null) {
                return;
            }
            OperatorDetailsSer opDetailsSer = this.operatorSyncDAO.fetchOpDetails((String)id);
            try {
                OperatorDetails opDetails = (OperatorDetails)new OperatorDetailsInputStream(new ByteArrayInputStream(opDetailsSer.getOtherDetails())).readObject();
                idToDetails.put((String)id, opDetails);
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.error("deserialize operator details from database failed", (Throwable)e);
            }
        });
        if (!idToDetails.isEmpty()) {
            OpSyncDetailsMapper mapper = new OpSyncDetailsMapper();
            this.enrolServiceClientApiService.storeOperatorDetailsInBatch(mapper.convertToOperatorInfoMap(idToDetails));
        }
    }
}

