/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.onboarding;

import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.ecmpapi.CIDRStatus;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.PidType;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncRequest;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncResponse;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.escapi.StoreOperatorDetailException;
import in.gov.uidai.ec.service.onboarding.IOnboardingAdminService;
import in.gov.uidai.ec.service.onboarding.IUserCredentialsDAO;
import in.gov.uidai.ec.service.onboarding.OnboardingStatus;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.presync.PreSyncDelegate;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.verification.VerificationService;
import in.gov.uidai.lvs.model.RegistrationResult;
import in.gov.uidai.lvs.model.RegistrationStatus;
import in.gov.uidai.lvs.spi.ILocalVerificationService;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnboardingAdminService
implements IOnboardingAdminService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnboardingAdminService.class);
    private IUserCredentialsDAO userCredentialsDAO;
    private VerificationService verificationService;
    private IRegistrationService registrationService;
    private EcmpApiService ecmpApiService;
    private PreSyncDelegate preSyncDelegate;

    public void setPreSyncDelegate(PreSyncDelegate preSyncDelegate) {
        this.preSyncDelegate = preSyncDelegate;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void setUserCredentialsDAO(IUserCredentialsDAO userCredentialsDAO) {
        this.userCredentialsDAO = userCredentialsDAO;
    }

    public void setVerificationService(VerificationService verificationService) {
        this.verificationService = verificationService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    @Override
    public void load(URL location, boolean mandatoryUID) {
        this.userCredentialsDAO.load(location, mandatoryUID);
    }

    @Override
    public OnboardingStatus onboardUser(String uid, String userId, String userType, List<BiometricTemplate> biometricTemplates, List<BiometricTemplate> isoTemplates, List<UserCredentials> opList, ILocalVerificationService lvs) throws IOException, StationInfoStoreException {
        OnboardingStatus onBoardStatus;
        RegistrationResult registrationResult = this.registerUser(uid, userType, biometricTemplates, isoTemplates, lvs);
        switch (registrationResult.getStatus()) {
            case SUCCESS: {
                CIDRStatus preSyncStatus;
                try {
                    PreSyncRequest preSyncRequest = this.preSyncDelegate.prepareServiceRequest(userId, opList, true);
                    PreSyncResponse preSyncResponse = this.ecmpApiService.preSyncClient(preSyncRequest);
                    this.preSyncDelegate.storeOperatorDetails(preSyncResponse);
                    preSyncStatus = this.preSyncDelegate.processServiceResponse(preSyncResponse);
                }
                catch (IOException e) {
                    LOGGER.error("Error during pre-sync", (Throwable)e);
                    preSyncStatus = CIDRStatus.NETWORK_ERROR;
                }
                catch (StationInfoStoreException | StoreOperatorDetailException e) {
                    LOGGER.error("Error during pre-sync.Unable to store/retrieve station info or operator details via ouc.", e);
                    preSyncStatus = CIDRStatus.OUC_ACCESS_ERROR;
                }
                catch (Exception e) {
                    LOGGER.error("PreSync with Server failed.", (Throwable)e);
                    preSyncStatus = CIDRStatus.LOCAL_DATA_ERROR;
                }
                if (preSyncStatus != CIDRStatus.SUCCESS) {
                    LOGGER.error("Pre sync failed after on boarding. " + preSyncStatus.getDescription());
                    lvs.deleteUser(uid);
                    if (preSyncStatus == CIDRStatus.OUC_ACCESS_ERROR) {
                        onBoardStatus = OnboardingStatus.UNABLE_TO_CONNECT_TO_OUC;
                        break;
                    }
                    onBoardStatus = OnboardingStatus.PRE_SYNC_FAILURE_AFTER_ONBOARDING;
                    break;
                }
                LOGGER.info("Pre sync and on boarding success.");
                this.verificationService.updateChecksumOnOnboarding();
                onBoardStatus = OnboardingStatus.SUCCESS;
                this.registrationService.notifyOperatorOnboarded();
                break;
            }
            case AUTH_FAILED: {
                onBoardStatus = OnboardingStatus.AUTH_FAILED;
                break;
            }
            case DUP_USERID: {
                onBoardStatus = OnboardingStatus.DUP_USERID;
                break;
            }
            case INTERNAL_ERROR: {
                onBoardStatus = OnboardingStatus.INTERNAL_ERROR;
                break;
            }
            case LOCAL_DEDUP_FAILED: {
                onBoardStatus = OnboardingStatus.LOCAL_DEDUP_FAILED;
                break;
            }
            case SEGMENTATION_MISMATCH: {
                onBoardStatus = OnboardingStatus.SEGMENTATION_MISMATCH;
                break;
            }
            case USER_NOT_FOUND: {
                onBoardStatus = OnboardingStatus.USER_NOT_FOUND;
                break;
            }
            default: {
                onBoardStatus = OnboardingStatus.INTERNAL_ERROR;
            }
        }
        return onBoardStatus;
    }

    private RegistrationResult registerUser(String uid, String userType, List<BiometricTemplate> biometricTemplates, List<BiometricTemplate> isoTemplates, ILocalVerificationService lvs) {
        LOGGER.info("Uploading biometrics for local verification.");
        RegistrationResult registrationResult = lvs.addBiometrics(uid, biometricTemplates, isoTemplates);
        LOGGER.info("Checking for local duplicates.");
        ArrayList<BiometricTemplate> dupChkQueue = new ArrayList<BiometricTemplate>(biometricTemplates);
        ArrayList<BiometricTemplate> fingerProbeList = new ArrayList<BiometricTemplate>();
        ArrayList<BiometricTemplate> irisProbeList = new ArrayList<BiometricTemplate>();
        while (!dupChkQueue.isEmpty()) {
            fingerProbeList.clear();
            irisProbeList.clear();
            BiometricTemplate tpl = dupChkQueue.remove(0);
            BiometricTemplate cloneTpl = new BiometricTemplate();
            cloneTpl.setProbeTemplate(tpl.getProbeTemplate());
            cloneTpl.setGalleryTemplate(tpl.getGalleryTemplate());
            cloneTpl.setBiometricPosition(BiometricPosition.UNKNOWN);
            if (tpl.getBiometricPosition() == BiometricPosition.LEFT_IRIS || tpl.getBiometricPosition() == BiometricPosition.RIGHT_IRIS) {
                irisProbeList.add(cloneTpl);
            } else {
                fingerProbeList.add(cloneTpl);
            }
            if (dupChkQueue.isEmpty()) break;
            double fingerMatch = Qssitv.getInst().verifyFinger(fingerProbeList, dupChkQueue);
            double irisMatch = Qssitv.getInst().verifyIris(irisProbeList, dupChkQueue);
            if (!(fingerMatch > 50.0) || !(irisMatch > 50.0)) continue;
            RegistrationResult rr = new RegistrationResult();
            rr.setStatus(RegistrationStatus.LOCAL_DEDUP_FAILED);
            return rr;
        }
        if (registrationResult.getStatus() != RegistrationStatus.PENDING_AUTH) {
            return registrationResult;
        }
        LOGGER.info("Performing authentication against Aadhaar.");
        PidType pidType = PidType.INTRODUCER;
        if ("Operator".equals(userType)) {
            pidType = PidType.OPERATOR;
        } else if ("Supervisor".equals(userType)) {
            pidType = PidType.SUPERVISOR;
        }
        registrationResult = lvs.authenticate(uid, pidType.toString());
        if (registrationResult.getStatus() != RegistrationStatus.SUCCESS) {
            lvs.deleteUser(uid);
        }
        return registrationResult;
    }

    @Override
    public boolean unboardUser(String uid) {
        ILocalVerificationService lvs;
        try {
            lvs = LVSLocator.instance();
        }
        catch (Exception e) {
            LOGGER.error("unable to connect with lvs", (Throwable)e);
            return false;
        }
        boolean deleteUserFlag = lvs.deleteUser(uid);
        if (deleteUserFlag) {
            try {
                this.verificationService.updateChecksumOnOnboarding();
                this.registrationService.notifyOperatorUnboarded();
            }
            catch (StationInfoStoreException e) {
                LOGGER.error("unable to read/write checksum details via Enrol Service Client");
            }
            catch (IOException e) {
                LOGGER.error("unable to connect to Enrol Service Client to read/write checksum details");
            }
            catch (Exception exception) {
                LOGGER.error("unable to calculate checksum");
            }
        }
        return deleteUserFlag;
    }
}

