/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.onboarding;

import in.gov.uidai.ec.biometrics.lvs.LVSException;
import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.onboarding.IUserCredentialsDAO;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.onboarding.UserType;
import in.gov.uidai.lvs.model.OnBoardingStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnboardingService
implements IOnboardingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnboardingService.class);
    private IUserCredentialsDAO userCredentialsDAO;

    public void setUserCredentialsDAO(IUserCredentialsDAO userCredentialsDAO) {
        this.userCredentialsDAO = userCredentialsDAO;
    }

    @Override
    public boolean isUserOnBoarded(String uid) {
        try {
            OnBoardingStatus obStat = OnBoardingStatus.NOT_BOARDED;
            Map userMap = LVSLocator.instance().listUsers();
            if (userMap.containsKey(uid)) {
                obStat = (OnBoardingStatus)userMap.get(uid);
            }
            return obStat.equals((Object)OnBoardingStatus.ONBOARD);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<UserCredentials> getAllOnboardedUsers() {
        ArrayList<UserCredentials> onboardedUsers = new ArrayList<UserCredentials>();
        Map allUsers = new HashMap();
        try {
            allUsers = LVSLocator.instance().listUsers();
        }
        catch (LVSException e) {
            LOGGER.debug("Error while getting onboarded users", (Throwable)e);
        }
        for (UserCredentials cred : this.userCredentialsDAO.getAllUsers()) {
            if (!allUsers.containsKey(cred.getUid())) continue;
            cred.setOnboard(true);
            onboardedUsers.add(cred);
        }
        return onboardedUsers;
    }

    @Override
    public boolean isAnyOperatorOnboarded() {
        return this.getAllOnboardedUsers().size() > 0;
    }

    @Override
    public UserCredentials getUser(String userId) {
        return this.userCredentialsDAO.get(userId);
    }

    @Override
    public List<UserCredentials> getAllUsers() {
        return this.userCredentialsDAO.getAllUsers();
    }

    @Override
    public List<UserCredentials> getAllSupervisors() {
        return this.userCredentialsDAO.listByType(UserType.SUPERVISOR);
    }

    @Override
    public List<UserCredentials> getAllOperators() {
        return this.userCredentialsDAO.listByType(UserType.OPERATOR);
    }
}

