/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.onboarding;

import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.security.impl.SignatureImpl;
import in.gov.uidai.ec.service.onboarding.IUserCredentialsDAO;
import in.gov.uidai.ec.service.onboarding.User;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.onboarding.UserCredentialsList;
import in.gov.uidai.ec.service.onboarding.UserCredentialsTable;
import in.gov.uidai.ec.service.onboarding.UserType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class UserCredentialsDAO
implements IUserCredentialsDAO {
    private UserCredentialsTable userCredentialsTable;

    UserCredentialsDAO() {
    }

    @Override
    public UserCredentials get(String userId) {
        return this.getAllUsers().stream().filter(user -> user.getOperatorId().equals(userId)).findFirst().orElse(null);
    }

    @Override
    public List<UserCredentials> listByType(UserType userType) {
        switch (userType) {
            case SUPERVISOR: {
                return this.userCredentialsTable.getSupervisors();
            }
            case OPERATOR: {
                return this.userCredentialsTable.getOperators();
            }
        }
        return new ArrayList<UserCredentials>();
    }

    @Override
    public List<UserCredentials> getAllUsers() {
        ArrayList<UserCredentials> userCredentialsAll = new ArrayList<UserCredentials>();
        userCredentialsAll.addAll(this.userCredentialsTable.getSupervisors());
        userCredentialsAll.addAll(this.userCredentialsTable.getOperators());
        return userCredentialsAll;
    }

    @Override
    public void load(URL location, boolean mandatoryUID) throws ClientException {
        try {
            if (!this.isValidFile(location)) {
                throw new ClientException("Signature verification failed");
            }
        }
        catch (Exception e) {
            throw new ClientException("", (Throwable)e);
        }
        this.userCredentialsTable = new UserCredentialsTable();
        try {
            for (User user : this.convertXMLStreamToObject(location.openStream()).getUsers()) {
                if (StringUtils.isEmpty((String)user.getAuthId()) || StringUtils.isEmpty((String)user.getId()) || StringUtils.isEmpty((String)user.getName()) || StringUtils.isEmpty((String)user.getType())) {
                    throw new ClientException("Missing mandatory information.");
                }
                if (mandatoryUID && StringUtils.isEmpty((String)user.getUid())) {
                    throw new ClientException("Missing mandatory information.");
                }
                if (user.getType().equals(UserType.SUPERVISOR.toString())) {
                    this.userCredentialsTable.getSupervisors().add(this.getUserCredentials(user));
                    continue;
                }
                if (!user.getType().equals(UserType.OPERATOR.toString())) continue;
                this.userCredentialsTable.getOperators().add(this.getUserCredentials(user));
            }
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    private boolean isValidFile(URL location) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory docBuildFac = DocumentBuilderFactory.newInstance();
        docBuildFac.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        docBuildFac.setFeature("http://xml.org/sax/features/external-general-entities", false);
        docBuildFac.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        docBuildFac.setValidating(true);
        docBuildFac.setNamespaceAware(true);
        Document xmlDoc = docBuildFac.newDocumentBuilder().parse(location.openStream());
        return new SignatureImpl().verify(xmlDoc);
    }

    private UserCredentialsList convertXMLStreamToObject(InputStream inputStream) throws JAXBException, XMLStreamException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);
        return (UserCredentialsList)JAXBContext.newInstance((Class[])new Class[]{UserCredentialsList.class}).createUnmarshaller().unmarshal(xsr);
    }

    private UserCredentials getUserCredentials(User user) {
        UserCredentials uc = new UserCredentials();
        uc.setAuthId(user.getAuthId());
        uc.setFullName(user.getName());
        uc.setType(Integer.parseInt(user.getType()));
        uc.setOperatorId(user.getId());
        uc.setUid(user.getUid());
        uc.setEacode(user.getEacode());
        return uc;
    }
}

