/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.operatordisclosure;

import in.gov.uidai.ec.service.operatordisclosure.DisclosureInfoData;
import in.gov.uidai.ec.service.operatordisclosure.DisclosureProcessor;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisclosurePopupProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisclosurePopupProcessor.class);
    private DisclosureInfoData disclosureInfoData;
    public String operatorId = "";
    private DisclosureProcessor disclosureProcessor;

    public void setDisclosureInfoData(DisclosureInfoData disclosureInfoData) {
        this.disclosureInfoData = disclosureInfoData;
    }

    public void setDisclosureProcessor(DisclosureProcessor disclosureProcessor) {
        this.disclosureProcessor = disclosureProcessor;
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }

    public boolean isDisclosureDone() {
        Map<String, String> disclosureData = this.disclosureInfoData.getDisclosedData();
        try {
            LocalDate yesterdayDate = LocalDate.now().minusDays(1L);
            if (disclosureData.isEmpty()) {
                disclosureData = new HashMap<String, String>();
                disclosureData.put(this.operatorId, yesterdayDate.toString());
                this.disclosureInfoData.setDisclosedData(disclosureData);
                this.disclosureProcessor.writeToDisclosureData();
                return false;
            }
            if (!this.disclosureInfoData.getDisclosedData().containsKey(this.operatorId)) {
                this.disclosureInfoData.getDisclosedData().put(this.operatorId, yesterdayDate.toString());
                this.disclosureProcessor.writeToDisclosureData();
                return false;
            }
            return this.disclosureProcessor.isDisclosureDone(this.operatorId);
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching Operator Disclosure Data", (Throwable)e);
            return true;
        }
    }
}

