/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.operatordisclosure;

import com.fasterxml.jackson.databind.ObjectMapper;
import in.gov.uidai.ec.service.operatordisclosure.DisclosureDatFile;
import in.gov.uidai.ec.service.operatordisclosure.DisclosureInfoData;
import in.gov.uidai.ec.service.session.ISessionService;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisclosureProcessor {
    public DisclosureDatFile disclosureDatFile;
    ObjectMapper objectMapper = new ObjectMapper();
    private DisclosureInfoData disclosureInfoData;
    private ISessionService sessionService;
    private static final Logger LOGGER = LoggerFactory.getLogger(DisclosureProcessor.class);

    public void setDisclosureInfoData(DisclosureInfoData disclosureInfoData) {
        this.disclosureInfoData = disclosureInfoData;
    }

    public DisclosureInfoData getDisclosureInfoData() {
        return this.disclosureInfoData;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void writeToDisclosureData() {
        try {
            String data = this.objectMapper.writeValueAsString(this.disclosureInfoData.getDisclosedData());
            byte[] inMemoryConfig = data.getBytes(StandardCharsets.UTF_8);
            this.disclosureDatFile = new DisclosureDatFile("./bin/disclosed.dat");
            this.disclosureDatFile.write(inMemoryConfig);
        }
        catch (Exception e) {
            LOGGER.error("error while writing disclosure configuration: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readingFromDisclosureDatFile() {
        LOGGER.info("readingFromDisclosureDatFile" + this.disclosureInfoData);
        HashMap<String, String> res = new HashMap();
        try {
            this.disclosureDatFile = new DisclosureDatFile("./bin/disclosed.dat");
            if (this.disclosureDatFile.exists()) {
                String value = new String(this.disclosureDatFile.readWithRecover());
                res = (Map)this.objectMapper.readValue(value, HashMap.class);
                this.disclosureInfoData.setDisclosedData(res);
            }
        }
        catch (Exception e) {
            LOGGER.error("unable to read and decrypt disclosure configuration: {}", (Object)e.getMessage());
        }
        finally {
            Object value = null;
        }
    }

    public boolean isDisclosureDone(String operatorId) {
        if (this.disclosureInfoData != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String todayDateString = formatter.format(LocalDate.now());
            LocalDate todayDate = LocalDate.parse(todayDateString, formatter);
            String lastDisclosureDateString = this.disclosureInfoData.getDisclosedData().get(operatorId);
            LocalDate lastDisclosureDate = LocalDate.parse(lastDisclosureDateString, formatter);
            String disclosureTimeoutDuration = this.sessionService.getDisclosureTimeout() == null ? "1440" : this.sessionService.getDisclosureTimeout();
            Period period = Period.between(lastDisclosureDate, todayDate);
            int timeDifference = period.getDays() * 24 * 60;
            if (timeDifference < Integer.parseInt(disclosureTimeoutDuration)) {
                return true;
            }
        }
        return false;
    }
}

