/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.operatordisclosure;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.impl.DeviceLifeCycleListener;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.api.PositionHintType;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.BioVerify;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.BioVerifyRequest;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.BioVerifyResponse;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.Pid;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.PidType;
import in.gov.uidai.ec.ecmpapi.xml.disclosure.DisclosedPackets;
import in.gov.uidai.ec.ecmpapi.xml.disclosure.DisclosureRequest;
import in.gov.uidai.ec.ecmpapi.xml.disclosure.DisclosureResponse;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.BioMetricType1;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.security.impl.RecoverableFileException;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.operatordisclosure.DisclosureInfoData;
import in.gov.uidai.ec.service.operatordisclosure.DisclosureProcessor;
import in.gov.uidai.ec.service.operatordisclosure.MissingEIDFile;
import in.gov.uidai.ec.service.opsync.OperatorSyncService;
import in.gov.uidai.ec.service.opsync.OperatorSyncState;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.ISessionService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.beans.factory.annotation.Autowired;

public class OperatorDiscService
extends OperatorSyncService {
    private static final String UDCParamValue = "UIDAI:UCLServer";
    private static final String TidParamValue = "registered";
    private static final String META_UDC = "UIDAI\\:SampleClient";
    private static final String TID = "registered";
    private DeviceLifeCycleListener deviceLifeCycleListener;
    private ISessionService sessionService;
    IResourceBundleContext resourceBundleContext;
    OperatorSyncState operatorSyncState;
    private BiometricsAuthService biometricsAuthService;
    private EcmpApiService ecmpApiService;
    private boolean rdDeviceSelected;
    private IClientDeviceManager devMgr;
    public MissingEIDFile missingEIDFile;
    private static final String CLIENT_TYPE = "ECMP";
    private boolean autoLaunch;
    @Autowired
    private EnrolServiceClientApiService enrolServiceClientApiService;
    private IRegistrationService registrationService;
    private DisclosureInfoData disclosureInfoData;
    private final HashSet<DeviceType> nonRdDeviceList = new HashSet();
    private final HashSet<DeviceType> rdDeviceList = new HashSet();
    private DisclosureProcessor disclosureProcessor;

    @Override
    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    @Override
    public void setBiometricsAuthService(BiometricsAuthService biometricsAuthService) {
        this.biometricsAuthService = biometricsAuthService;
    }

    @Override
    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.devMgr = cdm;
    }

    @Override
    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setDisclosureInfoData(DisclosureInfoData disclosureInfoData) {
        this.disclosureInfoData = disclosureInfoData;
    }

    public void setDisclosureProcessor(DisclosureProcessor disclosureProcessor) {
        this.disclosureProcessor = disclosureProcessor;
    }

    @Override
    public void setFingerAndIrisStatus(boolean fingerEnabled, boolean irisEnabled) {
        this.operatorSyncState.setFingerAndIrisStatus(fingerEnabled, irisEnabled);
    }

    @Override
    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.resourceBundleContext = ctxt;
    }

    @Override
    public void setDeviceLifeCycleListener(DeviceLifeCycleListener deviceLifeCycleListener) {
        this.deviceLifeCycleListener = deviceLifeCycleListener;
    }

    @Override
    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.operatorSyncState = new OperatorSyncState(this.resourceBundleContext);
        this.deviceLifeCycleListener.addDeviceStartedListener(this::onDeviceStarted);
        this.deviceLifeCycleListener.addDeviceStoppedListener(this::onDeviceStopped);
    }

    @Override
    public AuthParamType getAuthParamType() {
        return this.sessionService.getOperatorCredentials().getType() == 0 ? AuthParamType.OPERATOR : AuthParamType.SUPERVISOR;
    }

    public BioVerifyResponse makeBioSubmitCall() throws IOException {
        BioVerify bioVerify = new BioVerify();
        BioVerifyRequest bioverifyRequest = new BioVerifyRequest();
        String uid = this.sessionService.getOperatorCredentials().getUid();
        PidType pidType = this.sessionService.getOperatorCredentials().getType() == 0 ? PidType.valueOf((String)"OPERATOR") : PidType.valueOf((String)"SUPERVISOR");
        Pid pid = new Pid();
        if (this.rdDeviceSelected) {
            if (this.operatorSyncState.isFingerEnabled) {
                String capturedRdPidData = this.biometricsAuthService.getRdAuthBiometrics().getCapRdPid(this.getAuthParamType(), DeviceType.FINGERPRINT_AUTH);
                PositionHintType possition = PositionHintType.LEFT_THUMB;
                pid.setPidType(pidType);
                pid.setOad(Base64.encode((byte[])capturedRdPidData.getBytes()));
                pid.setUdc(META_UDC);
                pid.setTid("registered");
                pid.setUid(uid);
                pid.setModality(BioMetricType1.MULTI_FINGER_MODALITY);
                pid.setPositionHintType(possition);
                bioverifyRequest.getPid().add(pid);
                bioverifyRequest.setClientType(CLIENT_TYPE);
            } else {
                String capturedRdPidData = this.biometricsAuthService.getRdAuthBiometrics().getCapRdPid(this.getAuthParamType(), DeviceType.IRIS_AUTH);
                PositionHintType possition = PositionHintType.LEFT_IRIS;
                pid.setPidType(pidType);
                pid.setOad(Base64.encode((byte[])capturedRdPidData.getBytes()));
                pid.setUdc(META_UDC);
                pid.setTid("registered");
                pid.setUid(uid);
                pid.setModality(BioMetricType1.IIR);
                pid.setPositionHintType(possition);
                bioverifyRequest.getPid().add(pid);
                bioverifyRequest.setClientType(CLIENT_TYPE);
            }
            return this.ecmpApiService.verifyBiometrics(bioverifyRequest, this.rdDeviceSelected);
        }
        if (this.operatorSyncState.isFingerEnabled) {
            pid.setModality(BioMetricType1.FIR);
            pid.setBiometrics(this.rdDeviceSelected ? null : this.biometricsAuthService.getSingleFingerAuth().getCaptureAttempt().getImage().getOriginalData());
            PositionHintType possition = PositionHintType.LEFT_THUMB;
            bioVerify.addPidDetailss(uid, pid.getBiometrics(), pidType, possition, pid.getModality());
        } else {
            pid.setModality(BioMetricType1.IIR);
            pid.setBiometrics(this.rdDeviceSelected ? null : this.biometricsAuthService.getLeftIrisAuth().getCaptureAttempt().getImage().getOriginalData());
            PositionHintType possition = PositionHintType.LEFT_IRIS;
            bioVerify.addPidDetailss(uid, pid.getBiometrics(), pidType, possition, pid.getModality());
        }
        pid.setUid(uid);
        return this.ecmpApiService.verifyBiometrics(bioVerify.getBioVerifyRequest(), this.rdDeviceSelected);
    }

    @Override
    public void onDeviceStarted(DeviceType type) {
        if (type == null) {
            return;
        }
        if (type == DeviceType.IRIS || type == DeviceType.FINGERPRINT) {
            this.nonRdDeviceList.add(type);
        }
        if (type == DeviceType.IRIS_AUTH || type == DeviceType.FINGERPRINT_AUTH) {
            this.rdDeviceList.add(type);
        }
    }

    private void onDeviceStopped(DeviceType type) {
        if (type == null) {
            return;
        }
        if (type == DeviceType.IRIS || type == DeviceType.FINGERPRINT) {
            this.nonRdDeviceList.remove(type);
        }
        if (type == DeviceType.IRIS_AUTH || type == DeviceType.FINGERPRINT_AUTH) {
            this.rdDeviceList.remove(type);
        }
    }

    public DisclosureResponse makeDisclosureRequest(List<DisclosedPackets> disclosedPackets) throws Exception {
        String numberOfEid = this.numberofEids();
        DisclosureRequest disclosureRequest = this.createDisclosureRequest(disclosedPackets, numberOfEid);
        DisclosureResponse disclosureResponse = this.ecmpApiService.makeDisclosureRequest(disclosureRequest);
        return disclosureResponse;
    }

    private String numberofEids() throws RecoverableFileException {
        this.missingEIDFile = new MissingEIDFile("./data/stationData.txt");
        if (this.missingEIDFile.exists()) {
            return new String(this.missingEIDFile.readWithRecover());
        }
        return null;
    }

    private DisclosureRequest createDisclosureRequest(List<DisclosedPackets> disclosedPackets, String numberOfEid) {
        DisclosureRequest disclosureRequest = new DisclosureRequest();
        disclosureRequest.setRegistrarId(this.registrationService.getRegistrarId());
        disclosureRequest.setStationId(this.registrationService.getStationId());
        disclosureRequest.setAgencyCode(this.registrationService.getAgencyId());
        disclosureRequest.setMachineId(this.registrationService.getRegisteredMachineCode());
        disclosureRequest.setAllGeneratedEids(numberOfEid);
        disclosureRequest.setOperatorId(this.sessionService.getOperatorCredentials().getOperatorId());
        disclosureRequest.setDisclosedPackets(disclosedPackets);
        return disclosureRequest;
    }

    public void saveDisclosureDataToLocal() {
        Map<String, String> disclosureData = this.disclosureInfoData.getDisclosedData();
        String currentOperatorId = this.sessionService.getOperatorCredentials().getOperatorId();
        String currentDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        disclosureData.put(currentOperatorId, currentDate);
        this.disclosureProcessor.writeToDisclosureData();
    }

    public boolean nonRdDevicesConnected() {
        return this.nonRdDeviceList.size() > 0;
    }

    @Override
    public boolean isFingerEnabled() {
        return this.operatorSyncState.isFingerEnabled;
    }

    @Override
    public boolean isIrisEnabled() {
        return this.operatorSyncState.isIrisEnabled;
    }

    public boolean isrdDeviceSelected() {
        this.devMgr.refreshDeviceStates();
        this.rdDeviceSelected = !this.nonRdDevicesConnected();
        return this.rdDeviceSelected;
    }
}

