/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.opsync;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.impl.DeviceLifeCycleListener;
import in.gov.uidai.ec.ecmpapi.CIDRStatus;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.api.ApiSessionData;
import in.gov.uidai.ec.ecmpapi.xml.common.ModeType;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.YesOrNo;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.BioMetricType1;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.ClientRDAuthRequest;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.OperatorCenterSyncRequest;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.OperatorCenterSyncResponse;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.OperatorCenterSynchTable;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.Pid;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.PidType;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.PositionHintType;
import in.gov.uidai.ec.ecmpapi.xml.presync.OperatorSynchTable;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncRequest;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncResponse;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.OperatorInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.gps.GeoData;
import in.gov.uidai.ec.service.gps.IGpsPreference;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.opsync.OperatorSyncFieldIdConstants;
import in.gov.uidai.ec.service.opsync.OperatorSyncState;
import in.gov.uidai.ec.service.presync.OpSyncDetailsMapper;
import in.gov.uidai.ec.service.presync.PreSyncDelegate;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.IOperatorSyncDAO;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.service.session.OperatorDetails;
import in.gov.uidai.ec.service.session.OperatorDetailsSer;
import in.gov.uidai.ec.service.session.SessionDataParseException;
import in.gov.uidai.ec.service.session.SessionFileIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class OperatorSyncService
implements InitializingBean,
OperatorSyncFieldIdConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorSyncService.class);
    private static final String UDCParamValue = "UIDAI:UCLServer";
    private static final String TidParamValue = "registered";
    private static final String CLIENT_TYPE = "ECMP";
    private final HashSet<DeviceType> nonRdDeviceList = new HashSet();
    private final HashSet<DeviceType> rdDeviceList = new HashSet();
    OperatorSyncState operatorSyncState;
    IResourceBundleContext resourceBundleContext;
    private EcmpApiService ecmpApiService;
    private PreSyncDelegate preSyncDelegate;
    private ISessionService sessionService;
    private BiometricsAuthService biometricsAuthService;
    private IOnboardingService onboardingService;
    private IRegistrationService registrationService;
    private IOperatorSyncDAO operatorSyncDAO;
    private DeviceLifeCycleListener deviceLifeCycleListener;
    private IGpsPreference gpsPref;
    private IClientDeviceManager devMgr;
    @Autowired
    private EnrolServiceClientApiService enrolServiceClientApiService;
    private boolean rdDeviceSelected;
    private boolean autoLaunch;
    private IOucDataStore oucDataStore;

    public void setPreSyncDelegate(PreSyncDelegate preSyncDelegate) {
        this.preSyncDelegate = preSyncDelegate;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setBiometricsAuthService(BiometricsAuthService biometricsAuthService) {
        this.biometricsAuthService = biometricsAuthService;
    }

    public void setOnboardingService(IOnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setOperatorSyncDAO(IOperatorSyncDAO operatorSyncDAO) {
        this.operatorSyncDAO = operatorSyncDAO;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.resourceBundleContext = ctxt;
    }

    public void setDeviceLifeCycleListener(DeviceLifeCycleListener deviceLifeCycleListener) {
        this.deviceLifeCycleListener = deviceLifeCycleListener;
    }

    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.devMgr = cdm;
    }

    public void setGpsPreference(IGpsPreference pref) {
        this.gpsPref = pref;
    }

    public void setOucDataStore(IOucDataStore dataStore) {
        this.oucDataStore = dataStore;
    }

    public void afterPropertiesSet() throws Exception {
        this.operatorSyncState = new OperatorSyncState(this.resourceBundleContext);
        this.deviceLifeCycleListener.addDeviceStartedListener(this::onDeviceStarted);
        this.deviceLifeCycleListener.addDeviceStoppedListener(this::onDeviceStopped);
    }

    public void init() throws Exception {
        String opMobile;
        this.clear();
        OperatorDetails operatorDetails = this.fetchOperatorDetails();
        UserCredentials credentials = this.sessionService.getOperatorCredentials();
        GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
        String opName = StringUtils.isNotBlank((String)operatorDetails.getOpName()) ? operatorDetails.getOpName() : credentials.getFullName();
        String opUID = StringUtils.isNotBlank((String)operatorDetails.getOpUid()) ? operatorDetails.getOpUid() : credentials.getUid();
        operatorDetails.setOpName(opName);
        operatorDetails.setOpUid(opUID);
        String formattedLat = GeoData.convertCoords(gpsInfo.getLatitude().floatValue()) + " " + this.gpsPref.getLatBearing("N");
        String formattedLong = GeoData.convertCoords(gpsInfo.getLongitude().floatValue()) + " " + this.gpsPref.getLongBearing("E");
        String formattedAlt = GeoData.COORD_FORMAT.format(gpsInfo.getAltitude().floatValue()) + "m";
        operatorDetails.setLatitude(formattedLat);
        operatorDetails.setLongitude(formattedLong);
        operatorDetails.setAltitude(formattedAlt);
        String centerId = operatorDetails.getCenterId();
        if (StringUtils.isEmpty((String)centerId)) {
            operatorDetails.setCenterId("");
        }
        if (StringUtils.isEmpty((String)(opMobile = operatorDetails.getOpMobile()))) {
            operatorDetails.setOpMobile("");
        }
        this.setOperatorDetails(operatorDetails);
        this.getOperatorSyncState().setOpId(credentials.getOperatorId());
    }

    private OperatorDetails fetchOperatorDetails() throws Exception {
        String operatorId = this.sessionService.getOperatorCredentials().getOperatorId();
        OperatorInfo opDetails = this.enrolServiceClientApiService.fetchOperatorDetails(operatorId);
        OperatorDetails operatorDetails = null;
        if (opDetails != null) {
            OpSyncDetailsMapper mapper = new OpSyncDetailsMapper();
            operatorDetails = mapper.convertToOperatorDetails(opDetails);
        }
        if (operatorDetails == null) {
            operatorDetails = new OperatorDetails();
            operatorDetails.setRegistrarName(this.registrationService.getRegistrarId());
            operatorDetails.setEnrolmentAgencyName(this.registrationService.getAgencyId());
            operatorDetails.setStationId(this.registrationService.getStationId());
            operatorDetails.setOpName(this.sessionService.getOperatorCredentials().getFullName());
            operatorDetails.setOpUid(this.sessionService.getOperatorCredentials().getUid());
            operatorDetails.setOpMobile("");
        }
        operatorDetails.setMachineCode(this.registrationService.getRegisteredMachineCode());
        return operatorDetails;
    }

    public OperatorSyncState getOperatorSyncState() {
        return this.operatorSyncState;
    }

    public OperatorDetails getOperatorDetails() {
        return this.operatorSyncState.getOperatorDetails();
    }

    public void setOperatorDetails(OperatorDetails operatorDetails) {
        this.operatorSyncState.setOperatorDetails(operatorDetails);
        this.operatorSyncState.validate();
    }

    public String getOpId() {
        return this.operatorSyncState.opId;
    }

    public String getWhiteListedBEError() {
        return this.operatorSyncState.fieldErrorMap.get("whitelistedBE");
    }

    public String getCenterAddressError() {
        return this.operatorSyncState.fieldErrorMap.get("centerAddress");
    }

    public String getCenterNameError() {
        return this.operatorSyncState.fieldErrorMap.get("centerName");
    }

    public String getCenterTypeError() {
        return this.operatorSyncState.fieldErrorMap.get("centerType");
    }

    public String getPinCodeError() {
        return this.operatorSyncState.fieldErrorMap.get("pinCode");
    }

    public String getVTCError() {
        return this.operatorSyncState.fieldErrorMap.get("vtc");
    }

    public String getPostOfficeError() {
        return this.operatorSyncState.fieldErrorMap.get("postOffice");
    }

    public AuthParamType getAuthParamType() {
        return this.sessionService.getOperatorCredentials().getType() == 0 ? AuthParamType.OPERATOR : AuthParamType.SUPERVISOR;
    }

    public boolean operatorDetailsValid() {
        return this.operatorSyncState != null && this.operatorSyncState.isValid();
    }

    public boolean isFingerEnabled() {
        return this.operatorSyncState.isFingerEnabled;
    }

    public boolean isIrisEnabled() {
        return this.operatorSyncState.isIrisEnabled;
    }

    public boolean areNonRdDevicesConnected() {
        return this.nonRdDeviceList.size() > 0;
    }

    public boolean isAutoLaunchEnabled() {
        return this.autoLaunch;
    }

    public void setCenterName(String value) {
        this.operatorSyncState.operatorDetails.setCenterName(value);
        this.operatorSyncState.validate();
    }

    public void setCenterAddress(String value) {
        this.operatorSyncState.operatorDetails.setCenterAddress(value);
        this.operatorSyncState.validate();
    }

    public void setCenterType(String value) {
        this.operatorSyncState.operatorDetails.setCenterType(value);
        this.operatorSyncState.validate();
    }

    public void setPincode(String value) {
        this.operatorSyncState.operatorDetails.setPincode(value);
        this.operatorSyncState.validate();
    }

    public void setDistrict(String value) {
        this.operatorSyncState.operatorDetails.setDistrict(value);
        this.operatorSyncState.validate();
    }

    public void setState(String value) {
        this.operatorSyncState.operatorDetails.setState(value);
        this.operatorSyncState.validate();
    }

    public void setSubDistrict(String value) {
        this.operatorSyncState.operatorDetails.setSubDistrict(value);
        this.operatorSyncState.validate();
    }

    public void setVtcDetails(String value) {
        this.operatorSyncState.operatorDetails.setVtcDetails(value);
        this.operatorSyncState.validate();
    }

    public void setPostOffice(String value) {
        this.operatorSyncState.operatorDetails.setPostOffice(value);
        this.operatorSyncState.validate();
    }

    public void setWhiteListedForBE(String value) {
        this.operatorSyncState.operatorDetails.setWhiteListedForBE(value);
        this.operatorSyncState.validate();
    }

    public void setFingerAndIrisStatus(boolean fingerEnabled, boolean irisEnabled) {
        this.operatorSyncState.setFingerAndIrisStatus(fingerEnabled, irisEnabled);
    }

    public void storeOperatorSyncDetails(OperatorSynchTable operatorSynchTable) throws IOException {
        if (operatorSynchTable != null) {
            OpSyncDetailsMapper mapper = new OpSyncDetailsMapper();
            OperatorDetails operatorDetails = mapper.convertToOperatorDetails(operatorSynchTable, this.registrationService.getStationId());
            this.enrolServiceClientApiService.storeOperatorDetails(operatorSynchTable.getOperatorId(), mapper.convertToOperatorInfo(this.getOperatorDetails()));
            this.operatorSyncState.setOpId(operatorSynchTable.getOperatorId());
            this.operatorSyncState.setOperatorDetails(operatorDetails);
            OperatorDetailsSer operatorDetailsSer = new OperatorDetailsSer();
            byte[] operatorDetailsByteArray = mapper.convertToOperatorDetailsByteArray(operatorSynchTable, this.registrationService.getStationId());
            operatorDetailsSer.setOtherDetails(operatorDetailsByteArray);
            operatorDetailsSer.setOpId(operatorSynchTable.getOperatorId());
            this.operatorSyncDAO.storeDetails(operatorDetailsSer);
        }
    }

    public void saveOnOTPSubmit() throws IOException {
        String operatorId = this.sessionService.getOperatorCredentials().getOperatorId();
        OpSyncDetailsMapper mapper = new OpSyncDetailsMapper();
        this.enrolServiceClientApiService.storeOperatorDetails(operatorId, mapper.convertToOperatorInfo(this.getOperatorDetails()));
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutStream = new ObjectOutputStream(byteOutputStream);){
            objectOutStream.writeObject(this.getOperatorDetails());
        }
        byteOutputStream.close();
        this.operatorSyncDAO.storeDetails(new OperatorDetailsSer(operatorId, byteOutputStream.toByteArray()));
    }

    public boolean isRdDeviceSelected() {
        return this.rdDeviceSelected;
    }

    public void saveSessionData(ApiSessionData apiSessionData) throws SessionDataParseException, SessionFileIOException {
        this.sessionService.getOperatorLoginDetails().getResumePassword().updateResumePasswordToOtp();
        if (this.sessionService.getOperatorCredentials().isOnboard()) {
            this.sessionService.createPersistentSession(apiSessionData);
        } else {
            this.sessionService.createNonPersistentSession(apiSessionData);
        }
    }

    public void setAutoLaunch(boolean enable) {
        this.autoLaunch = enable;
    }

    public void validateView() {
        this.operatorSyncState.validate();
    }

    public CIDRStatus makePreSyncRequest() throws IOException, StationInfoStoreException {
        PreSyncRequest preSyncRequest = this.preSyncDelegate.prepareServiceRequest(this.sessionService.getOperatorCredentials().getOperatorId(), this.onboardingService.getAllOnboardedUsers(), false);
        PreSyncResponse preSyncResponse = this.ecmpApiService.preSyncClient(preSyncRequest);
        this.storeOperatorSyncDetails(preSyncResponse.getOperatorSynchTable());
        return this.preSyncDelegate.processServiceResponse(preSyncResponse);
    }

    public OperatorCenterSyncResponse makeDetailsSubmitCall() throws DatatypeConfigurationException, IOException, JAXBException {
        this.identifyDeviceType();
        OperatorCenterSyncResponse operatorCenterSyncResponse = this.ecmpApiService.operatorSyncDetailsSubmit(this.prepareOperatorSyncRequest(true), this.rdDeviceSelected);
        LOGGER.info("rdDeviceSelected=" + this.rdDeviceSelected + " this.rdDeviceSelected=" + this.rdDeviceSelected + " operatorCenterSyncResponse txn ==" + operatorCenterSyncResponse.getTxn());
        if (this.rdDeviceSelected && operatorCenterSyncResponse != null) {
            LOGGER.info("inside if loop=" + operatorCenterSyncResponse.getTxn());
            this.operatorSyncState.setOtpTxn(operatorCenterSyncResponse.getTxn());
        }
        return operatorCenterSyncResponse;
    }

    public OperatorCenterSyncResponse makeOTPSubmitCall() throws DatatypeConfigurationException, IOException, JAXBException {
        return this.ecmpApiService.operatorSyncOtpSubmit(this.prepareOperatorSyncRequest(false), this.rdDeviceSelected);
    }

    private OperatorCenterSyncRequest prepareOperatorSyncRequest(boolean otpGenerate) throws JAXBException, DatatypeConfigurationException {
        OperatorCenterSyncRequest request = new OperatorCenterSyncRequest();
        String opUid = this.sessionService.getOperatorCredentials().getUid();
        request.setGenOtpOrVerifyOtp(otpGenerate);
        OpSyncDetailsMapper opSyncDetailsMapper = new OpSyncDetailsMapper();
        OperatorCenterSynchTable opTable = opSyncDetailsMapper.convertToOpSyncTable(this.getOperatorDetails(), this.getOpId());
        request.setOperatorCenterSynchTable(opTable);
        if (this.rdDeviceSelected) {
            request.setModeType(ModeType.ONLINE);
            request.setClientType(CLIENT_TYPE);
        }
        if (otpGenerate) {
            return request;
        }
        Pid pid = new Pid();
        if (this.operatorSyncState.isFingerEnabled) {
            pid.setModality(BioMetricType1.FIR);
            pid.setBiometrics(this.rdDeviceSelected ? null : this.biometricsAuthService.getSingleFingerAuth().getCaptureAttempt().getImage().getOriginalData());
            pid.setPositionHintType(PositionHintType.LEFT_THUMB);
            if (this.rdDeviceSelected) {
                String capturedRdPidData = this.biometricsAuthService.getRdAuthBiometrics().getCapRdPid(this.getAuthParamType(), DeviceType.FINGERPRINT_AUTH);
                pid.setOad(this.getRdPidData(opUid, this.operatorSyncState.getOtpTxn(), new String(Base64.encode((byte[])capturedRdPidData.getBytes())), this.operatorSyncState.isFingerEnabled));
            }
        } else {
            pid.setModality(BioMetricType1.IIR);
            pid.setBiometrics(this.rdDeviceSelected ? null : this.biometricsAuthService.getLeftIrisAuth().getCaptureAttempt().getImage().getOriginalData());
            pid.setPositionHintType(PositionHintType.LEFT_IRIS);
            if (this.rdDeviceSelected) {
                String capturedRdPidData = this.biometricsAuthService.getRdAuthBiometrics().getCapRdPid(this.getAuthParamType(), DeviceType.IRIS_AUTH);
                pid.setOad(this.getRdPidData(opUid, this.operatorSyncState.getOtpTxn(), new String(Base64.encode((byte[])capturedRdPidData.getBytes())), this.operatorSyncState.isFingerEnabled));
            }
        }
        pid.setOtpReceived(this.sessionService.getOperatorLoginDetails().getResumePassword().getOpSyncOtp());
        pid.setUid(this.sessionService.getOperatorCredentials().getUid());
        pid.setPidType(this.sessionService.getOperatorCredentials().getType() == 0 ? PidType.OPERATOR : PidType.SUPERVISOR);
        request.setPid(Collections.singletonList(pid));
        return request;
    }

    private byte[] getRdPidData(String uid, String transactionId, String rdpidxml, boolean isFingerEnabled) throws JAXBException {
        StringWriter stringWriter = new StringWriter();
        ClientRDAuthRequest clientRDAuthRequest = new ClientRDAuthRequest();
        clientRDAuthRequest.setUid(uid);
        clientRDAuthRequest.setTransactionId(transactionId);
        clientRDAuthRequest.setRdpidxml(rdpidxml);
        clientRDAuthRequest.setUdc(UDCParamValue);
        clientRDAuthRequest.setTid(TidParamValue);
        clientRDAuthRequest.setIsBio(YesOrNo.Y);
        clientRDAuthRequest.setIsOtp(YesOrNo.Y);
        clientRDAuthRequest.setIsPa(YesOrNo.N);
        clientRDAuthRequest.setIsPfa(YesOrNo.N);
        clientRDAuthRequest.setIsPi(YesOrNo.N);
        clientRDAuthRequest.setIsPin(YesOrNo.N);
        if (isFingerEnabled) {
            clientRDAuthRequest.setBt("FMR,FIR");
        } else {
            clientRDAuthRequest.setBt("IIR");
        }
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{ClientRDAuthRequest.class}).createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)clientRDAuthRequest, (Writer)stringWriter);
        }
        catch (JAXBException e) {
            throw new JAXBException("Error serializing PID data : " + e.getMessage());
        }
        return stringWriter.toString().getBytes();
    }

    public void clear() {
        this.biometricsAuthService.clear();
        this.operatorSyncState.clear();
        this.autoLaunch = false;
    }

    public void onDeviceStarted(DeviceType type) {
        if (type == null) {
            return;
        }
        if (type == DeviceType.IRIS || type == DeviceType.FINGERPRINT) {
            this.nonRdDeviceList.add(type);
        }
        if (type == DeviceType.IRIS_AUTH || type == DeviceType.FINGERPRINT_AUTH) {
            this.rdDeviceList.add(type);
        }
    }

    private void onDeviceStopped(DeviceType type) {
        if (type == null) {
            return;
        }
        if (type == DeviceType.IRIS || type == DeviceType.FINGERPRINT) {
            this.nonRdDeviceList.remove(type);
        }
        if (type == DeviceType.IRIS_AUTH || type == DeviceType.FINGERPRINT_AUTH) {
            this.rdDeviceList.remove(type);
        }
    }

    private void identifyDeviceType() {
        this.devMgr.refreshDeviceStates();
        this.rdDeviceSelected = !this.areNonRdDevicesConnected();
    }
}

