/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.opsync;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.ModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.opsync.OperatorSyncFieldIdConstants;
import in.gov.uidai.ec.service.session.OperatorDetails;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class OperatorSyncState
extends ModelBase<OperatorSyncState>
implements OperatorSyncFieldIdConstants {
    protected OperatorDetails operatorDetails;
    protected String opId;
    protected HashMap<String, String> fieldErrorMap = new HashMap();
    public boolean isFingerEnabled;
    public boolean isIrisEnabled;
    protected String otpTxn;

    public OperatorSyncState(IResourceBundleContext rbCtx) {
        super(rbCtx);
    }

    public void clear() {
        this.operatorDetails = null;
        this.opId = null;
        this.fieldErrorMap = new HashMap();
        this.isFingerEnabled = false;
        this.isIrisEnabled = false;
        this.otpTxn = null;
        this.validate();
    }

    public void setFingerAndIrisStatus(boolean fingerEnabled, boolean irisEnabled) {
        this.isFingerEnabled = fingerEnabled;
        this.isIrisEnabled = irisEnabled;
    }

    public OperatorDetails getOperatorDetails() {
        return this.operatorDetails;
    }

    public void setOperatorDetails(OperatorDetails operatorDetails) {
        this.operatorDetails = operatorDetails;
        this.validate();
    }

    public String getOpId() {
        return this.opId;
    }

    public void setOpId(String opId) {
        this.opId = opId;
    }

    public String getOtpTxn() {
        return this.otpTxn;
    }

    public void setOtpTxn(String otpTxn) {
        this.otpTxn = otpTxn;
    }

    protected void validate() {
        if (this.operatorDetails == null) {
            this.setValid(false);
            return;
        }
        boolean validateCenterType = this.validateCenterType();
        boolean validateCName = this.validateCName();
        boolean validateAddress = this.validateAddress();
        boolean validatePinCode = this.validatePinCode();
        boolean validatePostOffice = this.validatePostOffice();
        boolean validateVTC = this.validateVTC();
        boolean validateWhiteListedBE = this.validateWhiteListedBE();
        this.setValid(validateCenterType && validateCName && validateAddress && validatePinCode && validateVTC && validatePostOffice && validateWhiteListedBE);
    }

    boolean validateAddress() {
        String centerAddress = this.operatorDetails.getCenterAddress();
        return this.validateText("centerAddress", "Center Address", centerAddress);
    }

    boolean validateCName() {
        String centerName = this.operatorDetails.getCenterName();
        return this.validateText("centerName", "Center Name", centerName);
    }

    boolean validateText(String key, String fieldName, String fieldValue) {
        if (StringUtils.isBlank((String)fieldValue)) {
            this.fieldErrorMap.put(key, this.rbCtx.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]));
            return false;
        }
        if (fieldValue.length() <= 1) {
            this.fieldErrorMap.put(key, "Invalid " + fieldName + "!The minimum length for Center address is 2 characters.");
            return false;
        }
        if (fieldValue.length() > 200) {
            this.fieldErrorMap.put(key, "Invalid " + fieldName + "!The maximum length for Center address is 200 characters.");
            return false;
        }
        this.fieldErrorMap.remove(key);
        return true;
    }

    boolean validatePinCode() {
        if (StringUtils.isBlank((String)this.operatorDetails.getPincode())) {
            this.fieldErrorMap.put("pinCode", this.rbCtx.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]));
            return false;
        }
        this.fieldErrorMap.remove("pinCode");
        return true;
    }

    boolean validateVTC() {
        if (StringUtils.isBlank((String)this.operatorDetails.getVtcDetails())) {
            this.fieldErrorMap.put("vtc", this.rbCtx.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]));
            return false;
        }
        this.fieldErrorMap.remove("vtc");
        return true;
    }

    boolean validatePostOffice() {
        if (StringUtils.isBlank((String)this.operatorDetails.getPostOffice()) || this.operatorDetails.getPostOffice().equalsIgnoreCase("Select")) {
            this.fieldErrorMap.put("postOffice", this.rbCtx.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]));
            return false;
        }
        this.fieldErrorMap.remove("postOffice");
        return true;
    }

    boolean validateWhiteListedBE() {
        String whiteListedForBE = this.operatorDetails.getWhiteListedForBE();
        if (StringUtils.isBlank((String)whiteListedForBE) || whiteListedForBE.equalsIgnoreCase("Select")) {
            this.fieldErrorMap.put("whitelistedBE", this.rbCtx.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]));
            return false;
        }
        this.fieldErrorMap.remove("whitelistedBE");
        return true;
    }

    boolean validateCenterType() {
        String centerType = this.operatorDetails.getCenterType();
        if (StringUtils.isBlank((String)centerType) || centerType.equalsIgnoreCase("Select")) {
            this.fieldErrorMap.put("centerType", this.rbCtx.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]));
            return false;
        }
        this.fieldErrorMap.remove("centerType");
        return true;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.fieldErrorMap.isEmpty();
    }
}

