/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.pac;

import com.fasterxml.jackson.databind.ObjectMapper;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.security.impl.HashGeneratorImpl;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.pac.PacDetail;
import in.gov.uidai.ec.service.pac.PacVerTypeParams;
import in.gov.uidai.ec.service.pac.PaymentAuthException;
import in.gov.uidai.ec.service.pac.PaymentAuthExceptionType;
import in.gov.uidai.ec.service.pac.validatepac.Meta;
import in.gov.uidai.ec.service.pac.validatepac.TransactionInfo;
import in.gov.uidai.ec.service.pac.validatepac.ValidatePACRequest;
import in.gov.uidai.ec.service.pac.validatepac.ValidatePACResponse;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.ISessionService;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaymentAuthService.class);
    private static final String ORGANISATION = "UIDAI";
    private static final String CLIENT = "ECMP";
    private static final String X_PAC_SIGNATURE = "X-PAC-Signature";
    private static final String X_PAC_KEY_VERSION = "X-PAC-Key-Version";
    private EnrollmentService enrollmentService;
    private IRegistrationService registrationService;
    private ISessionService sessionService;
    private boolean isPacValidated;

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public boolean isPacValidated() {
        return this.isPacValidated;
    }

    public void resetPacValidation() {
        this.isPacValidated = false;
    }

    public void makePayment(String pac) throws PaymentAuthException {
        String pacApiUrl = this.sessionService.getPacApiUrl();
        if (StringUtils.isBlank((String)pacApiUrl)) {
            throw new PaymentAuthException(PaymentAuthExceptionType.APIUrlMissing);
        }
        String pacApiKey = this.sessionService.getPacApiKey();
        if (StringUtils.isBlank((String)pacApiKey)) {
            throw new PaymentAuthException(PaymentAuthExceptionType.APIKeyMissing);
        }
        String pacApiKeyVersion = this.sessionService.getPacApiKeyVersion();
        if (StringUtils.isBlank((String)pacApiKeyVersion)) {
            throw new PaymentAuthException(PaymentAuthExceptionType.APIKeyVersionMissing);
        }
        ValidatePACRequest validatePACRequest = new ValidatePACRequest();
        validatePACRequest.setOrg(ORGANISATION);
        Meta meta = new Meta();
        meta.setClient(CLIENT);
        meta.setClientVer(ApplicationVersion.INTERNALVERSION + "-" + ApplicationVersion.DISTRIBUTION);
        meta.setRegistrarcode(this.registrationService.getRegistrarId());
        meta.setEaCode(this.registrationService.getAgencyId());
        meta.setStationId(this.registrationService.getStationId());
        meta.setOperatorId(this.sessionService.getOperatorCredentials().getOperatorId());
        validatePACRequest.setMeta(meta);
        TransactionInfo transactionInfo = new TransactionInfo();
        transactionInfo.setEid(this.enrollmentService.getEnrolId().toString());
        transactionInfo.setPac(pac);
        transactionInfo.setServiceType(this.getServiceType());
        validatePACRequest.setTransactionInfo(transactionInfo);
        this.makePaymentTransactionWithServer(validatePACRequest, pacApiUrl, pacApiKey, pacApiKeyVersion);
    }

    private void makePaymentTransactionWithServer(ValidatePACRequest pacRequest, String url, String apiKey, String apiKeyVersion) throws PaymentAuthException {
        ValidatePACResponse validatePACResponse;
        String responseSignature;
        CloseableHttpResponse response;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost httpRequest = new HttpPost(url);
        try {
            String responseString;
            String jsonRequest = new ObjectMapper().writeValueAsString((Object)pacRequest);
            String pacSignature = new HashGeneratorImpl().encrypt(jsonRequest, apiKey);
            httpRequest.addHeader(X_PAC_SIGNATURE, pacSignature);
            httpRequest.addHeader(X_PAC_KEY_VERSION, apiKeyVersion);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Validate PAC request:\n" + pacRequest);
            }
            httpRequest.setEntity((HttpEntity)new StringEntity(jsonRequest, "application/json", StandardCharsets.UTF_8.displayName()));
            response = client.execute((HttpUriRequest)httpRequest);
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                response.getEntity().writeTo((OutputStream)out);
                responseString = out.toString();
            }
            responseSignature = new HashGeneratorImpl().encrypt(responseString, apiKey);
            LOGGER.info("Validate PAC response:\n" + responseString);
            validatePACResponse = (ValidatePACResponse)new ObjectMapper().readValue(responseString, ValidatePACResponse.class);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            throw new PaymentAuthException(PaymentAuthExceptionType.NetworkError, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new PaymentAuthException(PaymentAuthExceptionType.InternalError, e.getMessage());
        }
        Header signatureHeader = response.getFirstHeader(X_PAC_SIGNATURE);
        if (signatureHeader == null || !signatureHeader.getValue().equalsIgnoreCase(responseSignature)) {
            throw new PaymentAuthException(PaymentAuthExceptionType.InvalidResponseSignature);
        }
        Header responseKeyVersionHeader = response.getFirstHeader(X_PAC_KEY_VERSION);
        if (responseKeyVersionHeader == null || !responseKeyVersionHeader.getValue().equalsIgnoreCase(apiKeyVersion)) {
            throw new PaymentAuthException(PaymentAuthExceptionType.InvalidResponseAPIKeyVersion);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        LOGGER.info("Validate PAC status code:" + statusCode);
        if (statusCode != 200) {
            if (statusCode == 404) {
                throw new PaymentAuthException(PaymentAuthExceptionType.ServerNotFound);
            }
            if (statusCode == 401) {
                throw new PaymentAuthException(PaymentAuthExceptionType.AuthorizationFailure, validatePACResponse.getMsg());
            }
            if (statusCode == 400) {
                throw new PaymentAuthException(PaymentAuthExceptionType.BadRequest, validatePACResponse.getMsg());
            }
            if (statusCode == 503) {
                throw new PaymentAuthException(PaymentAuthExceptionType.ServiceUnavailable, validatePACResponse.getMsg());
            }
            if (statusCode == 406) {
                throw new PaymentAuthException(PaymentAuthExceptionType.NotAcceptable, validatePACResponse.getMsg());
            }
            if (statusCode == 500) {
                throw new PaymentAuthException(PaymentAuthExceptionType.ServerError, validatePACResponse.getMsg());
            }
            if (statusCode == 422) {
                throw new PaymentAuthException(PaymentAuthExceptionType.InvalidRequest, validatePACResponse.getMsg());
            }
            throw new PaymentAuthException(PaymentAuthExceptionType.InternalError, validatePACResponse.getMsg());
        }
        LOGGER.info("Validate PAC request:\n" + pacRequest);
        this.isPacValidated = true;
        LOGGER.info("Pac verification response returned successfully");
    }

    private String getServiceType() {
        Contact contact;
        ArrayList<String> params = new ArrayList<String>();
        if (this.enrollmentService.getDemographics().isUpdated()) {
            params.add(PacVerTypeParams.DEMO_UPDATE.toString());
        }
        if ((contact = this.enrollmentService.getDemographics().getContact()).getEmail().isUpdated() || contact.getMobile().isUpdated()) {
            params.add(PacVerTypeParams.MOB_EMAIL_UPDATE.toString());
        }
        if (this.enrollmentService.getPhotograph().getPhoto().isUpdated()) {
            params.add(PacVerTypeParams.PHOTO_UPDATE.toString());
        }
        if (this.enrollmentService.isOffLineDocumentUpdate() || this.enrollmentService.isDocumentUpdate()) {
            params.add(PacVerTypeParams.DOC_UPDATE.toString());
        }
        return String.join((CharSequence)"|", params);
    }

    public boolean makePacValidateUC() throws PaymentAuthException {
        this.resetPacValidation();
        this.enrollmentService.getPacDetail().setPacSuccess(false);
        PacDetail pacDetail = this.enrollmentService.getPacDetail();
        String pacApiUrl = pacDetail.getPacUrl();
        String pacApiKey = pacDetail.getPacKey();
        String pacApiKeyVersion = pacDetail.getPacVersion();
        String pac = pacDetail.getPacCode();
        ValidatePACRequest validatePACRequest = new ValidatePACRequest();
        validatePACRequest.setOrg(ORGANISATION);
        Meta meta = new Meta();
        meta.setClient(CLIENT);
        meta.setClientVer(ApplicationVersion.INTERNALVERSION + "-" + ApplicationVersion.DISTRIBUTION);
        meta.setRegistrarcode(this.registrationService.getRegistrarId());
        meta.setEaCode(this.registrationService.getAgencyId());
        meta.setStationId(this.registrationService.getStationId());
        meta.setOperatorId(this.enrollmentService.getOAuthSessionService().getOperatorDetails().getOperatorId());
        validatePACRequest.setMeta(meta);
        TransactionInfo transactionInfo = new TransactionInfo();
        transactionInfo.setEid(this.enrollmentService.getSid());
        transactionInfo.setPac(pac);
        transactionInfo.setServiceType(this.getServiceType());
        validatePACRequest.setTransactionInfo(transactionInfo);
        this.makePaymentTransactionWithServer(validatePACRequest, pacApiUrl, pacApiKey, pacApiKeyVersion);
        this.enrollmentService.getPacDetail().setPacSuccess(this.isPacValidated);
        return this.isPacValidated;
    }
}

