/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packet;

import in.gov.uidai.ec.escapi.DerbyDbException;
import in.gov.uidai.ec.service.packet.EnrolSummary;
import in.gov.uidai.ec.service.packet.IEnrolSummaryDAO;
import in.gov.uidai.ec.service.packet.IEnrolVerifyDAO;
import in.gov.uidai.ec.service.packet.IEodIntroducerDAO;
import in.gov.uidai.ec.service.packet.IPacketDemoVerifyDAO;
import in.gov.uidai.ec.service.packet.IPacketStatusDAO;
import in.gov.uidai.ec.service.packet.IPacketSummaryDAO;
import in.gov.uidai.ec.service.packet.IUCPacketSummaryDAO;
import in.gov.uidai.ec.service.packet.IUenrolSummaryDAO;
import in.gov.uidai.ec.service.packet.PacketDemoVerify;
import in.gov.uidai.ec.service.packet.PacketStatus;
import in.gov.uidai.ec.service.packet.PacketSummary;
import in.gov.uidai.ec.service.packet.UCPacketSummary;
import in.gov.uidai.ec.service.packet.UenrolSummary;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EnrolVerifyDAO
implements IEnrolVerifyDAO {
    private IEnrolSummaryDAO enrolSummaryDAO;
    private IUenrolSummaryDAO uenrolSummaryDAO;
    private IPacketSummaryDAO packetSummaryDAO;
    private IPacketStatusDAO packetStatusDAO;
    private IPacketDemoVerifyDAO packetDemoVerifyDAO;
    private IEodIntroducerDAO eodIntroducerDAO;
    private IUCPacketSummaryDAO ucPacketSummaryDAO;

    public final void setEnrolSummaryDAO(IEnrolSummaryDAO enrolSummaryDAO) {
        this.enrolSummaryDAO = enrolSummaryDAO;
    }

    public final void setUenrolSummaryDAO(IUenrolSummaryDAO uenrolSummaryDAO) {
        this.uenrolSummaryDAO = uenrolSummaryDAO;
    }

    public final void setPacketSummaryDAO(IPacketSummaryDAO packetSummaryDAO) {
        this.packetSummaryDAO = packetSummaryDAO;
    }

    public final void setUCPacketSummaryDAO(IUCPacketSummaryDAO ucPacketSummaryDAO) {
        this.ucPacketSummaryDAO = ucPacketSummaryDAO;
    }

    public final void setPacketStatusDAO(IPacketStatusDAO packetStatusDAO) {
        this.packetStatusDAO = packetStatusDAO;
    }

    public final void setPacketDemoVerifyDAO(IPacketDemoVerifyDAO packetDemoVerifyDAO) {
        this.packetDemoVerifyDAO = packetDemoVerifyDAO;
    }

    public final void setEodIntroducerDAO(IEodIntroducerDAO eodIntroducerDAO) {
        this.eodIntroducerDAO = eodIntroducerDAO;
    }

    @Override
    public void addCreate(PacketSummary pktSum, PacketStatus pktStatus, EnrolSummary enrolSum, PacketDemoVerify dv) throws DerbyDbException {
        this.packetSummaryDAO.putPacketSummary(pktSum);
        this.packetStatusDAO.putPacketStatus(pktStatus);
        this.enrolSummaryDAO.putEnrolSummary(enrolSum);
        this.packetDemoVerifyDAO.putPacketDemoVerification(dv);
    }

    @Override
    public void addCreate2(UCPacketSummary pktSum) {
        this.ucPacketSummaryDAO.putUCPacketSummary(pktSum);
    }

    @Override
    public void addUpdate(PacketSummary pktSum, PacketStatus pktStatus, UenrolSummary uenrolSum, PacketDemoVerify dv) throws DerbyDbException {
        this.packetSummaryDAO.putPacketSummary(pktSum);
        this.packetStatusDAO.putPacketStatus(pktStatus);
        this.uenrolSummaryDAO.putUenrolSummary(uenrolSum);
        this.packetDemoVerifyDAO.putPacketDemoVerification(dv);
    }

    @Override
    public void delete(String enrolId) {
        this.enrolSummaryDAO.deleteEnrolSummary(enrolId);
        this.packetStatusDAO.deletePacketStatus(enrolId);
        this.uenrolSummaryDAO.deleteUenrolSummary(enrolId);
        this.eodIntroducerDAO.deleteEodIntroducer(enrolId);
        this.packetDemoVerifyDAO.deletePacketDemoVerification(enrolId);
        this.packetSummaryDAO.deletePacketSummary(enrolId);
    }

    @Override
    public void insertPacketStatus(PacketStatus pktStatus) {
        this.packetStatusDAO.putPacketStatus(pktStatus);
    }
}

